/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.entity;

import com.tac.guns.Config;
import com.tac.guns.common.Gun;
import com.tac.guns.entity.DamageSourceExplosion;
import com.tac.guns.entity.IExplosionProvider;
import com.tac.guns.entity.ProjectileEntity;
import com.tac.guns.item.GunItem;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MissileEntity
extends ProjectileEntity
implements IExplosionProvider {
    private float power;
    private float radius;

    public MissileEntity(EntityType<? extends ProjectileEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    public MissileEntity(EntityType<? extends ProjectileEntity> entityType, World worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun, 0.0f, 0.0f);
        this.power = modifiedGun.getProjectile().getBlastDamage();
        this.radius = modifiedGun.getProjectile().getBlastRadius();
    }

    @Override
    protected void onProjectileTick() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 5; i > 0; --i) {
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197613_f, true, this.func_226277_ct_() - this.func_213322_ci().func_82615_a() / (double)i, this.func_226278_cu_() - this.func_213322_ci().func_82617_b() / (double)i, this.func_226281_cx_() - this.func_213322_ci().func_82616_c() / (double)i, 0.0, 0.0, 0.0);
            }
            if (this.field_70170_p.field_73012_v.nextInt(2) == 0) {
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197601_L, true, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197631_x, true, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vector3d hitVec, Vector3d startVec, Vector3d endVec, boolean headshot) {
        super.onHitEntity(entity, hitVec, startVec, endVec, false);
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, Vector3d hitVec) {
        MissileEntity.createExplosion(this, this.power, this.radius * ((Double)Config.COMMON.missiles.explosionRadius.get()).floatValue(), null);
        this.life = 0;
    }

    @Override
    public void onExpired() {
        MissileEntity.createExplosion(this, this.power, this.radius * ((Double)Config.COMMON.missiles.explosionRadius.get()).floatValue(), null);
    }

    @Override
    public DamageSourceExplosion createDamageSource() {
        ResourceLocation item = this.getWeapon().func_77973_b().getRegistryName();
        return new DamageSourceExplosion((Entity)this.shooter, item);
    }
}

