/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.tac.guns.crafting.WorkbenchRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WorkbenchRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<WorkbenchRecipe> {
    public WorkbenchRecipe read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonArray input = JSONUtils.func_151214_t((JsonObject)json, (String)"materials");
        for (int i = 0; i < input.size(); ++i) {
            int count;
            JsonObject itemObject = input.get(i).getAsJsonObject();
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)itemObject.get("item"));
            try {
                count = JSONUtils.func_151203_m((JsonObject)itemObject, (String)"count");
            }
            catch (JsonSyntaxException e) {
                count = 1;
            }
            builder.add((Object)new Pair((Object)ingredient, (Object)count));
        }
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result entry");
        }
        JsonObject resultObject = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        ItemStack resultItem = ShapedRecipe.func_199798_a((JsonObject)resultObject);
        try {
            resultItem.func_190920_e(JSONUtils.func_151203_m((JsonObject)resultObject, (String)"count"));
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return new WorkbenchRecipe(recipeId, resultItem, (ImmutableList<Pair<Ingredient, Integer>>)builder.build(), group);
    }

    @Nullable
    public WorkbenchRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_218666_n();
        ItemStack result = buffer.func_150791_c();
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int count = buffer.readInt();
            builder.add((Object)new Pair((Object)ingredient, (Object)count));
        }
        return new WorkbenchRecipe(recipeId, result, (ImmutableList<Pair<Ingredient, Integer>>)builder.build(), group);
    }

    public void write(PacketBuffer buffer, WorkbenchRecipe recipe) {
        buffer.func_180714_a(recipe.func_193358_e());
        buffer.func_150788_a(recipe.getItem());
        buffer.func_150787_b(recipe.getMaterials().size());
        for (Pair stack : recipe.getMaterials()) {
            ((Ingredient)stack.getFirst()).func_199564_a(buffer);
            buffer.writeInt(((Integer)stack.getSecond()).intValue());
        }
    }
}

