/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.common.attachments;

import com.tac.guns.common.attachments.CustomModifierData;
import com.tac.guns.common.attachments.perk.BooleanPerk;
import com.tac.guns.common.attachments.perk.DoublePerk;
import com.tac.guns.common.attachments.perk.FloatPerk;
import com.tac.guns.common.attachments.perk.IntPerk;
import com.tac.guns.common.attachments.perk.Perk;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.item.ItemStack;

public class Perks {
    public static List<Perk<?>> perkList = new ArrayList();
    public static BooleanPerk silencedFire = Perks.registerPerk(new BooleanPerk("silencedFire", "perk.tac.silencedv2", CustomModifierData.General::isSilencedFire));
    public static BooleanPerk blastFire = Perks.registerPerk(new BooleanPerk("blastFire", "perk.tac.blastv2", CustomModifierData.General::isBlastFire));
    public static BooleanPerk igniteFire = Perks.registerPerk(new BooleanPerk("igniteFire", "perk.tac.ignitev2", CustomModifierData.General::isIgniteFire));
    public static FloatPerk modifyProjectileBlastDamage = Perks.registerPerk(new FloatPerk("modifyProjectileBlastDamage", "perk.tac.modified_blast_damage.positivev2", "perk.tac.modified_blast_damage.negativev2", Formatter.ROUND_PERCENTAGE_F, CustomModifierData.General::getModifyProjectileBlastDamage));
    public static FloatPerk modifyProjectileArmorIgnore = Perks.registerPerk(new FloatPerk("modifyProjectileArmorIgnore", "perk.tac.modified_armor_ignore.positivev2", "perk.tac.modified_armor_ignore.negativev2", Formatter.ROUND_PERCENTAGE_F, CustomModifierData.General::getModifyProjectileArmorIgnore));
    public static FloatPerk modifyProjectileHeadDamage = Perks.registerPerk(new FloatPerk("modifyProjectileHeadDamage", "perk.tac.modified_head_damage.positivev2", "perk.tac.modified_head_damage.negativev2", Formatter.ROUND_PERCENTAGE_F, CustomModifierData.General::getModifyProjectileHeadDamage));
    public static IntPerk additionalPierce = Perks.registerPerk(new IntPerk("additionalPierce", "perk.tac.additional_pierce.positive", "perk.tac.additional_pierce.negative", Formatter.PIERCE, CustomModifierData.General::getAdditionalPierce));
    public static DoublePerk modifyFireSoundRadius = Perks.registerPerk(new DoublePerk("modifyFireSoundRadius", "perk.tac.sound_radius.positive", "perk.tac.sound_radius.negative", Formatter.ROUND_PERCENTAGE, CustomModifierData.General::getModifyFireSoundRadius, true));
    public static FloatPerk additionalDamage = Perks.registerPerk(new FloatPerk("additionalDamage", "perk.tac.additional_damage.positivev2", "perk.tac.additional_damage.negativev2", Formatter.TO_HEART, CustomModifierData.General::getAdditionalDamage));
    public static FloatPerk additionalHeadshotDamage = Perks.registerPerk(new FloatPerk("additionalHeadshotDamage", "perk.tac.additional_damage.positiveh", "perk.tac.additional_damage.negativeh", Formatter.TO_HEART, CustomModifierData.General::getAdditionalHeadshotDamage));
    public static FloatPerk modifyProjectileDamage = Perks.registerPerk(new FloatPerk("modifyProjectileDamage", "perk.tac.modified_damage.positivev2", "perk.tac.modified_damage.negativev2", Formatter.ROUND_PERCENTAGE_F, CustomModifierData.General::getModifyProjectileDamage));
    public static DoublePerk modifyProjectileSpeed = Perks.registerPerk(new DoublePerk("modifyProjectileSpeed", "perk.tac.projectile_speed.positivev2", "perk.tac.projectile_speed.negativev2", Formatter.ROUND_PERCENTAGE, CustomModifierData.General::getModifyProjectileSpeed));
    public static FloatPerk modifyProjectileSpread = Perks.registerPerk(new FloatPerk("modifyProjectileSpread", "perk.tac.projectile_spread.positivev2", "perk.tac.projectile_spread.negativev2", Formatter.ROUND_PERCENTAGE_F, CustomModifierData.General::getModifyProjectileSpread, true));
    public static FloatPerk modifyFirstShotSpread = Perks.registerPerk(new FloatPerk("modifyFirstShotSpread", "perk.tac.projectile_spread_first.positivev2", "perk.tac.projectile_spread_first.negativev2", Formatter.ROUND_PERCENTAGE_F, CustomModifierData.General::getModifyFirstShotSpread, true));
    public static FloatPerk modifyHipFireSpread = Perks.registerPerk(new FloatPerk("modifyHipFireSpread", "perk.tac.projectile_spread_hip.positivev2", "perk.tac.projectile_spread_hip.negativev2", Formatter.ROUND_PERCENTAGE_F, CustomModifierData.General::getModifyHipFireSpread, true));
    public static FloatPerk recoilModifier = Perks.registerPerk(new FloatPerk("recoilModifier", "perk.tac.recoil.positivev2", "perk.tac.recoil.negativev2", Formatter.ROUND_PERCENTAGE_F, CustomModifierData.General::getRecoilModifier, true));
    public static FloatPerk horizontalRecoilModifier = Perks.registerPerk(new FloatPerk("horizontalRecoilModifier", "perk.tac.recoilh.positivev2", "perk.tac.recoilh.negativev2", Formatter.ROUND_PERCENTAGE_F, CustomModifierData.General::getHorizontalRecoilModifier, true));
    public static DoublePerk modifyAimDownSightSpeed = Perks.registerPerk(new DoublePerk("modifyAimDownSightSpeed", "perk.tac.ads_speed.positivev2", "perk.tac.ads_speed.negativev2", Formatter.ROUND_PERCENTAGE, CustomModifierData.General::getModifyAimDownSightSpeed));
    public static IntPerk additionalAmmunition = Perks.registerPerk(new IntPerk("additionalAmmunition", "", "", null, CustomModifierData.General::getAdditionalAmmunition));
    public static FloatPerk additionalWeaponWeight = Perks.registerPerk(new FloatPerk("additionalWeaponWeight", "perk.tac.additional_weight.positive", "perk.tac.additional_weight.negative", Formatter.WEIGHT, CustomModifierData.General::getAdditionalWeaponWeight, true));
    public static FloatPerk modifyFireSoundVolume = Perks.registerPerk(new FloatPerk("modifyFireSoundVolume", "", "", null, CustomModifierData.General::getModifyFireSoundVolume));
    public static FloatPerk modifyRecoilSmoothening = Perks.registerPerk(new FloatPerk("modifyRecoilSmoothening", "", "", null, CustomModifierData.General::getModifyRecoilSmoothening));
    public static DoublePerk modifyMuzzleFlashSize = Perks.registerPerk(new DoublePerk("modifyMuzzleFlashSize", "", "", null, CustomModifierData.General::getModifyMuzzleFlashSize));
    public static FloatPerk modifyWeaponWeight = Perks.registerPerk(new FloatPerk("modifyWeaponWeight", "perk.tac.modify_weight.positive", "perk.tac.modify_weight.negative", Formatter.WEIGHT_M, CustomModifierData.General::getModifyWeaponWeight, true));
    public static FloatPerk kickModifier = Perks.registerPerk(new FloatPerk("kickModifier", "", "", null, CustomModifierData.General::getKickModifier));

    public static <T extends Perk<?>> T registerPerk(T perk) {
        perkList.add(perk);
        return perk;
    }

    public static void init() {
    }

    public static class Formatter {
        public static Function<Integer, String> PIERCE = value -> ItemStack.field_111284_a.format(Math.abs(value));
        public static Function<Float, String> TO_HEART = value -> ItemStack.field_111284_a.format(Math.abs((double)value.floatValue() / 2.0));
        public static Function<Double, String> ROUND_PERCENTAGE = value -> new DecimalFormat("#.#").format(Math.abs(1.0 - value) * 100.0) + "%";
        public static Function<Float, String> ROUND_PERCENTAGE_F = value -> new DecimalFormat("#.#").format(Math.abs(1.0 - (double)value.floatValue()) * 100.0) + "%";
        public static Function<Float, String> WEIGHT = value -> new DecimalFormat("#.##").format(Math.abs(value.floatValue()));
        public static Function<Float, String> WEIGHT_M = value -> new DecimalFormat("#.#").format(Math.abs(value.floatValue() * 100.0f)) + "%";
    }
}

