/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.render.gun;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.tac.guns.client.gunskin.GunSkin;
import com.tac.guns.client.gunskin.IModelComponent;
import com.tac.guns.client.gunskin.ModelComponent;
import com.tac.guns.client.render.gun.IOverrideModel;
import com.tac.guns.client.util.RenderUtil;
import com.tac.guns.common.Gun;
import com.tac.guns.init.ModItems;
import com.tac.guns.item.attachment.IAttachment;
import com.tac.guns.util.GunModifierHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class SkinAnimationModel
implements IOverrideModel {
    protected Map<IModelComponent, Vector3d> extraOffset = new HashMap<IModelComponent, Vector3d>();
    private static List<SkinAnimationModel> models = new ArrayList<SkinAnimationModel>();

    public SkinAnimationModel() {
        models.add(this);
    }

    public IBakedModel getModelComponent(GunSkin skin, IModelComponent key) {
        return skin == null || skin.getModel(key) == null ? Minecraft.func_71410_x().func_209506_al().func_174951_a() : skin.getModel(key).getModel();
    }

    private void renderComponent(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin, IModelComponent modelComponent) {
        if (this.extraOffset.containsKey(modelComponent)) {
            Vector3d x = this.extraOffset.get(modelComponent);
            matrices.func_227860_a_();
            matrices.func_227861_a_(x.func_82615_a(), x.func_82617_b(), x.func_82616_c());
            RenderUtil.renderModel(this.getModelComponent(skin, modelComponent), stack, matrices, renderBuffer, light, overlay);
            matrices.func_227861_a_(-x.func_82615_a(), -x.func_82617_b(), -x.func_82616_c());
            matrices.func_227865_b_();
        } else {
            RenderUtil.renderModel(this.getModelComponent(skin, modelComponent), stack, matrices, renderBuffer, light, overlay);
        }
    }

    private void renderLaserModuleComponent(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin, IModelComponent modelComponent) {
        if (this.extraOffset.containsKey(modelComponent)) {
            Vector3d x = this.extraOffset.get(modelComponent);
            matrices.func_227860_a_();
            matrices.func_227861_a_(x.func_82615_a(), x.func_82617_b(), x.func_82616_c());
            RenderUtil.renderLaserModuleModel(this.getModelComponent(skin, modelComponent), stack, matrices, renderBuffer, light, overlay);
            matrices.func_227861_a_(-x.func_82615_a(), -x.func_82617_b(), -x.func_82616_c());
            matrices.func_227865_b_();
        } else {
            RenderUtil.renderLaserModuleModel(this.getModelComponent(skin, modelComponent), stack, matrices, renderBuffer, light, overlay);
        }
    }

    protected void renderStockWithDefault(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin) {
        if (Gun.getAttachment(IAttachment.Type.STOCK, stack).func_77973_b() == ModItems.LIGHT_STOCK.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.STOCK_LIGHT);
        } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).func_77973_b() == ModItems.TACTICAL_STOCK.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.STOCK_TACTICAL);
        } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).func_77973_b() == ModItems.WEIGHTED_STOCK.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.STOCK_HEAVY);
        } else {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.STOCK_DEFAULT);
        }
    }

    protected void renderStock(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin) {
        if (Gun.getAttachment(IAttachment.Type.STOCK, stack).func_77973_b() == ModItems.LIGHT_STOCK.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.STOCK_LIGHT);
        } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).func_77973_b() == ModItems.TACTICAL_STOCK.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.STOCK_TACTICAL);
        } else if (Gun.getAttachment(IAttachment.Type.STOCK, stack).func_77973_b() == ModItems.WEIGHTED_STOCK.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.STOCK_HEAVY);
        }
    }

    protected void renderBarrelWithDefault(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin) {
        if (Gun.getAttachment(IAttachment.Type.BARREL, stack).func_77973_b() == ModItems.SILENCER.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MUZZLE_SILENCER);
        } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).func_77973_b() == ModItems.MUZZLE_COMPENSATOR.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MUZZLE_COMPENSATOR);
        } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).func_77973_b() == ModItems.MUZZLE_BRAKE.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MUZZLE_BRAKE);
        } else {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MUZZLE_DEFAULT);
        }
    }

    protected void renderBarrel(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin) {
        if (Gun.getAttachment(IAttachment.Type.BARREL, stack).func_77973_b() == ModItems.SILENCER.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MUZZLE_SILENCER);
        } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).func_77973_b() == ModItems.MUZZLE_COMPENSATOR.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MUZZLE_COMPENSATOR);
        } else if (Gun.getAttachment(IAttachment.Type.BARREL, stack).func_77973_b() == ModItems.MUZZLE_BRAKE.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MUZZLE_BRAKE);
        }
    }

    protected void renderGrip(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin) {
        if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).func_77973_b() == ModItems.SPECIALISED_GRIP.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.GRIP_TACTICAL);
        } else if (Gun.getAttachment(IAttachment.Type.UNDER_BARREL, stack).func_77973_b() == ModItems.LIGHT_GRIP.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.GRIP_LIGHT);
        }
    }

    protected void renderSight(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin) {
        if (Gun.getScope(stack) != null) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.SIGHT_FOLDED);
            this.renderComponent(stack, matrices, renderBuffer, 0xF000F0, overlay, skin, ModelComponent.SIGHT_FOLDED_LIGHT);
        } else {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.SIGHT);
            this.renderComponent(stack, matrices, renderBuffer, 0xF000F0, overlay, skin, ModelComponent.SIGHT_LIGHT);
        }
    }

    protected void renderMag(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin) {
        if (GunModifierHelper.getAmmoCapacityWeight(stack) > -1) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MAG_EXTENDED);
        } else {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MAG_STANDARD);
        }
    }

    protected void renderDrumMag(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin) {
        if (GunModifierHelper.getAmmoCapacityWeight(stack) > -1) {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MAG_DRUM);
        } else {
            this.renderComponent(stack, matrices, renderBuffer, light, overlay, skin, ModelComponent.MAG_STANDARD);
        }
    }

    protected void renderLaserDevice(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin) {
        if (Gun.getAttachment(IAttachment.Type.SIDE_RAIL, stack).func_77973_b() == ModItems.BASIC_LASER.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderLaserModuleComponent(Gun.getAttachment(IAttachment.Type.SIDE_RAIL, stack), matrices, renderBuffer, light, overlay, skin, ModelComponent.LASER_BASIC_DEVICE);
        } else if (Gun.getAttachment(IAttachment.Type.SIDE_RAIL, stack).func_77973_b() != ModItems.IR_LASER.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b()) || Gun.getAttachment(IAttachment.Type.IR_DEVICE, stack).func_77973_b() == ModItems.IR_LASER.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderLaserModuleComponent(Gun.getAttachment(IAttachment.Type.IR_DEVICE, stack), matrices, renderBuffer, light, overlay, skin, ModelComponent.LASER_IR_DEVICE);
        }
    }

    protected void renderLaser(ItemStack stack, MatrixStack matrices, IRenderTypeBuffer renderBuffer, int light, int overlay, GunSkin skin) {
        if (Gun.getAttachment(IAttachment.Type.SIDE_RAIL, stack).func_77973_b() == ModItems.BASIC_LASER.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderLaserModuleComponent(Gun.getAttachment(IAttachment.Type.SIDE_RAIL, stack), matrices, renderBuffer, 0xF000F0, overlay, skin, ModelComponent.LASER_BASIC);
        } else if (Gun.getAttachment(IAttachment.Type.SIDE_RAIL, stack).func_77973_b() != ModItems.IR_LASER.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b()) || Gun.getAttachment(IAttachment.Type.IR_DEVICE, stack).func_77973_b() == ModItems.IR_LASER.orElse((IForgeRegistryEntry)ItemStack.field_190927_a.func_77973_b())) {
            this.renderLaserModuleComponent(Gun.getAttachment(IAttachment.Type.IR_DEVICE, stack), matrices, renderBuffer, 0xF000F0, overlay, skin, ModelComponent.LASER_IR);
        }
    }
}

