/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.tac.guns.client.Keys;
import com.tac.guns.client.handler.AnimationHandler;
import com.tac.guns.client.handler.ShootingHandler;
import com.tac.guns.client.render.animation.module.GunAnimationController;
import com.tac.guns.client.render.animation.module.PumpShotgunAnimationController;
import com.tac.guns.common.Gun;
import com.tac.guns.event.GunFireEvent;
import com.tac.guns.event.GunReloadEvent;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.GunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageReload;
import com.tac.guns.network.message.MessageUnload;
import com.tac.guns.network.message.MessageUpdateGunID;
import com.tac.guns.util.GunModifierHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class ReloadHandler {
    private static ReloadHandler instance;
    private int startReloadTick;
    private int reloadTimer;
    private int prevReloadTimer;
    private int reloadingSlot;
    private int startUpReloadTimer;
    private boolean empty;
    private boolean prevState = false;
    private ItemStack prevItemStack;
    public int rigAmmoCount = 0;

    public static ReloadHandler get() {
        if (instance == null) {
            instance = new ReloadHandler();
        }
        return instance;
    }

    private ReloadHandler() {
        Keys.RELOAD.addPressCallback(() -> {
            if (!Keys.noConflict(Keys.RELOAD)) {
                return;
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof GunItem) {
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageUpdateGunID());
                if (!((Boolean)SyncedPlayerData.instance().get((PlayerEntity)player, ModSyncedDataKeys.RELOADING)).booleanValue()) {
                    ShootingHandler.get().burstTracker = 0;
                    this.setReloading(true);
                } else if (GunAnimationController.fromItem(stack.func_77973_b()) instanceof PumpShotgunAnimationController) {
                    this.setReloading(false);
                }
            }
        });
        Keys.UNLOAD.addPressCallback(() -> {
            if (!Keys.noConflict(Keys.UNLOAD)) {
                return;
            }
            if (!this.isReloading()) {
                SimpleChannel channel = PacketHandler.getPlayChannel();
                channel.sendToServer((Object)new MessageUpdateGunID());
                this.setReloading(false);
                channel.sendToServer((Object)new MessageUnload());
            }
        });
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.prevReloadTimer = this.reloadTimer;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            if (((Boolean)SyncedPlayerData.instance().get((PlayerEntity)player, ModSyncedDataKeys.RELOADING)).booleanValue() && this.reloadingSlot != player.field_71071_by.field_70461_c) {
                this.setReloading(false);
            }
            this.updateReloadTimer((PlayerEntity)player);
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageUpdateGunID());
        }
    }

    private boolean isInGame() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_213279_p != null) {
            return false;
        }
        if (mc.field_71462_r != null) {
            return false;
        }
        if (!mc.field_71417_B.func_198035_h()) {
            return false;
        }
        return mc.func_195544_aj();
    }

    public void setReloading(boolean reloading) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            if (reloading) {
                CompoundNBT tag;
                ItemStack stack;
                this.prevItemStack = stack = player.func_184614_ca();
                if (stack.func_77973_b() instanceof GunItem && (tag = stack.func_77978_p()) != null && !tag.func_150297_b("IgnoreAmmo", 1)) {
                    Gun gun = ((GunItem)stack.func_77973_b()).getModifiedGun(stack);
                    if (tag.func_74762_e("AmmoCount") >= GunModifierHelper.getAmmoCapacity(stack, gun)) {
                        return;
                    }
                    if (!player.func_184812_l_() && Gun.findAmmo((PlayerEntity)player, gun.getProjectile().getItem()).length < 1) {
                        return;
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Pre((PlayerEntity)player, stack))) {
                        return;
                    }
                    SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.RELOADING, (Object)true);
                    PacketHandler.getPlayChannel().sendToServer((Object)new MessageReload(true));
                    AnimationHandler.INSTANCE.onGunReload(true, stack);
                    this.reloadingSlot = player.field_71071_by.field_70461_c;
                    MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent.Post((PlayerEntity)player, stack));
                }
            } else {
                if (this.prevItemStack != null) {
                    AnimationHandler.INSTANCE.onGunReload(false, this.prevItemStack);
                }
                SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.RELOADING, (Object)false);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageReload(false));
                this.reloadingSlot = -1;
            }
        }
    }

    private void updateReloadTimer(PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (((Boolean)SyncedPlayerData.instance().get(player, ModSyncedDataKeys.RELOADING)).booleanValue()) {
            CompoundNBT tag;
            this.prevState = true;
            if (stack.func_77973_b() instanceof GunItem && (tag = stack.func_77978_p()) != null) {
                Gun gun = ((GunItem)stack.func_77973_b()).getModifiedGun(stack);
                if (this.startUpReloadTimer == -1) {
                    this.startUpReloadTimer = gun.getReloads().getPreReloadPauseTicks();
                }
                if (gun.getReloads().isMagFed()) {
                    if (this.startUpReloadTimer == 0) {
                        if (this.startReloadTick == -1) {
                            this.startReloadTick = player.field_70173_aa + 5;
                        }
                        if (tag.func_74762_e("AmmoCount") <= 0) {
                            if (this.reloadTimer < gun.getReloads().getReloadMagTimer() + gun.getReloads().getAdditionalReloadEmptyMagTimer()) {
                                ++this.reloadTimer;
                            }
                        } else if (this.reloadTimer < gun.getReloads().getReloadMagTimer()) {
                            ++this.reloadTimer;
                        }
                    } else {
                        --this.startUpReloadTimer;
                    }
                } else if (gun.getReloads().isStripperClip()) {
                    if (this.startUpReloadTimer == 0) {
                        if (this.startReloadTick == -1) {
                            this.startReloadTick = player.field_70173_aa + 5;
                        }
                        if (GunModifierHelper.getAmmoCapacity(stack, gun) - tag.func_74762_e("AmmoCount") > gun.getReloads().getStripperClipReloadAmount()) {
                            if (this.reloadTimer < gun.getReloads().getAdditionalReloadEmptyMagTimer()) {
                                ++this.reloadTimer;
                            }
                        } else {
                            if (this.reloadTimer < gun.getReloads().getinterReloadPauseTicks()) {
                                ++this.reloadTimer;
                            }
                            if (this.reloadTimer == gun.getReloads().getinterReloadPauseTicks()) {
                                this.reloadTimer = 0;
                            }
                        }
                    } else {
                        --this.startUpReloadTimer;
                    }
                } else if (this.startUpReloadTimer == 0) {
                    if (this.startReloadTick == -1) {
                        this.startReloadTick = player.field_70173_aa + 5;
                    }
                    if (this.reloadTimer < gun.getReloads().getinterReloadPauseTicks() && !AnimationHandler.INSTANCE.isReloadingIntro(this.prevItemStack.func_77973_b())) {
                        ++this.reloadTimer;
                    }
                    if (this.reloadTimer == gun.getReloads().getinterReloadPauseTicks()) {
                        AnimationHandler.INSTANCE.onReloadLoop(this.prevItemStack.func_77973_b());
                        this.reloadTimer = 0;
                    }
                } else {
                    --this.startUpReloadTimer;
                }
            }
        } else {
            if (this.prevState) {
                this.prevState = false;
                AnimationHandler.INSTANCE.onReloadEnd(this.prevItemStack.func_77973_b());
            }
            if (stack.func_77973_b() instanceof GunItem) {
                Gun gun = ((GunItem)stack.func_77973_b()).getModifiedGun(stack);
                if (gun.getReloads().isMagFed()) {
                    if (this.startReloadTick != -1) {
                        this.startReloadTick = -1;
                    }
                    if (this.reloadTimer > 0) {
                        this.reloadTimer = 0;
                    }
                } else {
                    if (this.startReloadTick != -1) {
                        this.startReloadTick = -1;
                    }
                    if (this.reloadTimer > 0) {
                        --this.reloadTimer;
                    }
                }
            } else {
                if (this.startReloadTick != -1) {
                    this.startReloadTick = -1;
                }
                if (this.reloadTimer > 0) {
                    this.reloadTimer = 0;
                }
            }
        }
    }

    public int getStartReloadTick() {
        return this.startReloadTick;
    }

    public int getReloadTimer() {
        return this.reloadTimer;
    }

    public int getStartUpReloadTimer() {
        return this.startUpReloadTimer;
    }

    public boolean isReloading() {
        return this.startReloadTick != -1;
    }

    public float getReloadProgress(float partialTicks, ItemStack stack) {
        boolean isEmpty = false;
        GunItem gunItem = (GunItem)stack.func_77973_b();
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            isEmpty = tag.func_74762_e("AmmoCount") <= 0;
        }
        return this.startUpReloadTimer == 0 ? this.getReloadProgressPerType(gunItem, isEmpty, partialTicks) : 1.0f;
    }

    private float getReloadProgressPerType(GunItem gunItem, boolean isEmpty, float partialTicks) {
        if (gunItem.getGun().getReloads().isMagFed()) {
            return isEmpty ? ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks + (float)this.startUpReloadTimer) / ((float)gunItem.getGun().getReloads().getReloadMagTimer() + (float)gunItem.getGun().getReloads().getAdditionalReloadEmptyMagTimer()) : ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks + (float)this.startUpReloadTimer) / (float)gunItem.getGun().getReloads().getReloadMagTimer();
        }
        if (gunItem.getGun().getReloads().isStripperClip()) {
            return isEmpty ? ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks + (float)this.startUpReloadTimer) / (float)gunItem.getGun().getReloads().getAdditionalReloadEmptyMagTimer() : ((float)this.prevReloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks + (float)this.startUpReloadTimer) / (float)gunItem.getGun().getReloads().getinterReloadPauseTicks();
        }
        return ((float)this.reloadTimer + (float)(this.reloadTimer - this.prevReloadTimer) * partialTicks) / (float)gunItem.getGun().getReloads().getinterReloadPauseTicks();
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Pre event) {
        CompoundNBT tag;
        PlayerEntity player = event.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        Gun gun = ((GunItem)stack.func_77973_b()).getModifiedGun(stack);
        if (GunAnimationController.fromItem(stack.func_77973_b()) instanceof PumpShotgunAnimationController && this.isReloading()) {
            event.setCanceled(true);
        }
        if ((tag = stack.func_196082_o()).func_74762_e("AmmoCount") <= 0) {
            if (gun.getReloads().getReloadMagTimer() + gun.getReloads().getAdditionalReloadEmptyMagTimer() - this.reloadTimer > 5 && this.isReloading()) {
                event.setCanceled(true);
            }
        } else if (gun.getReloads().getReloadMagTimer() - this.reloadTimer > 5 && this.isReloading()) {
            event.setCanceled(true);
        }
    }
}

