/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.handler;

import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import com.tac.guns.Config;
import com.tac.guns.client.Keys;
import com.tac.guns.client.handler.CrosshairHandler;
import com.tac.guns.client.render.crosshair.Crosshair;
import com.tac.guns.common.AimingManager;
import com.tac.guns.common.Gun;
import com.tac.guns.init.ModBlocks;
import com.tac.guns.init.ModSyncedDataKeys;
import com.tac.guns.item.GunItem;
import com.tac.guns.item.attachment.impl.Scope;
import com.tac.guns.item.transition.TimelessGunItem;
import com.tac.guns.network.PacketHandler;
import com.tac.guns.network.message.MessageAim;
import com.tac.guns.util.math.MathUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AimingHandler {
    private static AimingHandler instance;
    private final AimingManager.AimTracker localTracker = new AimingManager.AimTracker();
    private double normalisedAdsProgress;
    private double oldProgress;
    private double newProgress;
    private boolean aiming = false;
    private boolean toggledAim = false;
    private int currentScopeZoomIndex = 0;
    private boolean isPressed = false;
    private boolean canceling = false;

    public static AimingHandler get() {
        if (instance == null) {
            instance = new AimingHandler();
        }
        return instance;
    }

    public int getCurrentScopeZoomIndex() {
        return this.currentScopeZoomIndex;
    }

    public void resetCurrentScopeZoomIndex() {
        this.currentScopeZoomIndex = 0;
    }

    private AimingHandler() {
        Keys.SIGHT_SWITCH.addPressCallback(() -> {
            if (!Keys.noConflict(Keys.SIGHT_SWITCH)) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && (mc.field_71439_g.func_184614_ca().func_77973_b() instanceof GunItem || Gun.getScope(mc.field_71439_g.func_184614_ca()) != null)) {
                ++this.currentScopeZoomIndex;
            }
        });
    }

    @SubscribeEvent
    public void onLocalPlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        AimingManager.get().getAimingMap().clear();
    }

    @SubscribeEvent
    public void onClickInput(InputEvent.ClickInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        assert (player != null);
        ItemStack heldItem = player.func_184614_ca();
        boolean isGunInHand = heldItem.func_77973_b() instanceof TimelessGunItem;
        if (!isGunInHand) {
            return;
        }
        if (!event.isUseItem()) {
            return;
        }
        boolean hasMouseOverBlock = mc.field_71476_x instanceof BlockRayTraceResult;
        if (!hasMouseOverBlock) {
            return;
        }
        assert (mc.field_71441_e != null);
        BlockRayTraceResult result = (BlockRayTraceResult)mc.field_71476_x;
        BlockState state = mc.field_71441_e.func_180495_p(result.func_216350_a());
        Block block = state.func_177230_c();
        Config.RightClickUse config = Config.CLIENT.rightClickUse;
        if (block instanceof ContainerBlock || block.hasTileEntity(state) ? (Boolean)config.allowChests.get() != false : (block == Blocks.field_150462_ai || block == ModBlocks.WORKBENCH.get() ? (Boolean)config.allowCraftingTable.get() != false : (BlockTags.field_200029_f.func_230235_a_((Object)block) ? (Boolean)config.allowDoors.get() != false : (BlockTags.field_212185_E.func_230235_a_((Object)block) ? (Boolean)config.allowTrapDoors.get() != false : (Tags.Blocks.CHESTS.func_230235_a_((Object)block) ? (Boolean)config.allowChests.get() != false : (Tags.Blocks.FENCE_GATES.func_230235_a_((Object)block) ? (Boolean)config.allowFenceGates.get() != false : (BlockTags.field_200027_d.func_230235_a_((Object)block) ? (Boolean)config.allowButton.get() != false : (block == Blocks.field_150442_at ? (Boolean)config.allowLever.get() != false : (Boolean)config.allowRestUse.get() != false)))))))) {
            return;
        }
        event.setCanceled(true);
        event.setSwingHand(false);
    }

    public float getAimProgress(PlayerEntity player, float partialTicks) {
        if (player.func_175144_cb()) {
            return (float)this.localTracker.getNormalProgress(partialTicks);
        }
        AimingManager.AimTracker tracker = AimingManager.get().getAimTracker(player);
        if (tracker != null) {
            return (float)tracker.getNormalProgress(partialTicks);
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        this.tickLerpProgress();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (this.aiming) {
            player.func_70031_b(false);
        }
        if (!((Boolean)Config.CLIENT.controls.holdToAim.get()).booleanValue() && !Keys.AIM_DOWN_SIGHT.func_151470_d()) {
            this.isPressed = false;
        }
        if (this.isAiming()) {
            if (!this.canceling && !this.aiming) {
                SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.AIMING, (Object)true);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageAim(true));
                this.aiming = true;
            }
            this.localTracker.handleAiming(player.func_184614_ca(), true);
        } else {
            if (this.aiming) {
                SyncedPlayerData.instance().set((PlayerEntity)player, ModSyncedDataKeys.AIMING, (Object)false);
                PacketHandler.getPlayChannel().sendToServer((Object)new MessageAim(false));
                this.aiming = false;
            }
            this.localTracker.handleAiming(player.func_184614_ca(), false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFovUpdate(FOVUpdateEvent event) {
        ItemStack heldItem;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71474_y.func_243230_g() == PointOfView.FIRST_PERSON && (heldItem = mc.field_71439_g.func_184614_ca()).func_77973_b() instanceof TimelessGunItem) {
            Gun modifiedGun;
            TimelessGunItem gunItem = (TimelessGunItem)heldItem.func_77973_b();
            if (AimingHandler.get().normalisedAdsProgress != 0.0 && !((Boolean)SyncedPlayerData.instance().get((PlayerEntity)mc.field_71439_g, ModSyncedDataKeys.RELOADING)).booleanValue() && (modifiedGun = gunItem.getModifiedGun(heldItem)).getModules().getZoom() != null) {
                float newFov = modifiedGun.getModules().getZoom().getFovModifier();
                Scope scope = Gun.getScope(heldItem);
                if (scope != null) {
                    if ((Boolean)Config.COMMON.gameplay.realisticLowPowerFovHandling.get() == false || scope.getAdditionalZoom().getZoomMultiple() > 1.0f && (Boolean)Config.COMMON.gameplay.realisticLowPowerFovHandling.get() != false || gunItem.isIntegratedOptic().booleanValue()) {
                        float zoomFov = (float)MathUtil.magnificationToFovMultiplier(scope.getAdditionalZoom().getZoomMultiple(), mc.field_71474_y.field_74334_X);
                        if (zoomFov >= 1.0f) {
                            zoomFov = modifiedGun.getModules().getZoom().getFovModifier();
                        }
                        float fovDelta = newFov - zoomFov;
                        event.setNewfov((newFov -= fovDelta * ((Boolean)Config.CLIENT.display.scopeDoubleRender.get() != false ? 1.0f : 1.2f)) + (1.0f - newFov) * (1.0f - (float)this.normalisedAdsProgress));
                    }
                } else if (!((Boolean)Config.COMMON.gameplay.realisticIronSightFovHandling.get()).booleanValue() || gunItem.isIntegratedOptic().booleanValue()) {
                    event.setNewfov(newFov + (1.0f - newFov) * (1.0f - (float)this.normalisedAdsProgress));
                }
            }
        }
    }

    private void tickLerpProgress() {
        this.oldProgress = this.newProgress;
        this.newProgress += (this.normalisedAdsProgress - this.newProgress) * 0.5;
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        this.normalisedAdsProgress = this.localTracker.getNormalProgress(event.getPartialTicks());
        Crosshair crosshair = CrosshairHandler.get().getCurrentCrosshair();
        if (this.normalisedAdsProgress > 0.0 && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && (crosshair == null || crosshair.isDefault())) {
            event.setCanceled(true);
        }
    }

    public boolean isAiming() {
        boolean zooming;
        Minecraft mc = Minecraft.func_71410_x();
        if (this.canceling) {
            return false;
        }
        if (mc.field_71439_g == null) {
            return false;
        }
        if (mc.field_71439_g.func_175149_v()) {
            return false;
        }
        if (mc.field_71462_r != null) {
            return false;
        }
        ItemStack heldItem = mc.field_71439_g.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof GunItem)) {
            return false;
        }
        Gun gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
        if (gun.getModules().getZoom() == null) {
            return false;
        }
        CooldownTracker tracker = Minecraft.func_71410_x().field_71439_g.func_184811_cZ();
        float cooldown = tracker.func_185143_a(heldItem.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
        if (gun.getGeneral().isBoltAction() && (double)cooldown < 0.8 && cooldown > 0.0f && Gun.getScope(heldItem) != null) {
            return false;
        }
        if (((Boolean)SyncedPlayerData.instance().get((PlayerEntity)mc.field_71439_g, ModSyncedDataKeys.RELOADING)).booleanValue()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.controls.holdToAim.get()).booleanValue()) {
            zooming = Keys.AIM_DOWN_SIGHT.func_151470_d();
        } else {
            if (Keys.AIM_DOWN_SIGHT.func_151470_d() && !this.isPressed) {
                this.isPressed = true;
                this.forceToggleAim();
            }
            zooming = this.toggledAim;
        }
        return zooming;
    }

    public boolean isToggledAim() {
        return this.toggledAim;
    }

    public void forceToggleAim() {
        if (this.toggledAim) {
            this.toggledAim = false;
        } else if (!this.canceling) {
            this.toggledAim = true;
        }
    }

    public double getNormalisedAdsProgress() {
        return this.normalisedAdsProgress;
    }

    public double getLerpAdsProgress(float partialTicks) {
        return MathHelper.func_219803_d((double)partialTicks, (double)this.oldProgress, (double)this.newProgress);
    }

    public void cancelAim() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.canceling = true;
        this.cancel((PlayerEntity)player);
    }

    private void cancel(PlayerEntity player) {
        if (this.aiming || this.toggledAim) {
            SyncedPlayerData.instance().set(player, ModSyncedDataKeys.AIMING, (Object)false);
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageAim(false));
            this.aiming = false;
            this.toggledAim = false;
        }
        this.localTracker.handleAiming(player.func_184614_ca(), false);
    }

    public void setCanceling() {
        if (this.canceling) {
            this.canceling = false;
        }
    }

    public boolean getCanceling() {
        return this.canceling;
    }
}

