/*
 * Decompiled with CFR 0.152.
 */
package com.tac.guns.client.gunskin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.tac.guns.client.SpecialModel;
import com.tac.guns.client.gunskin.DefaultSkin;
import com.tac.guns.client.gunskin.GunSkin;
import com.tac.guns.client.gunskin.IModelComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.RegistryObject;

public class SkinLoader {
    public static final Map<ResourceLocation, SkinLoader> skinLoaders = new HashMap<ResourceLocation, SkinLoader>();
    private DefaultSkin defaultSkin;
    public static IUnbakedModel missingModel;
    public static Map<ResourceLocation, IUnbakedModel> unbakedModels;
    public static Map<ResourceLocation, IUnbakedModel> topUnbakedModels;
    private final List<IModelComponent> components;
    private final ResourceLocation name;

    public SkinLoader(ResourceLocation name, IModelComponent ... components) {
        this.components = Arrays.asList(components);
        this.name = name;
    }

    public SkinLoader(RegistryObject<?> item, IModelComponent ... components) {
        this(item.getId(), components);
    }

    public static void register(ResourceLocation name, SkinLoader loader) {
        skinLoaders.put(name, loader);
    }

    public List<IModelComponent> getComponents() {
        return this.components;
    }

    public static SkinLoader getSkinLoader(String name) {
        ResourceLocation rl = null;
        rl = name.indexOf(58) >= 0 ? ResourceLocation.func_208304_a((String)name) : ResourceLocation.func_208304_a((String)("tac:" + name));
        if (rl == null) {
            return null;
        }
        return skinLoaders.get(rl);
    }

    public static SkinLoader getSkinLoader(ResourceLocation name) {
        return skinLoaders.get(name);
    }

    public ResourceLocation getGun() {
        return this.name;
    }

    public DefaultSkin loadDefaultSkin() {
        DefaultSkin skin = new DefaultSkin(this.name);
        String mainLoc = this.name.func_110624_b() + ":special/" + this.getGun().func_110623_a();
        for (IModelComponent key : this.components) {
            SkinLoader.tryLoadComponent((GunSkin)skin, mainLoc, key);
        }
        this.defaultSkin = skin;
        ResourceLocation iconLoc = ResourceLocation.func_208304_a((String)(this.name.func_110624_b() + ":textures/gui/icon/" + this.name.func_110623_a() + ".png"));
        if (iconLoc != null && Minecraft.func_71410_x().func_195551_G().func_219533_b(iconLoc)) {
            skin.setIcon(iconLoc);
        }
        ResourceLocation miniIconLoc = ResourceLocation.func_208304_a((String)(this.name.func_110624_b() + ":textures/gui/icon/mini/" + this.name.func_110623_a() + ".png"));
        if (iconLoc != null && Minecraft.func_71410_x().func_195551_G().func_219533_b(iconLoc)) {
            skin.setMiniIcon(miniIconLoc);
        }
        return skin;
    }

    public GunSkin loadCustomSkin(ResourceLocation skinName, Map<String, String> models) {
        if (this.defaultSkin == null) {
            return null;
        }
        GunSkin skin = new GunSkin(skinName, this.getGun());
        skin.setDefaultSkin(this.defaultSkin);
        if (models.containsKey("auto")) {
            String main = models.get("auto");
            for (IModelComponent key : this.components) {
                SkinLoader.tryLoadComponent(skin, main, key);
            }
        } else {
            for (IModelComponent key : this.components) {
                SkinLoader.tryLoadComponent(skin, models, key);
            }
        }
        return skin;
    }

    public boolean loadSkinIcon(@Nonnull GunSkin skin, @Nonnull ResourceLocation iconLocation) {
        if (Minecraft.func_71410_x().func_195551_G().func_219533_b(iconLocation)) {
            skin.setIcon(iconLocation);
            return true;
        }
        ResourceLocation tl = ResourceLocation.func_208304_a((String)(iconLocation.func_110624_b() + ":textures/" + iconLocation.func_110623_a() + ".png"));
        if (tl != null && Minecraft.func_71410_x().func_195551_G().func_219533_b(tl)) {
            skin.setIcon(tl);
            return true;
        }
        return false;
    }

    public boolean loadSkinMiniIcon(@Nonnull GunSkin skin, @Nonnull ResourceLocation iconLocation) {
        if (Minecraft.func_71410_x().func_195551_G().func_219533_b(iconLocation)) {
            skin.setIcon(iconLocation);
            return true;
        }
        ResourceLocation tl = ResourceLocation.func_208304_a((String)(iconLocation.func_110624_b() + ":textures/" + iconLocation.func_110623_a() + ".png"));
        if (tl != null && Minecraft.func_71410_x().func_195551_G().func_219533_b(tl)) {
            skin.setMiniIcon(tl);
            return true;
        }
        return false;
    }

    private static void tryLoadComponent(GunSkin skin, Map<String, String> models, IModelComponent component) {
        ResourceLocation loc;
        if (models.containsKey(component.getKey()) && (loc = ResourceLocation.func_208304_a((String)models.get(component.getKey()))) != null) {
            SpecialModel mainModel = new SpecialModel(loc);
            ModelLoader.addSpecialModel((ResourceLocation)loc);
            skin.addComponent(component, mainModel);
        }
    }

    private static void tryLoadComponent(GunSkin skin, String mainLocation, IModelComponent component) {
        ResourceLocation loc = component.getModelLocation(mainLocation);
        if (loc != null) {
            ResourceLocation test = new ResourceLocation(loc.func_110624_b(), "models/" + loc.func_110623_a() + ".json");
            if (Minecraft.func_71410_x().func_195551_G().func_219533_b(test)) {
                SpecialModel mainModel = new SpecialModel(loc);
                ModelLoader.addSpecialModel((ResourceLocation)loc);
                skin.addComponent(component, mainModel);
            }
        }
    }

    public GunSkin loadTextureOnlySkin(ResourceLocation skinName, List<Pair<String, ResourceLocation>> textures) {
        if (this.defaultSkin == null) {
            return null;
        }
        GunSkin skin = new GunSkin(skinName, this.getGun());
        skin.setDefaultSkin(this.defaultSkin);
        for (IModelComponent component : this.components) {
            ResourceLocation parent = component.getModelLocation(this.name.func_110624_b() + ":special/" + this.name.func_110623_a());
            TextureModel model = TextureModel.tryCreateCopy(parent);
            if (model == null) continue;
            model.applyTextures(textures);
            ResourceLocation componentLoc = component.getModelLocation(skinName.func_110624_b() + ":gunskin/generated/" + this.name.func_110624_b() + this.name.func_110623_a() + "_" + skinName.func_110623_a());
            skin.addComponent(component, new SpecialModel(componentLoc));
            unbakedModels.put(componentLoc, (IUnbakedModel)model.getModel());
            topUnbakedModels.put(componentLoc, (IUnbakedModel)model.getModel());
        }
        return skin;
    }

    public static class TextureModel {
        public static final ResourceLocation atlasLocation = new ResourceLocation("minecraft:textures/atlas/blocks.png");
        private final BlockModel unbaked;

        private TextureModel(BlockModel model) {
            this.unbaked = model;
        }

        public static TextureModel tryCreateCopy(ResourceLocation parentLocation) {
            TextureModel textureModel = null;
            if (ModelLoader.instance() != null) {
                BlockModel parent = (BlockModel)ModelLoader.instance().func_209597_a(parentLocation);
                if (parent == missingModel) {
                    return null;
                }
                ArrayList list = Lists.newArrayList();
                HashMap map = Maps.newHashMap();
                BlockModel model = new BlockModel(parentLocation, (List)list, (Map)map, true, null, parent.func_181682_g(), parent.func_187966_f());
                textureModel = new TextureModel(model);
            }
            return textureModel;
        }

        public void applyTextures(List<Pair<String, ResourceLocation>> textures) {
            textures.forEach(p -> this.applyTexture((String)p.getFirst(), (ResourceLocation)p.getSecond()));
        }

        public void applyTexture(String key, ResourceLocation textureLocation) {
            this.unbaked.field_178318_c.put(key, Either.left((Object)new RenderMaterial(atlasLocation, textureLocation)));
        }

        public BlockModel getModel() {
            return this.unbaked;
        }
    }
}

