/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.core.util.recipes.device.FisherBoost;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootTables;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FisherBoostSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<FisherBoost> {
    public FisherBoost fromJson(ResourceLocation recipeId, JsonObject json) {
        ResourceLocation lootTable = LootTables.field_186390_ao;
        float outputMod = 1.0f;
        float useChance = 1.0f;
        Ingredient ingredient = RecipeJsonUtils.parseIngredient((JsonElement)json.get("ingredient"));
        if (json.has("loot_table")) {
            String lootTableString = json.get("loot_table").getAsString();
            lootTable = ResourceLocation.func_208304_a((String)lootTableString);
        }
        if (json.has("output")) {
            outputMod = json.get("output").getAsFloat();
        } else if (json.has("output_mod")) {
            outputMod = json.get("output_mod").getAsFloat();
        }
        if (json.has("use_chance")) {
            useChance = json.get("use_chance").getAsFloat();
        }
        return new FisherBoost(recipeId, ingredient, lootTable, outputMod, useChance);
    }

    @Nullable
    public FisherBoost fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        ResourceLocation lootTable = buffer.func_192575_l();
        float outputMod = buffer.readFloat();
        float useChance = buffer.readFloat();
        return new FisherBoost(recipeId, ingredient, lootTable, outputMod, useChance);
    }

    public void toNetwork(PacketBuffer buffer, FisherBoost recipe) {
        recipe.ingredient.func_199564_a(buffer);
        buffer.func_192572_a(recipe.lootTable);
        buffer.writeFloat(recipe.outputMod);
        buffer.writeFloat(recipe.useChance);
    }
}

