/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.device;

import cofh.lib.util.ComparableItemStack;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.PotionDiffuserBoost;
import cofh.thermal.lib.util.managers.AbstractManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import org.apache.commons.lang3.tuple.Triple;

public class PotionDiffuserManager
extends AbstractManager {
    private static final PotionDiffuserManager INSTANCE = new PotionDiffuserManager();
    protected Map<ComparableItemStack, Triple<Integer, Integer, Float>> boostMap = new Object2ObjectOpenHashMap();

    protected PotionDiffuserManager() {
        super(16);
    }

    public static PotionDiffuserManager instance() {
        return INSTANCE;
    }

    protected void clear() {
        this.boostMap.clear();
    }

    public boolean validBoost(ItemStack item) {
        return this.boostMap.containsKey(PotionDiffuserManager.convert(item));
    }

    public void addBoost(PotionDiffuserBoost boost) {
        for (ItemStack ingredient : boost.getIngredient().func_193365_a()) {
            this.boostMap.put(PotionDiffuserManager.convert(ingredient), (Triple<Integer, Integer, Float>)Triple.of((Object)boost.getCycles(), (Object)boost.getAmplifier(), (Object)Float.valueOf(boost.getDurationMod())));
        }
    }

    public int getBoostCycles(ItemStack item) {
        return this.validBoost(item) ? (Integer)this.boostMap.get(PotionDiffuserManager.convert(item)).getLeft() : 0;
    }

    public int getBoostAmplifier(ItemStack item) {
        return this.validBoost(item) ? (Integer)this.boostMap.get(PotionDiffuserManager.convert(item)).getMiddle() : 0;
    }

    public float getBoostDurationMod(ItemStack item) {
        return this.validBoost(item) ? ((Float)this.boostMap.get(PotionDiffuserManager.convert(item)).getRight()).floatValue() : 0.0f;
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map boosts = recipeManager.func_215366_a(TCoreRecipeTypes.BOOST_POTION_DIFFUSER);
        for (Map.Entry entry : boosts.entrySet()) {
            this.addBoost((PotionDiffuserBoost)((Object)entry.getValue()));
        }
    }
}

