/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemHandler;
import cofh.lib.tileentity.IAreaEffectTile;
import cofh.lib.util.IInventoryCallback;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.AugmentDataHelper;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.xp.XpStorage;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceFisherContainer;
import cofh.thermal.core.util.managers.device.FisherManager;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.items.IItemHandler;

public class DeviceFisherTile
extends DeviceTileBase
implements ITickableTileEntity,
IAreaEffectTile {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Area", "Filter");
    protected static int timeConstant = 4800;
    protected static int minTimeConstant = timeConstant / 20;
    protected static int timeReductionWater = 20;
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> FisherManager.instance().validBoost((ItemStack)item));
    protected SimpleItemHandler internalHandler;
    protected boolean cached;
    protected boolean valid;
    protected static final int RADIUS = 2;
    public int radius = 2;
    protected AxisAlignedBB area;
    protected int process = timeConstant / 2;

    public static void setTimeConstant(int configConstant) {
        timeConstant = configConstant;
        minTimeConstant = timeConstant / 20;
    }

    public static void setTimeReductionWater(int configConstant) {
        timeReductionWater = configConstant;
    }

    public DeviceFisherTile() {
        super(TCoreReferences.DEVICE_FISHER_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlots(StorageGroup.OUTPUT, 15, item -> this.filter.valid(item));
        this.xpStorage = new XpStorage(this.getBaseXpStorage());
        this.addAugmentSlots(ThermalConfig.deviceAugments);
        this.initHandlers();
        this.internalHandler = new SimpleItemHandler((IInventoryCallback)this, this.inventory.getOutputSlots());
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.updateValidity();
    }

    @Override
    protected void updateValidity() {
        this.area = null;
        if (this.field_145850_b == null || !this.field_145850_b.isAreaLoaded(this.field_174879_c, 1 + this.radius) || Utils.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        int facingWater = 0;
        this.valid = false;
        BlockState myState = this.func_195044_w();
        BlockPos facePos = this.field_174879_c.func_177972_a((Direction)myState.func_177229_b((Property)Constants.FACING_HORIZONTAL));
        FluidState state = this.field_145850_b.func_204610_c(facePos);
        if (state.func_206886_c().equals(Fluids.field_204546_a)) {
            BlockPos areaPos = this.field_174879_c.func_177967_a((Direction)myState.func_177229_b((Property)Constants.FACING_HORIZONTAL), 2);
            Iterable area = BlockPos.func_218278_a((BlockPos)areaPos.func_177982_a(-1, 0, -1), (BlockPos)areaPos.func_177982_a(1, 0, 1));
            for (BlockPos scan : area) {
                state = this.field_145850_b.func_204610_c(scan);
                if (!state.func_206886_c().equals(Fluids.field_204546_a)) continue;
                ++facingWater;
            }
            this.valid = facingWater >= 7;
        }
        this.cached = true;
    }

    @Override
    protected void updateActiveState() {
        if (!this.cached) {
            this.updateValidity();
            this.process = Math.max(minTimeConstant, MathHelper.RANDOM.nextInt(this.getTimeConstant()));
        }
        super.updateActiveState();
    }

    @Override
    protected boolean isValid() {
        return this.valid;
    }

    public void func_73660_a() {
        this.updateActiveState();
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.updateValidity();
        this.process = Math.max(minTimeConstant, MathHelper.RANDOM.nextInt(this.getTimeConstant()));
        if (!this.isActive) {
            return;
        }
        if (this.valid) {
            LootTable table = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(FisherManager.instance().getBoostLootTable(this.inputSlot.getItemStack()));
            LootContext.Builder contextBuilder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237491_b_((Vector3i)this.func_174877_v())).func_216023_a(this.field_145850_b.field_73012_v);
            float lootBase = this.baseMod * FisherManager.instance().getBoostOutputMod(this.inputSlot.getItemStack());
            float lootExtra = lootBase - (float)((int)lootBase);
            int lootCount = (int)lootBase + (MathHelper.RANDOM.nextFloat() < lootExtra ? 1 : 0);
            int caught = 0;
            for (int i = 0; i < lootCount; ++i) {
                for (ItemStack stack : table.func_216113_a(contextBuilder.func_216022_a(LootParameterSets.field_216260_a))) {
                    if (!InventoryHelper.insertStackIntoInventory((IItemHandler)this.internalHandler, (ItemStack)stack, (boolean)false).func_190926_b()) continue;
                    ++caught;
                }
            }
            if (caught > 0) {
                if (MathHelper.RANDOM.nextFloat() < FisherManager.instance().getBoostUseChance(this.inputSlot.getItemStack())) {
                    this.inputSlot.consume(1);
                }
                if (this.xpStorageFeature) {
                    this.xpStorage.receiveXp(caught + this.field_145850_b.field_73012_v.nextInt(2 * caught), false);
                }
                Vector3d splashVec = Vector3d.func_237490_a_((Vector3i)this.field_174879_c.func_177972_a((Direction)this.func_195044_w().func_177229_b((Property)Constants.FACING_HORIZONTAL)), (double)1.0);
                ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197630_w, splashVec.field_72450_a, splashVec.field_72448_b, splashVec.field_72449_c, 10, 0.1, 0.0, 0.1, 0.02);
            }
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceFisherContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.process = nbt.func_74762_e("Proc");
        this.valid = nbt.func_74767_n("Valid");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Proc", this.process);
        nbt.func_74757_a("Valid", this.valid);
        return nbt;
    }

    protected int getTimeConstant() {
        if (this.field_145850_b == null) {
            return timeConstant / 2;
        }
        int constant = timeConstant;
        BlockPos areaPos = this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((Property)Constants.FACING_HORIZONTAL), this.radius);
        Iterable area = BlockPos.func_218278_a((BlockPos)areaPos.func_177982_a(-this.radius, 1 - this.radius, -this.radius), (BlockPos)areaPos.func_177982_a(this.radius, -1 + this.radius, this.radius));
        for (BlockPos scan : area) {
            FluidState state = this.field_145850_b.func_204610_c(scan);
            if (!state.func_206886_c().equals(Fluids.field_204546_a)) continue;
            constant -= timeReductionWater;
        }
        if (Utils.hasBiomeType((World)this.field_145850_b, (BlockPos)this.field_174879_c, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            constant /= 3;
        }
        if (Utils.hasBiomeType((World)this.field_145850_b, (BlockPos)this.field_174879_c, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
            constant /= 2;
        }
        if (this.field_145850_b.func_175727_C(this.field_174879_c)) {
            constant /= 2;
        }
        if (this.inputSlot.isEmpty()) {
            constant *= 2;
        }
        return MathHelper.clamp((int)constant, (int)(timeConstant / 20), (int)timeConstant);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 2;
    }

    @Override
    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius = (int)((float)this.radius + AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"Radius"));
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.area = null;
    }

    public AxisAlignedBB getArea() {
        if (this.area == null) {
            if (!this.valid) {
                BlockPos areaPos = this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((Property)Constants.FACING_HORIZONTAL), 2);
                this.area = new AxisAlignedBB(areaPos.func_177982_a(-1, 0, -1), areaPos.func_177982_a(2, 1, 2));
            } else {
                BlockPos areaPos = this.field_174879_c.func_177967_a((Direction)this.func_195044_w().func_177229_b((Property)Constants.FACING_HORIZONTAL), this.radius);
                this.area = new AxisAlignedBB(areaPos.func_177982_a(-this.radius, -1 - this.radius, -this.radius), areaPos.func_177982_a(1 + this.radius, -1 + this.radius, 1 + this.radius));
            }
        }
        return this.area;
    }

    public int getColor() {
        return this.valid ? (this.isActive ? 35071 : 0x555555) : 0xFF0000;
    }
}

