/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.compat.patchouli;

import cofh.thermal.core.util.recipes.machine.SmelterRecipe;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class SmelterProcessor
implements IComponentProcessor {
    private SmelterRecipe recipe;

    public void setup(IVariableProvider variables) {
        if (!variables.has("recipe")) {
            return;
        }
        ResourceLocation recipeId = new ResourceLocation(variables.get("recipe").asString());
        Optional recipe = Minecraft.func_71410_x().field_71441_e.func_199532_z().func_215367_a(recipeId);
        if (recipe.isPresent() && recipe.get() instanceof SmelterRecipe) {
            this.recipe = (SmelterRecipe)((Object)recipe.get());
        } else {
            LogManager.getLogger().warn("Thermalpedia missing the smelter recipe: " + recipeId);
        }
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.equals("out")) {
            return IVariable.from((Object)this.recipe.getOutputItems().get(0));
        }
        if (key.startsWith("in")) {
            int index = Integer.parseInt(key.substring(key.length() - 1)) - 1;
            if (this.recipe.getInputItems().size() <= index) {
                return null;
            }
            return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getInputItems().get(index).func_193365_a()).map(IVariable::from).collect(Collectors.toList()));
        }
        return null;
    }
}

