/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.recipes.machine.PyrolyzerRecipe;
import cofh.thermal.expansion.client.gui.machine.MachinePyrolyzerScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class PyrolyzerRecipeCategory
extends ThermalRecipeCategory<PyrolyzerRecipe> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public PyrolyzerRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachinePyrolyzerScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_PYROLYZER_BLOCK.func_149739_a());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(1);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(1), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends PyrolyzerRecipe> getRecipeClass() {
        return PyrolyzerRecipe.class;
    }

    public void setIngredients(PyrolyzerRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputItems());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems());
        ingredients.setOutputs(VanillaTypes.FLUID, recipe.getOutputFluids());
    }

    public void setRecipe(IRecipeLayout layout, PyrolyzerRecipe recipe, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        List outputFluids = ingredients.getOutputs(VanillaTypes.FLUID);
        for (int i = 0; i < outputs.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            for (ItemStack stack : (List)outputs.get(i)) {
                stack.func_190920_e((int)chance);
            }
        }
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiItemStacks.init(0, true, 33, 14);
        guiItemStacks.init(1, false, 96, 14);
        guiItemStacks.init(2, false, 114, 14);
        guiItemStacks.init(3, false, 96, 32);
        guiItemStacks.init(4, false, 114, 32);
        guiFluidStacks.init(0, false, 141, 11, 16, 40, TCoreJeiPlugin.tankSize((int)4000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.tankOverlay));
        guiItemStacks.set(0, (List)inputs.get(0));
        for (int i = 0; i < outputs.size(); ++i) {
            guiItemStacks.set(i + 1, (List)outputs.get(i));
        }
        if (!outputFluids.isEmpty()) {
            guiFluidStacks.set(0, (List)outputFluids.get(0));
        }
        this.addDefaultItemTooltipCallback(guiItemStacks, recipe.getOutputItemChances(), 1);
        TCoreJeiPlugin.addDefaultFluidTooltipCallback((IGuiFluidStackGroup)guiFluidStacks);
    }

    public void draw(PyrolyzerRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 62, 23);
        this.tankBackground.draw(matrixStack, 140, 10);
        this.speedBackground.draw(matrixStack, 34, 33);
        if (!recipe.getOutputFluids().isEmpty()) {
            RenderHelper.drawFluid((MatrixStack)matrixStack, (int)62, (int)23, (FluidStack)((FluidStack)recipe.getOutputFluids().get(0)), (int)24, (int)16);
            this.progressFluidBackground.draw(matrixStack, 62, 23);
            this.progressFluid.draw(matrixStack, 62, 23);
        } else {
            this.progress.draw(matrixStack, 62, 23);
        }
        this.speed.draw(matrixStack, 34, 33);
    }
}

