/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.theoneprobe.api.IOverlayStyle;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.ProbeConfig;
import mcjty.theoneprobe.apiimpl.styles.DefaultOverlayStyle;
import mcjty.theoneprobe.items.IEnumConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.StringUtils;

public class Config {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final int PROBE_NOTNEEDED = 0;
    public static final int PROBE_NEEDED = 1;
    public static final int PROBE_NEEDEDHARD = 2;
    public static final int PROBE_NEEDEDFOREXTENDED = 3;
    public static ForgeConfigSpec.IntValue needsProbe;
    public static ForgeConfigSpec.BooleanValue extendedInMain;
    public static IEnumConfig<NumberFormat> rfFormat;
    public static IEnumConfig<NumberFormat> tankFormat;
    public static ForgeConfigSpec.IntValue timeout;
    public static ForgeConfigSpec.IntValue waitingForServerTimeout;
    public static ForgeConfigSpec.IntValue maxPacketToServer;
    private static ForgeConfigSpec.IntValue defaultRFMode;
    private static ForgeConfigSpec.IntValue defaultTankMode;
    public static ForgeConfigSpec.BooleanValue supportBaubles;
    public static ForgeConfigSpec.BooleanValue spawnNote;
    public static ForgeConfigSpec.IntValue showSmallChestContentsWithoutSneaking;
    public static ForgeConfigSpec.IntValue showItemDetailThresshold;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> showContentsWithoutSneaking;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> dontShowContentsUnlessSneaking;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> dontSendNBT;
    private static Set<ResourceLocation> inventoriesToShow;
    private static Set<ResourceLocation> inventoriesToNotShow;
    private static Set<ResourceLocation> dontSendNBTSet;
    public static ForgeConfigSpec.DoubleValue probeDistance;
    public static ForgeConfigSpec.BooleanValue showLiquids;
    public static ForgeConfigSpec.BooleanValue isVisible;
    public static ForgeConfigSpec.BooleanValue compactEqualStacks;
    public static ForgeConfigSpec.BooleanValue holdKeyToMakeVisible;
    public static ForgeConfigSpec.BooleanValue showDebugInfo;
    private static ForgeConfigSpec.IntValue leftX;
    private static ForgeConfigSpec.IntValue topY;
    private static ForgeConfigSpec.IntValue rightX;
    private static ForgeConfigSpec.IntValue bottomY;
    public static ForgeConfigSpec.IntValue showBreakProgress;
    public static ForgeConfigSpec.BooleanValue harvestStyleVanilla;
    private static ForgeConfigSpec.ConfigValue<String> cfgchestContentsBorderColor;
    public static int chestContentsBorderColor;
    private static ForgeConfigSpec.ConfigValue<String> cfgboxBorderColor;
    private static ForgeConfigSpec.ConfigValue<String> cfgboxFillColor;
    private static int boxBorderColor;
    private static int boxFillColor;
    private static ForgeConfigSpec.IntValue boxThickness;
    private static ForgeConfigSpec.IntValue boxOffset;
    public static ForgeConfigSpec.DoubleValue tooltipScale;
    private static ForgeConfigSpec.ConfigValue<String> cfgRfbarFilledColor;
    private static ForgeConfigSpec.ConfigValue<String> cfgRfbarAlternateFilledColor;
    private static ForgeConfigSpec.ConfigValue<String> cfgRfbarBorderColor;
    private static ForgeConfigSpec.ConfigValue<String> cfgTankbarFilledColor;
    private static ForgeConfigSpec.ConfigValue<String> cfgTankbarAlternateFilledColor;
    private static ForgeConfigSpec.ConfigValue<String> cfgTankbarBorderColor;
    public static int rfbarFilledColor;
    public static int rfbarAlternateFilledColor;
    public static int rfbarBorderColor;
    public static int tankbarFilledColor;
    public static int tankbarAlternateFilledColor;
    public static int tankbarBorderColor;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowModName;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowHarvestLevel;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowCanBeHarvested;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowCropPercentage;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowChestContents;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowChestContentsDetailed;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowRedstone;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowMobHealth;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowMobGrowth;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowMobPotionEffects;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowLeverSetting;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowTankSetting;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowBrewStandSetting;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowMobSpawnerSetting;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowAnimalOwnerSetting;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowHorseStatSetting;
    private static IEnumConfig<IProbeConfig.ConfigMode> cfgshowSilverfish;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> renderBlacklist;
    private static Set<ResourceLocation> renderBlacklistSet;
    public static final Map<TextStyleClass, String> defaultTextStyleClasses;
    public static Map<TextStyleClass, ForgeConfigSpec.ConfigValue<String>> cfgtextStyleClasses;
    public static Map<TextStyleClass, String> textStyleClasses;
    public static ForgeConfigSpec.IntValue loggingThrowableTimeout;
    public static ForgeConfigSpec.BooleanValue showCollarColor;
    private static IOverlayStyle defaultOverlayStyle;
    private static final ProbeConfig DEFAULT_CONFIG;
    private static IProbeConfig realConfig;

    public static ProbeConfig getDefaultConfig() {
        return DEFAULT_CONFIG;
    }

    public static void setRealConfig(IProbeConfig config) {
        realConfig = config;
    }

    public static IProbeConfig getRealConfig() {
        return realConfig;
    }

    private static <T extends Enum<T>> IEnumConfig<T> addEnumConfig(ForgeConfigSpec.Builder builder, String path, String comment, T def, T ... values) {
        ForgeConfigSpec.ConfigValue configValue = builder.comment(comment).define(path, (Object)def.name());
        return () -> {
            String s = (String)configValue.get();
            for (Enum value : values) {
                if (!value.name().equals(s)) continue;
                return value;
            }
            return null;
        };
    }

    private static IEnumConfig<IProbeConfig.ConfigMode> addModeConfig(String path, String comment, IProbeConfig.ConfigMode def) {
        return Config.addEnumConfig((ForgeConfigSpec.Builder)CLIENT_BUILDER, (String)path, (String)comment, (Enum)def, (Enum[])new IProbeConfig.ConfigMode[]{IProbeConfig.ConfigMode.NORMAL, IProbeConfig.ConfigMode.EXTENDED, IProbeConfig.ConfigMode.NOT});
    }

    private static void initDefaultConfig() {
        cfgshowModName = Config.addModeConfig("showModName", "Show mod name (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowModName());
        cfgshowHarvestLevel = Config.addModeConfig("showHarvestLevel", "Show harvest level (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowHarvestLevel());
        cfgshowCanBeHarvested = Config.addModeConfig("showCanBeHarvested", "Show if the block can be harvested (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowHarvestLevel());
        cfgshowCropPercentage = Config.addModeConfig("showCropPercentage", "Show the growth level of crops (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowCropPercentage());
        cfgshowChestContents = Config.addModeConfig("showChestContents", "Show chest contents (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowChestContents());
        cfgshowChestContentsDetailed = Config.addModeConfig("showChestContentsDetailed", "Show chest contents in detail (0 = not, 1 = always, 2 = sneak), used only if number of items is below 'showItemDetailThresshold'", DEFAULT_CONFIG.getShowChestContentsDetailed());
        cfgshowRedstone = Config.addModeConfig("showRedstone", "Show redstone (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowRedstone());
        cfgshowMobHealth = Config.addModeConfig("showMobHealth", "Show mob health (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowMobHealth());
        cfgshowMobGrowth = Config.addModeConfig("showMobGrowth", "Show time to adulthood for baby mobs (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowMobGrowth());
        cfgshowMobPotionEffects = Config.addModeConfig("showMobPotionEffects", "Show mob potion effects (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowMobPotionEffects());
        cfgshowLeverSetting = Config.addModeConfig("showLeverSetting", "Show lever/comparator/repeater settings (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowLeverSetting());
        cfgshowTankSetting = Config.addModeConfig("showTankSetting", "Show tank setting (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowTankSetting());
        cfgshowBrewStandSetting = Config.addModeConfig("showBrewStandSetting", "Show brewing stand setting (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowBrewStandSetting());
        cfgshowMobSpawnerSetting = Config.addModeConfig("showMobSpawnerSetting", "Show mob spawner setting (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowMobSpawnerSetting());
        cfgshowAnimalOwnerSetting = Config.addModeConfig("showAnimalOwnerSetting", "Show animal owner setting (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getAnimalOwnerSetting());
        cfgshowHorseStatSetting = Config.addModeConfig("showHorseStatSetting", "Show horse stats setting (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getHorseStatSetting());
        cfgshowSilverfish = Config.addModeConfig("showSilverfish", "Reveal monster eggs (0 = not, 1 = always, 2 = sneak)", DEFAULT_CONFIG.getShowSilverfish());
    }

    public static void setProbeNeeded(int probeNeeded) {
        needsProbe.set((Object)probeNeeded);
    }

    public static void setupStyleConfig() {
        leftX = CLIENT_BUILDER.comment("The distance to the left side of the screen. Use -1 if you don't want to set this").defineInRange("boxLeftX", 5, -1, 10000);
        rightX = CLIENT_BUILDER.comment("The distance to the right side of the screen. Use -1 if you don't want to set this").defineInRange("boxRightX", -1, -1, 10000);
        topY = CLIENT_BUILDER.comment("The distance to the top side of the screen. Use -1 if you don't want to set this").defineInRange("boxTopY", 5, -1, 10000);
        bottomY = CLIENT_BUILDER.comment("The distance to the bottom side of the screen. Use -1 if you don't want to set this").defineInRange("boxBottomY", -1, -1, 10000);
        cfgboxBorderColor = CLIENT_BUILDER.comment("Color of the border of the box (0 to disable)").define("boxBorderColor", (Object)Integer.toHexString(boxBorderColor));
        cfgboxFillColor = CLIENT_BUILDER.comment("Color of the box (0 to disable)").define("boxFillColor", (Object)Integer.toHexString(boxFillColor));
        boxThickness = CLIENT_BUILDER.comment("Thickness of the border of the box (0 to disable)").defineInRange("boxThickness", 2, 0, 20);
        boxOffset = CLIENT_BUILDER.comment("How much the border should be offset (i.e. to create an 'outer' border)").defineInRange("boxOffset", 0, 0, 20);
        showLiquids = CLIENT_BUILDER.comment("If true show liquid information when the probe hits liquid first").define("showLiquids", false);
        isVisible = CLIENT_BUILDER.comment("Toggle default probe visibility (client can override)").define("isVisible", true);
        holdKeyToMakeVisible = CLIENT_BUILDER.comment("If true then the probe hotkey must be held down to show the tooltip").define("holdKeyToMakeVisible", false);
        tooltipScale = CLIENT_BUILDER.comment("The scale of the tooltips, 1 is default, 2 is smaller").defineInRange("tooltipScale", 1.0, 0.4, 5.0);
        cfgchestContentsBorderColor = CLIENT_BUILDER.comment("Color of the border of the chest contents box (0 to disable)").define("chestContentsBorderColor", (Object)Integer.toHexString(chestContentsBorderColor));
        showBreakProgress = CLIENT_BUILDER.comment("0 means don't show break progress, 1 is show as bar, 2 is show as text").defineInRange("showBreakProgress", 1, 0, 2);
        harvestStyleVanilla = CLIENT_BUILDER.comment("true means shows harvestability with vanilla style icons").define("harvestStyleVanilla", true);
        CLIENT_BUILDER.push("style");
        HashMap<TextStyleClass, ForgeConfigSpec.ConfigValue<String>> newformat = new HashMap<TextStyleClass, ForgeConfigSpec.ConfigValue<String>>();
        for (TextStyleClass styleClass : textStyleClasses.keySet()) {
            ForgeConfigSpec.ConfigValue configValue = CLIENT_BUILDER.comment("Text style. Use a comma delimited list with colors like: 'red', 'green', 'blue', ... or style codes like 'underline', 'bold', 'italic', 'strikethrough', ...\"").define(styleClass.getReadableName(), (Object)textStyleClasses.get((Object)styleClass));
            newformat.put(styleClass, (ForgeConfigSpec.ConfigValue<String>)configValue);
        }
        cfgtextStyleClasses = newformat;
        CLIENT_BUILDER.pop();
    }

    public static void setTextStyle(TextStyleClass styleClass, String style) {
        textStyleClasses.put(styleClass, style);
        cfgtextStyleClasses.get((Object)styleClass).set((Object)style);
    }

    public static void setExtendedInMain(boolean extendedInMain) {
        Config.extendedInMain.set((Object)extendedInMain);
    }

    public static void setLiquids(boolean liquids) {
        showLiquids.set((Object)liquids);
    }

    public static void setVisible(boolean visible) {
        isVisible.set((Object)visible);
    }

    public static void setCompactEqualStacks(boolean compact) {
        compactEqualStacks.set((Object)compact);
    }

    public static void setPos(int leftx, int topy, int rightx, int bottomy) {
        leftX.set((Object)leftx);
        topY.set((Object)topy);
        rightX.set((Object)rightx);
        bottomY.set((Object)bottomy);
        Config.updateDefaultOverlayStyle();
    }

    public static void setScale(float scale) {
        tooltipScale.set((Object)scale);
        Config.updateDefaultOverlayStyle();
    }

    public static void setBoxStyle(int thickness, int borderColor, int fillcolor, int offset) {
        boxThickness.set((Object)thickness);
        boxBorderColor = borderColor;
        boxFillColor = fillcolor;
        cfgboxBorderColor.set((Object)Integer.toHexString(boxBorderColor));
        cfgboxFillColor.set((Object)Integer.toHexString(boxFillColor));
        boxOffset.set((Object)offset);
        Config.updateDefaultOverlayStyle();
    }

    private static String configToTextFormat(String input) {
        String[] splitted;
        if ("context".equals(input)) {
            return "context";
        }
        StringBuilder builder = new StringBuilder();
        for (String s : splitted = StringUtils.split((String)input, (char)',')) {
            TextFormatting format = TextFormatting.func_96300_b((String)s);
            if (format == null) continue;
            builder.append(format.toString());
        }
        return builder.toString();
    }

    public static String getTextStyle(TextStyleClass styleClass) {
        if (textStyleClasses.containsKey((Object)styleClass)) {
            return Config.configToTextFormat(textStyleClasses.get((Object)styleClass));
        }
        return "";
    }

    private static int parseColor(String col) {
        try {
            return (int)Long.parseLong(col, 16);
        }
        catch (NumberFormatException e) {
            System.out.println("Config.parseColor");
            return 0;
        }
    }

    public static void updateDefaultOverlayStyle() {
        defaultOverlayStyle = new DefaultOverlayStyle().borderThickness((Integer)boxThickness.get()).borderColor(boxBorderColor).boxColor(boxFillColor).borderOffset((Integer)boxOffset.get()).location((Integer)leftX.get(), (Integer)rightX.get(), (Integer)topY.get(), (Integer)bottomY.get());
    }

    public static IOverlayStyle getDefaultOverlayStyle() {
        if (defaultOverlayStyle == null) {
            Config.updateDefaultOverlayStyle();
        }
        return defaultOverlayStyle;
    }

    public static Set<ResourceLocation> getInventoriesToShow() {
        if (inventoriesToShow == null) {
            inventoriesToShow = new HashSet<ResourceLocation>();
            for (String s : (List)showContentsWithoutSneaking.get()) {
                inventoriesToShow.add(new ResourceLocation(s));
            }
        }
        return inventoriesToShow;
    }

    public static Set<ResourceLocation> getInventoriesToNotShow() {
        if (inventoriesToNotShow == null) {
            inventoriesToNotShow = new HashSet<ResourceLocation>();
            for (String s : (List)dontShowContentsUnlessSneaking.get()) {
                inventoriesToNotShow.add(new ResourceLocation(s));
            }
        }
        return inventoriesToNotShow;
    }

    public static Set<ResourceLocation> getDontSendNBTSet() {
        if (dontSendNBTSet == null) {
            dontSendNBTSet = new HashSet<ResourceLocation>();
            for (String s : (List)dontSendNBT.get()) {
                dontSendNBTSet.add(new ResourceLocation(s));
            }
        }
        return dontSendNBTSet;
    }

    public static void resolveConfigs() {
        DEFAULT_CONFIG.setRFMode((Integer)defaultRFMode.get());
        DEFAULT_CONFIG.setTankMode((Integer)defaultTankMode.get());
        rfbarFilledColor = Config.parseColor((String)cfgRfbarFilledColor.get());
        rfbarAlternateFilledColor = Config.parseColor((String)cfgRfbarAlternateFilledColor.get());
        rfbarBorderColor = Config.parseColor((String)cfgRfbarBorderColor.get());
        tankbarFilledColor = Config.parseColor((String)cfgTankbarFilledColor.get());
        tankbarAlternateFilledColor = Config.parseColor((String)cfgTankbarAlternateFilledColor.get());
        tankbarBorderColor = Config.parseColor((String)cfgTankbarBorderColor.get());
        boxBorderColor = Config.parseColor((String)cfgboxBorderColor.get());
        boxFillColor = Config.parseColor((String)cfgboxFillColor.get());
        chestContentsBorderColor = Config.parseColor((String)cfgchestContentsBorderColor.get());
        DEFAULT_CONFIG.showModName(cfgshowModName.get());
        DEFAULT_CONFIG.showHarvestLevel(cfgshowHarvestLevel.get());
        DEFAULT_CONFIG.showCanBeHarvested(cfgshowCanBeHarvested.get());
        DEFAULT_CONFIG.showCropPercentage(cfgshowCropPercentage.get());
        DEFAULT_CONFIG.showChestContents(cfgshowChestContents.get());
        DEFAULT_CONFIG.showChestContentsDetailed(cfgshowChestContentsDetailed.get());
        DEFAULT_CONFIG.showRedstone(cfgshowRedstone.get());
        DEFAULT_CONFIG.showMobHealth(cfgshowMobHealth.get());
        DEFAULT_CONFIG.showMobGrowth(cfgshowMobGrowth.get());
        DEFAULT_CONFIG.showMobPotionEffects(cfgshowMobPotionEffects.get());
        DEFAULT_CONFIG.showLeverSetting(cfgshowLeverSetting.get());
        DEFAULT_CONFIG.showTankSetting(cfgshowTankSetting.get());
        DEFAULT_CONFIG.showBrewStandSetting(cfgshowBrewStandSetting.get());
        DEFAULT_CONFIG.showMobSpawnerSetting(cfgshowMobSpawnerSetting.get());
        DEFAULT_CONFIG.showAnimalOwnerSetting(cfgshowAnimalOwnerSetting.get());
        DEFAULT_CONFIG.showHorseStatSetting(cfgshowHorseStatSetting.get());
        DEFAULT_CONFIG.showSilverfish(cfgshowSilverfish.get());
        inventoriesToShow = null;
        inventoriesToNotShow = null;
        dontSendNBTSet = null;
        for (Map.Entry<TextStyleClass, ForgeConfigSpec.ConfigValue<String>> entry : cfgtextStyleClasses.entrySet()) {
            textStyleClasses.put(entry.getKey(), (String)entry.getValue().get());
        }
    }

    public static boolean isBlacklistForRendering(ResourceLocation id) {
        if (renderBlacklistSet == null) {
            renderBlacklistSet = new HashSet<ResourceLocation>();
            for (String s : (List)renderBlacklist.get()) {
                renderBlacklistSet.add(new ResourceLocation(s));
            }
        }
        return renderBlacklistSet.contains(id);
    }

    public static void onLoad(ModConfig.Loading event) {
        renderBlacklistSet = null;
    }

    public static void onReload(ModConfig.Loading event) {
        renderBlacklistSet = null;
    }

    static {
        inventoriesToShow = null;
        inventoriesToNotShow = null;
        dontSendNBTSet = null;
        chestContentsBorderColor = -16750951;
        boxBorderColor = -6710887;
        boxFillColor = 1426089625;
        rfbarFilledColor = -2293760;
        rfbarAlternateFilledColor = -12386304;
        rfbarBorderColor = -11184811;
        tankbarFilledColor = -16776995;
        tankbarAlternateFilledColor = -16777149;
        tankbarBorderColor = -11184811;
        renderBlacklistSet = null;
        defaultTextStyleClasses = new HashMap<TextStyleClass, String>();
        cfgtextStyleClasses = new HashMap<TextStyleClass, ForgeConfigSpec.ConfigValue<String>>();
        textStyleClasses = new HashMap<TextStyleClass, String>();
        defaultTextStyleClasses.put(TextStyleClass.NAME, "white");
        defaultTextStyleClasses.put(TextStyleClass.MODNAME, "blue,italic");
        defaultTextStyleClasses.put(TextStyleClass.ERROR, "red,bold");
        defaultTextStyleClasses.put(TextStyleClass.WARNING, "yellow");
        defaultTextStyleClasses.put(TextStyleClass.OK, "green");
        defaultTextStyleClasses.put(TextStyleClass.INFO, "white");
        defaultTextStyleClasses.put(TextStyleClass.INFOIMP, "blue");
        defaultTextStyleClasses.put(TextStyleClass.OBSOLETE, "gray,strikethrough");
        defaultTextStyleClasses.put(TextStyleClass.LABEL, "gray");
        defaultTextStyleClasses.put(TextStyleClass.PROGRESS, "white");
        defaultTextStyleClasses.put(TextStyleClass.HIGHLIGHTED, "gold");
        textStyleClasses = new HashMap<TextStyleClass, String>(defaultTextStyleClasses);
        DEFAULT_CONFIG = new ProbeConfig();
        COMMON_BUILDER.comment("General configuration");
        CLIENT_BUILDER.comment("General configuration");
        loggingThrowableTimeout = COMMON_BUILDER.comment("How much time (ms) to wait before reporting an exception again").defineInRange("loggingThrowableTimeout", 20000, 1, 10000000);
        renderBlacklist = CLIENT_BUILDER.comment("This is a list of entities that will not be rendered by TOP. This option also works if it is set client-side alone").defineList("renderBlacklist", Collections.emptyList(), s -> s instanceof String);
        needsProbe = COMMON_BUILDER.comment("Is the probe needed to show the tooltip? 0 = no, 1 = yes, 2 = yes and clients cannot override, 3 = probe needed for extended info only").defineInRange("needsProbe", 3, 0, 3);
        extendedInMain = COMMON_BUILDER.comment("If true the probe will automatically show extended information if it is in your main hand (so not required to sneak)").define("extendedInMain", false);
        supportBaubles = COMMON_BUILDER.comment("If true there will be a bauble version of the probe if baubles is present").define("supportBaubles", true);
        spawnNote = COMMON_BUILDER.comment("If true there will be a readme note for first-time players").define("spawnNote", true);
        showCollarColor = COMMON_BUILDER.comment("If true show the color of the collar of a wolf").define("showCollarColor", true);
        defaultRFMode = COMMON_BUILDER.comment("How to display RF: 0 = do not show, 1 = show in a bar, 2 = show as text").defineInRange("showRF", DEFAULT_CONFIG.getRFMode(), 0, 2);
        defaultTankMode = COMMON_BUILDER.comment("How to display tank contents: 0 = do not show, 1 = show in fluid bar, 2 = show in a bar, 3 = show as text").defineInRange("showTank", DEFAULT_CONFIG.getRFMode(), 0, 3);
        rfFormat = Config.addEnumConfig((ForgeConfigSpec.Builder)COMMON_BUILDER, (String)"rfFormat", (String)"Format for displaying RF", (Enum)NumberFormat.COMPACT, (Enum[])new NumberFormat[]{NumberFormat.COMMAS, NumberFormat.COMPACT, NumberFormat.FULL, NumberFormat.NONE});
        tankFormat = Config.addEnumConfig((ForgeConfigSpec.Builder)COMMON_BUILDER, (String)"tankFormat", (String)"Format for displaying tank contents", (Enum)NumberFormat.COMPACT, (Enum[])new NumberFormat[]{NumberFormat.COMMAS, NumberFormat.COMPACT, NumberFormat.FULL, NumberFormat.NONE});
        timeout = CLIENT_BUILDER.comment("The amount of milliseconds to wait before updating probe information from the server").defineInRange("timeout", 300, 10, 100000);
        waitingForServerTimeout = CLIENT_BUILDER.comment("The amount of milliseconds to wait before showing a 'fetch from server' info on the client (if the server is slow to respond) (-1 to disable this feature)").defineInRange("waitingForServerTimeout", 2000, -1, 100000);
        maxPacketToServer = CLIENT_BUILDER.comment("The maximum packet size to send an itemstack from client to server. Reduce this if you have issues with network lag caused by TOP").defineInRange("maxPacketToServer", 20000, -1, 32768);
        probeDistance = CLIENT_BUILDER.comment("Distance at which the probe works").defineInRange("probeDistance", 6.0, 0.1, 200.0);
        Config.initDefaultConfig();
        showDebugInfo = COMMON_BUILDER.comment("If true show debug info with creative probe").define("showDebugInfo", true);
        compactEqualStacks = COMMON_BUILDER.comment("If true equal stacks will be compacted in the chest contents overlay").define("compactEqualStacks", true);
        cfgRfbarFilledColor = COMMON_BUILDER.comment("Color for the RF bar").define("rfbarFilledColor", (Object)Integer.toHexString(rfbarFilledColor));
        cfgRfbarAlternateFilledColor = COMMON_BUILDER.comment("Alternate color for the RF bar").define("rfbarAlternateFilledColor", (Object)Integer.toHexString(rfbarAlternateFilledColor));
        cfgRfbarBorderColor = COMMON_BUILDER.comment("Color for the RF bar border").define("rfbarBorderColor", (Object)Integer.toHexString(rfbarBorderColor));
        cfgTankbarFilledColor = COMMON_BUILDER.comment("Color for the tank bar").define("tankbarFilledColor", (Object)Integer.toHexString(tankbarFilledColor));
        cfgTankbarAlternateFilledColor = COMMON_BUILDER.comment("Alternate color for the tank bar").define("tankbarAlternateFilledColor", (Object)Integer.toHexString(tankbarAlternateFilledColor));
        cfgTankbarBorderColor = COMMON_BUILDER.comment("Color for the tank bar border").define("tankbarBorderColor", (Object)Integer.toHexString(tankbarBorderColor));
        showItemDetailThresshold = COMMON_BUILDER.comment("If the number of items in an inventory is lower or equal then this number then more info is shown").defineInRange("showItemDetailThresshold", 4, 0, 20);
        showSmallChestContentsWithoutSneaking = COMMON_BUILDER.comment("The maximum amount of slots (empty or not) to show without sneaking").defineInRange("showSmallChestContentsWithoutSneaking", 0, 0, 1000);
        showContentsWithoutSneaking = COMMON_BUILDER.comment("A list of blocks for which we automatically show chest contents even if not sneaking").defineList("showContentsWithoutSneaking", new ArrayList<String>(Arrays.asList("storagedrawers:basicdrawers", "storagedrawersextra:extra_drawers")), s -> s instanceof String);
        dontShowContentsUnlessSneaking = COMMON_BUILDER.comment("A list of blocks for which we don't show chest contents automatically except if sneaking").defineList("dontShowContentsUnlessSneaking", new ArrayList(), s -> s instanceof String);
        dontSendNBT = COMMON_BUILDER.comment("A list of blocks for which we don't send NBT over the network. This is mostly useful for blocks that have HUGE NBT in their pickblock (itemstack)").defineList("dontSendNBT", new ArrayList(), s -> s instanceof String);
        Config.setupStyleConfig();
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

