/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.api;

public class Color {
    static final int ALPHA = -16777216;
    private final int value;

    public Color(int value) {
        this.value = value;
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(int r, int g, int b, int a) {
        this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public Color darker() {
        return this.darker(0.7);
    }

    public Color darker(double factor) {
        return new Color(Color.darker(this.value, factor));
    }

    public Color brighter() {
        return this.brighter(0.7);
    }

    public Color brighter(double factor) {
        return new Color(Color.brighter(this.value, factor));
    }

    public Color mix(Color other, double factor) {
        return new Color(Color.mix(this.value, other.getRGB(), factor));
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public static int rgb(int r, int g, int b) {
        return Color.rgb(r, g, b, 255);
    }

    public static int rgb(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static int mix(int from, int to, double factor) {
        double weight0 = 1.0 - factor;
        double weight1 = factor;
        int r = (int)((double)(from >> 16 & 0xFF) * weight0 + (double)(to >> 16 & 0xFF) * weight1);
        int g = (int)((double)(from >> 8 & 0xFF) * weight0 + (double)(to >> 8 & 0xFF) * weight1);
        int b = (int)((double)(from & 0xFF) * weight0 + (double)(to & 0xFF) * weight1);
        int a = (int)((double)(from >> 24 & 0xFF) * weight0 + (double)(to >> 24 & 0xFF) * weight1);
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int darker(int color, double factor) {
        int r = Math.max(0, (int)((double)(color >> 16 & 0xFF) * factor));
        int g = Math.max(0, (int)((double)(color >> 8 & 0xFF) * factor));
        int b = Math.max(0, (int)((double)(color & 0xFF) * factor));
        return color & 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int brighter(int color, double factor) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int i = (int)(1.0 / (1.0 - factor));
        if (r == 0 && g == 0 && b == 0) {
            return color & 0xFF000000 | (i & 0xFF) << 16 | (i & 0xFF) << 8 | i & 0xFF;
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return color & 0xFF000000 | Math.min(255, (int)((double)r / factor)) << 16 | Math.min(255, (int)((double)g / factor)) << 8 | Math.min(255, (int)((double)b / factor));
    }
}

