/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.util;

import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class RotationHelper {
    public static Rotation rotationFromFacing(Direction facing) {
        switch (facing) {
            case UP: 
            case DOWN: 
            case NORTH: {
                return Rotation.NONE;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static BlockPos rotatePitch(BlockPos pos, float pitch) {
        float f = MathHelper.func_76134_b((float)pitch);
        float f1 = MathHelper.func_76126_a((float)pitch);
        float x = pos.func_177958_n();
        float y = (float)pos.func_177956_o() * f + (float)pos.func_177952_p() * f1;
        float z = (float)pos.func_177952_p() * f - (float)pos.func_177956_o() * f1;
        return new BlockPos(Math.round(x), Math.round(y), Math.round(z));
    }

    public static BlockPos rotateYaw(BlockPos pos, float yaw) {
        float f = MathHelper.func_76134_b((float)yaw);
        float f1 = MathHelper.func_76126_a((float)yaw);
        double x = (double)pos.func_177958_n() * (double)f + (double)pos.func_177952_p() * (double)f1;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() * (double)f - (double)pos.func_177958_n() * (double)f1;
        return new BlockPos(x, y, z);
    }

    public static BlockPos rotateDirection(BlockPos pos, Direction facing) {
        switch (facing) {
            default: {
                return pos;
            }
            case WEST: {
                return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
            case NORTH: {
                return new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), -pos.func_177952_p());
            }
            case EAST: 
        }
        return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
    }

    public static VoxelShape rotateDirection(VoxelShape shape, Direction facing) {
        VoxelShape[] temp = new VoxelShape[]{shape.func_197751_a(-0.5, 0.0, -0.5), VoxelShapes.func_197880_a()};
        for (int i = 0; i < facing.func_176736_b(); ++i) {
            temp[0].func_197755_b((x1, y1, z1, x2, y2, z2) -> {
                temp[1] = VoxelShapes.func_197872_a((VoxelShape)temp[1], (VoxelShape)VoxelShapes.func_197873_a((double)(-z1), (double)y1, (double)x1, (double)(-z2), (double)y2, (double)x2));
            });
            temp[0] = temp[1];
            temp[1] = VoxelShapes.func_197880_a();
        }
        return temp[0].func_197751_a(0.5, 0.0, 0.5);
    }

    public static Vector3i shiftAxis(Vector3i pos) {
        return new Vector3i(pos.func_177956_o(), pos.func_177952_p(), pos.func_177958_n());
    }

    public static double getHorizontalAngle(Vector3d a, Vector3d b) {
        return MathHelper.func_181159_b((double)(a.field_72450_a - b.field_72450_a), (double)(a.field_72449_c - b.field_72449_c));
    }
}

