/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schematic.BaseSchematic;
import se.mickelus.tetra.module.schematic.OutcomeMaterial;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.util.CastOptional;

public class RepairSchematic
extends BaseSchematic {
    private static final String localizationPrefix = "tetra/schematic/";
    private static final String nameSuffix = ".name";
    private static final String slotSuffix = ".slot1";
    private static final String descriptionSuffix = ".description";
    private static final String extendedDescriptionSuffix = ".description_details";
    private String key = "repair";
    private IModularItem item;
    private GlyphData glyph = new GlyphData(GuiTextures.workbench, 0, 52);

    public RepairSchematic(IModularItem item) {
        this.item = item;
    }

    public String getSlot(ItemStack itemStack) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getRepairSlot(itemStack)).orElse(null);
    }

    @Override
    public String getKey() {
        return this.key + "/" + this.item.getItem().getRegistryName().func_110623_a();
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)(localizationPrefix + this.key + nameSuffix), (Object[])new Object[0]);
    }

    @Override
    public String getDescription(@Nullable ItemStack itemStack) {
        return Optional.ofNullable(itemStack).flatMap(stack -> CastOptional.cast(itemStack.func_77973_b(), IModularItem.class)).map(item -> {
            ItemModule[] cycle = item.getRepairCycle(itemStack);
            ItemModule currentTarget = item.getRepairModule(itemStack).orElse(null);
            if (currentTarget != null) {
                return Arrays.stream(cycle).map(module -> {
                    String name = module.getName(itemStack);
                    return currentTarget.equals(module) ? TextFormatting.WHITE + name + TextFormatting.RESET : name;
                }).collect(Collectors.joining(", "));
            }
            return null;
        }).map(cycle -> I18n.func_135052_a((String)(localizationPrefix + this.key + extendedDescriptionSuffix), (Object[])new Object[]{cycle})).orElseGet(() -> I18n.func_135052_a((String)(localizationPrefix + this.key + descriptionSuffix), (Object[])new Object[0]));
    }

    @Override
    public int getNumMaterialSlots() {
        return 1;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return I18n.func_135052_a((String)(localizationPrefix + this.key + slotSuffix), (Object[])new Object[0]);
    }

    @Override
    public ItemStack[] getSlotPlaceholders(ItemStack itemStack, int index) {
        return (ItemStack[])CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getRepairDefinitions(itemStack)).map(Collection::stream).orElse(Stream.empty()).map(definition -> definition.material).map(OutcomeMaterial::getApplicableItemStacks).flatMap(Arrays::stream).toArray(ItemStack[]::new);
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        if (index == 0 && itemStack.func_77973_b() instanceof IModularItem) {
            IModularItem item = (IModularItem)itemStack.func_77973_b();
            return item.getRepairMaterialCount(itemStack, materialStack);
        }
        return 0;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, String itemSlot, int index, ItemStack materialStack) {
        if (index == 0) {
            return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getRepairDefinitions(itemStack)).map(Collection::stream).orElse(Stream.empty()).map(definition -> definition.material.getPredicate()).anyMatch(predicate -> predicate.func_192493_a(materialStack));
        }
        return false;
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        return this.item.getClass().isInstance(itemStack.func_77973_b());
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return slot == null;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, PlayerEntity player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        IModularItem item = (IModularItem)upgradedStack.func_77973_b();
        int quantity = this.getRequiredQuantity(itemStack, 0, materials[0]);
        item.repair(upgradedStack);
        if (consumeMaterials) {
            materials[0].func_190918_g(quantity);
        }
        return upgradedStack;
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, String itemSlot, ItemStack[] materials) {
        return this.acceptsMaterial(itemStack, itemSlot, 0, materials[0]) && materials[0].func_190916_E() >= this.getRequiredQuantity(itemStack, 0, materials[0]);
    }

    @Override
    public boolean isIntegrityViolation(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot) {
        return false;
    }

    @Override
    public Map<ToolType, Integer> getRequiredToolLevels(ItemStack targetStack, ItemStack[] materials) {
        return CastOptional.cast(targetStack.func_77973_b(), IModularItem.class).map(item -> item.getRepairRequiredToolLevels(targetStack, materials[0])).orElseGet(Collections::emptyMap);
    }

    @Override
    public int getRequiredToolLevel(ItemStack targetStack, ItemStack[] materials, ToolType toolType) {
        return CastOptional.cast(targetStack.func_77973_b(), IModularItem.class).map(item -> item.getRepairRequiredToolLevel(targetStack, materials[0], toolType)).orElse(0);
    }

    @Override
    public int getExperienceCost(ItemStack targetStack, ItemStack[] materials, String slot) {
        return CastOptional.cast(targetStack.func_77973_b(), IModularItem.class).map(item -> item.getRepairRequiredExperience(targetStack)).orElse(0);
    }

    @Override
    public SchematicType getType() {
        return SchematicType.other;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }
}

