/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.schematic.BaseSchematic;
import se.mickelus.tetra.module.schematic.SchematicType;

public class RemoveSchematic
extends BaseSchematic {
    private static final String localizationPrefix = "tetra/schematic/";
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private String key = "remove";
    private IModularItem item;
    private String slot;
    private GlyphData glyph = new GlyphData(GuiTextures.workbench, 52, 32);

    public RemoveSchematic(IModularItem item, String slot) {
        this.item = item;
        this.slot = slot;
    }

    public static void registerRemoveSchematics(IModularItem item) {
        Stream.concat(Arrays.stream(item.getMajorModuleKeys()), Arrays.stream(item.getMinorModuleKeys())).filter(slot -> !item.isModuleRequired((String)slot)).forEach(slot -> {
            RemoveSchematic schematic = new RemoveSchematic(item, (String)slot);
            SchematicRegistry.instance.registerSchematic(schematic);
        });
    }

    @Override
    public String getKey() {
        return this.key + "/" + this.item.getItem().getRegistryName().func_110623_a() + "/" + this.slot;
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)(localizationPrefix + this.key + nameSuffix), (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        return I18n.func_135052_a((String)(localizationPrefix + this.key + descriptionSuffix), (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 0;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return "";
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        return 0;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, String itemSlot, int index, ItemStack materialStack) {
        return false;
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        return this.item.getClass().isInstance(itemStack.func_77973_b());
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return this.slot.equals(slot) && this.item.getModuleFromSlot(targetStack, this.slot) != null;
    }

    @Override
    public boolean canApplyUpgrade(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot, Map<ToolType, Integer> availableTools) {
        return !this.isIntegrityViolation(player, itemStack, materials, slot) && this.checkTools(itemStack, materials, availableTools);
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, String itemSlot, ItemStack[] materials) {
        return true;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, PlayerEntity player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        IModularItem item = (IModularItem)itemStack.func_77973_b();
        float durabilityFactor = 0.0f;
        if (consumeMaterials && upgradedStack.func_77984_f()) {
            durabilityFactor = (float)upgradedStack.func_77952_i() * 1.0f / (float)upgradedStack.func_77958_k();
        }
        float honingFactor = MathHelper.func_76131_a((float)(1.0f * (float)item.getHoningProgress(upgradedStack) / (float)item.getHoningLimit(upgradedStack)), (float)0.0f, (float)1.0f);
        ItemModule previousModule = item.getModuleFromSlot(upgradedStack, slot);
        if (previousModule != null) {
            previousModule.removeModule(upgradedStack);
            if (consumeMaterials) {
                previousModule.postRemove(upgradedStack, player);
            }
        }
        if (consumeMaterials) {
            if (((Boolean)ConfigHandler.moduleProgression.get()).booleanValue() && IModularItem.isHoneable(upgradedStack)) {
                item.setHoningProgress(upgradedStack, (int)Math.ceil(honingFactor * (float)item.getHoningLimit(upgradedStack)));
            }
            if (upgradedStack.func_77984_f()) {
                upgradedStack.func_196085_b((int)(durabilityFactor * (float)upgradedStack.func_77958_k()));
            }
        }
        return upgradedStack;
    }

    @Override
    public Map<ToolType, Integer> getRequiredToolLevels(ItemStack targetStack, ItemStack[] materials) {
        return Collections.singletonMap(ToolTypes.hammer, 1);
    }

    @Override
    public SchematicType getType() {
        return SchematicType.other;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }
}

