/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.EnchantmentMapping;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.schematic.OutcomePreview;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.util.CastOptional;

public class BookEnchantSchematic
implements UpgradeSchematic {
    private static final String localizationPrefix = "tetra/schematic/";
    private static final String key = "book_enchant";
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private static final String slotSuffix = ".slot1";
    private GlyphData glyph = new GlyphData(GuiTextures.workbench, 80, 32);

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)"tetra/schematic/book_enchant.name", (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        return I18n.func_135052_a((String)"tetra/schematic/book_enchant.description", (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 1;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return I18n.func_135052_a((String)"tetra/schematic/book_enchant.slot1", (Object[])new Object[0]);
    }

    @Override
    public ItemStack[] getSlotPlaceholders(ItemStack itemStack, int index) {
        return new ItemStack[]{Items.field_151134_bR.func_190903_i()};
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        return 1;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, String itemSlot, int index, ItemStack materialStack) {
        ItemModuleMajor module = CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, itemSlot)).flatMap(mod -> CastOptional.cast(mod, ItemModuleMajor.class)).orElse(null);
        return module != null && !materialStack.func_190926_b() && materialStack.func_77973_b() instanceof EnchantedBookItem && EnchantmentHelper.func_82781_a((ItemStack)materialStack).entrySet().stream().anyMatch(entry -> Arrays.stream(ItemUpgradeRegistry.instance.getEnchantmentMappings((Enchantment)entry.getKey())).anyMatch(mapping -> module.acceptsImprovementLevel(mapping.improvement, (int)((float)((Integer)entry.getValue()).intValue() / mapping.multiplier))));
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, String itemSlot, ItemStack[] materials) {
        return this.acceptsMaterial(itemStack, itemSlot, 0, materials[0]);
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof IModularItem;
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        return CastOptional.cast(targetStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(targetStack, slot)).map(module -> module.getMagicCapacityGain(targetStack) > 0).orElse(false);
    }

    @Override
    public boolean canApplyUpgrade(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot, Map<ToolType, Integer> availableTools) {
        return this.isMaterialsValid(itemStack, slot, materials) && (player.func_184812_l_() || player.field_71068_ca >= this.getExperienceCost(itemStack, materials, slot));
    }

    @Override
    public boolean isIntegrityViolation(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot) {
        return false;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, PlayerEntity player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        ItemModuleMajor module = CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).filter(mod -> mod instanceof ItemModuleMajor).map(mod -> (ItemModuleMajor)mod).orElse(null);
        if (module != null) {
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)materials[0]);
            for (Map.Entry entry : enchantments.entrySet()) {
                for (EnchantmentMapping mapping : ItemUpgradeRegistry.instance.getEnchantmentMappings((Enchantment)entry.getKey())) {
                    if (!module.acceptsImprovementLevel(mapping.improvement, (Integer)entry.getValue())) continue;
                    module.addImprovement(upgradedStack, mapping.improvement, (Integer)entry.getValue());
                    if (!consumeMaterials || !(player instanceof ServerPlayerEntity)) continue;
                    ImprovementCraftCriterion.trigger((ServerPlayerEntity)player, itemStack, upgradedStack, this.getKey(), slot, mapping.improvement, (int)((float)((Integer)entry.getValue()).intValue() / mapping.multiplier), null, -1);
                }
            }
            if (consumeMaterials) {
                materials[0].func_190918_g(1);
            }
        }
        return upgradedStack;
    }

    @Override
    public boolean checkTools(ItemStack targetStack, ItemStack[] materials, Map<ToolType, Integer> availableTools) {
        return true;
    }

    @Override
    public Map<ToolType, Integer> getRequiredToolLevels(ItemStack targetStack, ItemStack[] materials) {
        return Collections.emptyMap();
    }

    @Override
    public int getExperienceCost(ItemStack targetStack, ItemStack[] materials, String slot) {
        return CastOptional.cast(targetStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(targetStack, slot)).flatMap(module -> CastOptional.cast(module, ItemModuleMajor.class)).map(module -> {
            int cost = 0;
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)materials[0]);
            for (Map.Entry entry : enchantments.entrySet()) {
                for (EnchantmentMapping mapping : ItemUpgradeRegistry.instance.getEnchantmentMappings((Enchantment)entry.getKey())) {
                    if (!module.acceptsImprovementLevel(mapping.improvement, (int)((float)((Integer)entry.getValue()).intValue() / mapping.multiplier))) continue;
                    cost = (int)((float)cost + (float)((Integer)entry.getValue()).intValue() / mapping.multiplier);
                }
            }
            return cost;
        }).orElse(0);
    }

    @Override
    public SchematicType getType() {
        return SchematicType.improvement;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }

    @Override
    public OutcomePreview[] getPreviews(ItemStack targetStack, String slot) {
        ItemModuleMajor module = CastOptional.cast(targetStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(targetStack, slot)).flatMap(m -> CastOptional.cast(m, ItemModuleMajor.class)).orElse(null);
        if (module != null) {
            ToolData emptyTools = new ToolData();
            return (OutcomePreview[])Arrays.stream(ItemUpgradeRegistry.instance.getEnchantmentMappings()).filter(mapping -> mapping.enchantment != null).filter(mapping -> !mapping.enchantment.func_190936_d()).filter(mapping -> mapping.extract).filter(mapping -> module.acceptsImprovement(mapping.improvement)).flatMap(mapping -> IntStream.range(mapping.enchantment.func_77319_d(), mapping.enchantment.func_77325_b() + 1).mapToObj(level -> {
                ItemStack enchantedStack = targetStack.func_77946_l();
                module.addImprovement(enchantedStack, mapping.improvement, level);
                return new OutcomePreview(null, mapping.improvement, IModularItem.getImprovementName(mapping.improvement, level), "misc", level, this.glyph, enchantedStack, SchematicType.improvement, emptyTools, new ItemStack[0]);
            })).toArray(OutcomePreview[]::new);
        }
        return new OutcomePreview[0];
    }
}

