/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.module.data.TierData;

public class ToolData
extends TierData<ToolType> {
    public static ToolData overwrite(ToolData a, ToolData b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ToolData result = new ToolData();
        result.levelMap.putAll(a.levelMap);
        result.efficiencyMap.putAll(a.efficiencyMap);
        b.levelMap.forEach(result.levelMap::put);
        b.efficiencyMap.forEach(result.efficiencyMap::put);
        return result;
    }

    public static ToolData merge(Collection<ToolData> data) {
        return data.stream().reduce(null, ToolData::merge);
    }

    public static ToolData merge(ToolData a, ToolData b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ToolData result = new ToolData();
        result.levelMap = Stream.of(a, b).map(toolData -> toolData.levelMap).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Float::sum));
        result.efficiencyMap = Stream.of(a, b).map(toolData -> toolData.efficiencyMap).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Float::sum));
        return result;
    }

    public static ToolData multiply(ToolData toolData, float levelMultiplier, float efficiencyMultiplier) {
        return Optional.ofNullable(toolData).map(data -> {
            ToolData result = new ToolData();
            result.levelMap = data.levelMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Float.valueOf(((Float)entry.getValue()).floatValue() * levelMultiplier)));
            result.efficiencyMap = data.efficiencyMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Float.valueOf(((Float)entry.getValue()).floatValue() * efficiencyMultiplier)));
            return result;
        }).orElse(null);
    }

    public static ToolData offsetLevel(ToolData toolData, float multiplier, int offset) {
        return Optional.ofNullable(toolData).map(data -> {
            ToolData result = new ToolData();
            result.levelMap = data.levelMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Float.valueOf(((Float)entry.getValue()).floatValue() * multiplier + (float)offset)));
            result.efficiencyMap = data.efficiencyMap;
            return result;
        }).orElse(null);
    }

    public static ToolData retainMax(Collection<ToolData> dataCollection) {
        ToolData result = new ToolData();
        dataCollection.forEach(data -> data.getValues().forEach(tool -> {
            float level = data.levelMap.getOrDefault(tool, Float.valueOf(0.0f)).floatValue();
            if (level >= result.levelMap.getOrDefault(tool, Float.valueOf(0.0f)).floatValue()) {
                result.levelMap.put(tool, Float.valueOf(level));
                if (data.getEfficiency(tool) > result.getEfficiency(tool)) {
                    result.efficiencyMap.put(tool, Float.valueOf(data.getEfficiency(tool)));
                }
            }
        }));
        return result;
    }

    public static class Deserializer
    implements JsonDeserializer<ToolData> {
        public ToolData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            ToolData data = new ToolData();
            jsonObject.entrySet().forEach(entry -> {
                JsonElement entryValue = (JsonElement)entry.getValue();
                ToolType toolType = ToolType.get((String)((String)entry.getKey()));
                if (entryValue.isJsonArray()) {
                    JsonArray entryArray = entryValue.getAsJsonArray();
                    if (entryArray.size() == 2) {
                        data.levelMap.put(toolType, Float.valueOf(entryArray.get(0).getAsFloat()));
                        data.efficiencyMap.put(toolType, Float.valueOf(entryArray.get(1).getAsFloat()));
                    }
                } else {
                    data.levelMap.put(toolType, Float.valueOf(entryValue.getAsFloat()));
                }
            });
            return data;
        }
    }
}

