/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.data;

public class ItemProperties {
    public int durability = 0;
    public float durabilityMultiplier = 1.0f;
    public int integrity = 0;
    public int integrityUsage = 0;
    public float integrityMultiplier = 1.0f;

    public static ItemProperties merge(ItemProperties a, ItemProperties b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ItemProperties result = new ItemProperties();
        result.durability = a.durability + b.durability;
        result.durabilityMultiplier = a.durabilityMultiplier * b.durabilityMultiplier;
        if (a.integrity < 0) {
            result.integrityUsage -= a.integrity;
        } else {
            result.integrity += a.integrity;
        }
        if (b.integrity < 0) {
            result.integrityUsage -= b.integrity;
        } else {
            result.integrity += b.integrity;
        }
        result.integrityUsage += a.integrityUsage + b.integrityUsage;
        return result;
    }

    public ItemProperties multiply(float factor) {
        ItemProperties result = new ItemProperties();
        result.durability = Math.round((float)this.durability * factor);
        if (this.durabilityMultiplier != 1.0f) {
            result.durabilityMultiplier = 1.0f + (this.durabilityMultiplier - 1.0f) * factor;
        }
        result.integrity = Math.round((float)this.integrity * factor);
        result.integrityUsage = Math.round((float)this.integrityUsage * factor);
        if (this.integrityMultiplier != 1.0f) {
            result.integrityMultiplier = 1.0f + (this.integrityMultiplier - 1.0f) * factor;
        }
        return result;
    }
}

