/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.apache.commons.lang3.ArrayUtils;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ItemColors;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.ItemProperties;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.data.TweakData;
import se.mickelus.tetra.module.improvement.SettlePacket;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.util.CastOptional;

public abstract class ItemModuleMajor
extends ItemModule {
    protected ImprovementData[] improvements = new ImprovementData[0];
    public static final String settleImprovement = "settled";
    public static final String arrestedImprovement = "arrested";
    protected int settleMax = 0;
    private String settleProgressKey = this.getSlot() + this.settleProgressKey;

    public ItemModuleMajor(String slotKey, String moduleKey) {
        super(slotKey, moduleKey);
    }

    public void tickProgression(LivingEntity entity, ItemStack itemStack, int multiplier) {
        int settleMaxCount = this.getSettleMaxCount(itemStack);
        if (settleMaxCount == 0) {
            return;
        }
        CompoundNBT tag = itemStack.func_196082_o();
        int settleLevel = this.getImprovementLevel(itemStack, settleImprovement);
        if (settleLevel < settleMaxCount && this.getImprovementLevel(itemStack, arrestedImprovement) == -1) {
            int settleProgress = this.getSettleProgress(itemStack);
            tag.func_74768_a(this.settleProgressKey, settleProgress -= multiplier);
            if (settleProgress <= 0) {
                this.addImprovement(itemStack, settleImprovement, settleLevel == -1 ? 1 : settleLevel + 1);
                tag.func_82580_o(this.settleProgressKey);
                if (entity instanceof ServerPlayerEntity) {
                    TetraMod.packetHandler.sendTo(new SettlePacket(itemStack, this.getSlot()), (ServerPlayerEntity)entity);
                }
            }
        }
    }

    public int getSettleProgress(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.func_77978_p()).filter(tag -> tag.func_74764_b(this.settleProgressKey)).map(tag -> tag.func_74762_e(this.settleProgressKey)).orElseGet(() -> this.getSettleLimit(itemStack));
    }

    public int getSettleLimit(ItemStack itemStack) {
        return (int)(((double)((Integer)ConfigHandler.settleLimitBase.get()).intValue() + (double)this.getDurability(itemStack) * (Double)ConfigHandler.settleLimitDurabilityMultiplier.get()) * Math.max((double)this.getImprovementLevel(itemStack, settleImprovement) * (Double)ConfigHandler.settleLimitLevelMultiplier.get(), 1.0));
    }

    public int getSettleMaxCount(ItemStack itemStack) {
        if (this.settleMax == 0) {
            return 0;
        }
        int integrity = this.getVariantData((ItemStack)itemStack).integrity;
        if (integrity <= -4 || integrity >= 6) {
            return this.settleMax;
        }
        if (integrity != 0) {
            return 1;
        }
        return 0;
    }

    protected void clearProgression(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            itemStack.func_77978_p().func_82580_o(String.format(this.settleProgressKey, this.getSlot()));
        }
    }

    public int getImprovementLevel(ItemStack itemStack, String improvementKey) {
        return Optional.ofNullable(itemStack.func_77978_p()).filter(tag -> tag.func_74764_b(this.slotTagKey + ":" + improvementKey)).map(tag -> tag.func_74762_e(this.slotTagKey + ":" + improvementKey)).orElse(-1);
    }

    public ImprovementData getImprovement(ItemStack itemStack, String improvementKey) {
        if (itemStack.func_77942_o()) {
            CompoundNBT tag = itemStack.func_77978_p();
            return Arrays.stream(this.improvements).filter(improvement -> improvementKey.equals(improvement.key)).filter(improvement -> tag.func_74764_b(this.slotTagKey + ":" + improvement.key)).filter(improvement -> improvement.level == tag.func_74762_e(this.slotTagKey + ":" + improvement.key)).findAny().orElse(null);
        }
        return null;
    }

    public ImprovementData[] getImprovements(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            CompoundNBT tag = itemStack.func_77978_p();
            return (ImprovementData[])Arrays.stream(this.improvements).filter(improvement -> tag.func_74764_b(this.slotTagKey + ":" + improvement.key)).filter(improvement -> improvement.level == tag.func_74762_e(this.slotTagKey + ":" + improvement.key)).toArray(ImprovementData[]::new);
        }
        return new ImprovementData[0];
    }

    public boolean acceptsImprovement(String improvementKey) {
        return Arrays.stream(this.improvements).map(improvement -> improvement.key).anyMatch(improvementKey::equals);
    }

    public boolean acceptsImprovementLevel(String improvementKey, int level) {
        return Arrays.stream(this.improvements).filter(improvement -> improvementKey.equals(improvement.key)).anyMatch(improvement -> level == improvement.level);
    }

    public void addImprovement(ItemStack itemStack, String improvementKey, int level) {
        this.removeCollidingImprovements(itemStack, improvementKey, level);
        itemStack.func_196082_o().func_74768_a(this.slotTagKey + ":" + improvementKey, level);
    }

    public static void addImprovement(ItemStack itemStack, String slot, String improvement, int level) {
        IModularItem item = (IModularItem)itemStack.func_77973_b();
        CastOptional.cast(item.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class).filter(module -> module.acceptsImprovementLevel(improvement, level)).ifPresent(module -> module.addImprovement(itemStack, improvement, level));
    }

    public void removeCollidingImprovements(ItemStack itemStack, String improvementKey, int level) {
        Arrays.stream(this.improvements).filter(improvement -> improvementKey.equals(improvement.key)).filter(improvement -> level == improvement.level).filter(improvement -> improvement.group != null).map(improvement -> improvement.group).findFirst().ifPresent(group -> Arrays.stream(this.getImprovements(itemStack)).filter(improvement -> group.equals(improvement.group)).forEach(improvement -> ItemModuleMajor.removeImprovement(itemStack, this.slotTagKey, improvement.key)));
    }

    public void removeImprovement(ItemStack itemStack, String improvement) {
        ItemModuleMajor.removeImprovement(itemStack, this.slotTagKey, improvement);
    }

    public static void removeImprovement(ItemStack itemStack, String slot, String improvement) {
        if (itemStack.func_77942_o()) {
            itemStack.func_77978_p().func_82580_o(slot + ":" + improvement);
        }
    }

    public void removeEnchantments(ItemStack itemStack) {
        Arrays.stream(this.improvements).filter(improvement -> improvement.enchantment).forEach(improvement -> this.removeImprovement(itemStack, improvement.key));
    }

    @Override
    public boolean isTweakable(ItemStack itemStack) {
        String[] improvementKeys = (String[])Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.key).toArray(String[]::new);
        return Arrays.stream(this.tweaks).anyMatch(tweak -> ArrayUtils.contains((Object[])improvementKeys, (Object)tweak.improvement)) || super.isTweakable(itemStack);
    }

    @Override
    public TweakData[] getTweaks(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            String variant = itemStack.func_77978_p().func_74779_i(this.variantTagKey);
            String[] improvementKeys = (String[])Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.key).toArray(String[]::new);
            return (TweakData[])Arrays.stream(this.tweaks).filter(tweak -> variant.equals(tweak.variant) || ArrayUtils.contains((Object[])improvementKeys, (Object)tweak.improvement)).toArray(TweakData[]::new);
        }
        return new TweakData[0];
    }

    @Override
    public ItemStack[] removeModule(ItemStack targetStack) {
        ItemStack[] salvage = super.removeModule(targetStack);
        if (targetStack.func_77942_o()) {
            CompoundNBT tag = targetStack.func_77978_p();
            Arrays.stream(this.improvements).map(improvement -> this.slotTagKey + ":" + improvement.key).forEach(arg_0 -> ((CompoundNBT)tag).func_82580_o(arg_0));
            this.clearProgression(targetStack);
        }
        return salvage;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.attributes).filter(Objects::nonNull).reduce(super.getAttributeModifiers(itemStack), AttributeHelper::merge);
    }

    @Override
    public ItemProperties getProperties(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).reduce(super.getProperties(itemStack), ItemProperties::merge, ItemProperties::merge);
    }

    @Override
    public EffectData getEffectData(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.effects).filter(Objects::nonNull).reduce(super.getEffectData(itemStack), EffectData::merge);
    }

    @Override
    public ToolData getToolData(ItemStack itemStack) {
        return Arrays.stream(this.getImprovements(itemStack)).map(improvement -> improvement.tools).filter(Objects::nonNull).reduce(super.getToolData(itemStack), ToolData::merge);
    }

    @Override
    public int getMagicCapacityGain(ItemStack itemStack) {
        return super.getMagicCapacityGain(itemStack) + this.getImprovementMagicCapacityGain(itemStack);
    }

    @Override
    public int getMagicCapacityCost(ItemStack itemStack) {
        return super.getMagicCapacityCost(itemStack) + this.getImprovementMagicCapacityCost(itemStack);
    }

    public int getImprovementMagicCapacityGain(ItemStack itemStack) {
        return Math.round(((Double)ConfigHandler.magicCapacityMultiplier.get()).floatValue() * CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> Float.valueOf(item.getStabilityModifier(itemStack))).orElse(Float.valueOf(1.0f)).floatValue() * (float)Arrays.stream(this.getImprovements(itemStack)).mapToInt(improvement -> improvement.magicCapacity).filter(magicCapacity -> magicCapacity > 0).sum());
    }

    public int getImprovementMagicCapacityCost(ItemStack itemStack) {
        return -Arrays.stream(this.getImprovements(itemStack)).mapToInt(improvement -> improvement.magicCapacity).filter(integrity -> integrity < 0).sum();
    }

    protected ModuleModel[] getImprovementModels(ItemStack itemStack, int tint) {
        return (ModuleModel[])Arrays.stream(this.getImprovements(itemStack)).filter(improvement -> improvement.models.length > 0).flatMap(improvement -> Arrays.stream(improvement.models)).map(model -> ItemColors.inherit == model.tint ? new ModuleModel(model.type, model.location, tint) : model).toArray(ModuleModel[]::new);
    }

    @Override
    public ModuleModel[] getModels(ItemStack itemStack) {
        Object[] models;
        return (ModuleModel[])ArrayUtils.addAll((Object[])models, (Object[])this.getImprovementModels(itemStack, (models = super.getModels(itemStack)).length > 0 ? models[0].tint : 0xFFFFFF));
    }
}

