/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolType;
import org.apache.commons.lang3.StringUtils;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.Priority;
import se.mickelus.tetra.module.RepairRegistry;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.ItemProperties;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.TierData;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.data.TweakData;
import se.mickelus.tetra.module.data.VariantData;
import se.mickelus.tetra.module.schematic.RepairDefinition;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.properties.IToolProvider;
import se.mickelus.tetra.util.CastOptional;

public abstract class ItemModule
implements IToolProvider {
    protected VariantData[] variantData = new VariantData[0];
    protected TweakData[] tweaks = new TweakData[0];
    protected final String slotTagKey;
    protected final String moduleKey;
    protected final String variantTagKey;
    protected Priority renderLayer = Priority.BASE;
    public static final float repairLevelFactor = 10.0f;

    public ItemModule(String slotKey, String moduleKey) {
        this.slotTagKey = slotKey;
        this.moduleKey = moduleKey;
        this.variantTagKey = moduleKey + "_material";
    }

    public String getKey() {
        return this.moduleKey;
    }

    public String getUnlocalizedName() {
        return this.moduleKey;
    }

    public String getSlot() {
        return this.slotTagKey;
    }

    public void addModule(ItemStack targetStack, String variantKey, PlayerEntity player) {
        CompoundNBT tag = targetStack.func_196082_o();
        tag.func_74778_a(this.slotTagKey, this.moduleKey);
        tag.func_74778_a(this.variantTagKey, variantKey);
    }

    public ItemStack[] removeModule(ItemStack targetStack) {
        CompoundNBT tag = targetStack.func_196082_o();
        tag.func_82580_o(this.slotTagKey);
        tag.func_82580_o(this.variantTagKey);
        return new ItemStack[0];
    }

    public void postRemove(ItemStack targetStack, PlayerEntity player) {
    }

    public VariantData[] getVariantData() {
        return this.variantData;
    }

    public VariantData getVariantData(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.func_77978_p()).map(tag -> tag.func_74779_i(this.variantTagKey)).map(key -> this.getVariantData((String)key)).orElseGet(this::getDefaultData);
    }

    public VariantData getVariantData(String variantKey) {
        return Arrays.stream(this.variantData).filter(moduleData -> moduleData.key.equals(variantKey)).findAny().orElseGet(this::getDefaultData);
    }

    public ItemProperties getProperties(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.getProperties(this.getTweakStep(itemStack, (TweakData)tweak))).reduce(ItemProperties.merge(new ItemProperties(), this.getVariantData(itemStack)), ItemProperties::merge);
    }

    public VariantData getDefaultData() {
        return this.variantData.length > 0 ? this.variantData[0] : new VariantData();
    }

    public static String getName(String moduleKey, String variantKey) {
        if (I18n.func_188566_a((String)("tetra.variant." + variantKey))) {
            return I18n.func_135052_a((String)("tetra.variant." + variantKey), (Object[])new Object[0]);
        }
        if (I18n.func_188566_a((String)("tetra.module." + moduleKey + ".material_name"))) {
            String variant = variantKey.substring(variantKey.indexOf(47) + 1);
            if (I18n.func_188566_a((String)("tetra.material." + variant + ".prefix"))) {
                return StringUtils.capitalize((String)I18n.func_135052_a((String)("tetra.module." + moduleKey + ".material_name"), (Object[])new Object[]{I18n.func_135052_a((String)("tetra.material." + variant + ".prefix"), (Object[])new Object[0])}).toLowerCase());
            }
        }
        return I18n.func_135052_a((String)("tetra.variant." + variantKey), (Object[])new Object[0]);
    }

    public String getName(ItemStack itemStack) {
        String key = this.getVariantData((ItemStack)itemStack).key;
        return ItemModule.getName(this.getUnlocalizedName(), key);
    }

    public String getDescription(ItemStack itemStack) {
        String descriptionKey = "tetra.variant." + this.getVariantData((ItemStack)itemStack).key + ".description";
        if (I18n.func_188566_a((String)descriptionKey)) {
            return I18n.func_135052_a((String)descriptionKey, (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)("tetra.module." + this.getUnlocalizedName() + ".description"), (Object[])new Object[0]);
    }

    public String getItemName(ItemStack itemStack) {
        String variantItemNameKey = "tetra.variant." + this.getVariantData((ItemStack)itemStack).key + ".item_name";
        if (I18n.func_188566_a((String)variantItemNameKey)) {
            return I18n.func_135052_a((String)variantItemNameKey, (Object[])new Object[0]);
        }
        String moduleItemNameKey = "tetra.module." + this.getUnlocalizedName() + ".item_name";
        if (I18n.func_188566_a((String)moduleItemNameKey)) {
            return I18n.func_135052_a((String)moduleItemNameKey, (Object[])new Object[0]);
        }
        return null;
    }

    public Priority getItemNamePriority(ItemStack itemStack) {
        return Priority.BASE;
    }

    public String getItemPrefix(ItemStack itemStack) {
        String key = this.getVariantData((ItemStack)itemStack).key;
        String variantPrefixKey = "tetra.variant." + key + ".prefix";
        if (I18n.func_188566_a((String)variantPrefixKey)) {
            return I18n.func_135052_a((String)variantPrefixKey, (Object[])new Object[0]);
        }
        String modulePrefixKey = "tetra.module." + this.getUnlocalizedName() + ".prefix";
        if (I18n.func_188566_a((String)modulePrefixKey)) {
            String prefix = I18n.func_135052_a((String)modulePrefixKey, (Object[])new Object[0]);
            if (prefix.startsWith("Format error:")) {
                String variant = key.substring(key.indexOf(47) + 1);
                return StringUtils.capitalize((String)I18n.func_135052_a((String)modulePrefixKey, (Object[])new Object[]{I18n.func_135052_a((String)("tetra.material." + variant + ".prefix"), (Object[])new Object[0]).toLowerCase()}));
            }
            return prefix;
        }
        return null;
    }

    public Priority getItemPrefixPriority(ItemStack itemStack) {
        return Priority.BASE;
    }

    public int getIntegrityGain(ItemStack itemStack) {
        return Math.max(this.getProperties((ItemStack)itemStack).integrity, 0);
    }

    public int getIntegrityCost(ItemStack itemStack) {
        return Math.max(this.getProperties((ItemStack)itemStack).integrityUsage, 0);
    }

    public int getMagicCapacity(ItemStack itemStack) {
        return this.getMagicCapacityGain(itemStack) - this.getMagicCapacityCost(itemStack);
    }

    public int getMagicCapacityGain(ItemStack itemStack) {
        int magicCapacity = this.getVariantData((ItemStack)itemStack).magicCapacity;
        if (magicCapacity > 0) {
            float stabilityMultiplier = CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> Float.valueOf(item.getStabilityModifier(itemStack))).orElse(Float.valueOf(1.0f)).floatValue();
            return Math.round((float)magicCapacity * ((Double)ConfigHandler.magicCapacityMultiplier.get()).floatValue() * stabilityMultiplier);
        }
        return 0;
    }

    public int getMagicCapacityCost(ItemStack itemStack) {
        int magicCapacity = this.getVariantData((ItemStack)itemStack).magicCapacity;
        if (magicCapacity < 0) {
            return -magicCapacity;
        }
        return 0;
    }

    public float getDestabilizationChance(ItemStack itemStack, float probabilityMultiplier) {
        return this.getDestabilizationChance(-this.getMagicCapacity(itemStack), this.getMagicCapacityGain(itemStack), probabilityMultiplier);
    }

    public float getDestabilizationChance(int instability, int capacity, float probabilityMultiplier) {
        return Math.max(probabilityMultiplier * (float)instability / (float)capacity, 0.0f);
    }

    public int getDurability(ItemStack itemStack) {
        return this.getProperties((ItemStack)itemStack).durability;
    }

    public float getDurabilityMultiplier(ItemStack itemStack) {
        return this.getProperties((ItemStack)itemStack).durabilityMultiplier;
    }

    public Collection<RepairDefinition> getRepairDefinitions(ItemStack itemStack) {
        return RepairRegistry.instance.getDefinitions(this.getVariantData((ItemStack)itemStack).key);
    }

    public RepairDefinition getRepairDefinition(ItemStack itemStack, ItemStack materialStack) {
        return RepairRegistry.instance.getDefinitions(this.getVariantData((ItemStack)itemStack).key).stream().filter(definition -> definition.material.isValid()).filter(definition -> definition.material.getPredicate().func_192493_a(materialStack)).findFirst().orElse(null);
    }

    public Collection<ToolType> getRepairRequiredTools(ItemStack itemStack, ItemStack materialStack) {
        return Optional.ofNullable(this.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.requiredTools.getValues()).orElseGet(Collections::emptySet);
    }

    public Map<ToolType, Integer> getRepairRequiredToolLevels(ItemStack itemStack, ItemStack materialStack) {
        return Optional.ofNullable(this.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.requiredTools.getLevelMap()).orElseGet(Collections::emptyMap);
    }

    public int getRepairRequiredToolLevel(ItemStack itemStack, ItemStack materialStack, ToolType tool) {
        return Optional.ofNullable(this.getRepairDefinition(itemStack, materialStack)).map(definition -> definition.requiredTools.getLevel(tool)).orElse(0);
    }

    public int getRepairExperienceCost(ItemStack itemStack) {
        return Optional.of(Float.valueOf(this.getDestabilizationChance(itemStack, 1.0f))).map(capacity -> Float.valueOf(capacity.floatValue() * 10.0f)).map(MathHelper::func_76123_f).map(capacity -> Math.max(0, capacity)).orElse(0);
    }

    public boolean isTweakable(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            String variant = itemStack.func_77978_p().func_74779_i(this.variantTagKey);
            return Arrays.stream(this.tweaks).anyMatch(data -> variant.equals(data.variant));
        }
        return false;
    }

    public TweakData[] getTweaks(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            String variant = itemStack.func_77978_p().func_74779_i(this.variantTagKey);
            return (TweakData[])Arrays.stream(this.tweaks).filter(tweak -> variant.equals(tweak.variant)).toArray(TweakData[]::new);
        }
        return new TweakData[0];
    }

    public boolean hasTweak(ItemStack itemStack, String tweakKey) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.key).anyMatch(tweakKey::equals);
    }

    public int getTweakStep(ItemStack itemStack, TweakData tweak) {
        return Optional.ofNullable(itemStack.func_77978_p()).map(tag -> tag.func_74762_e(this.slotTagKey + ":" + tweak.key)).map(step -> MathHelper.func_76125_a((int)step, (int)(-tweak.steps), (int)tweak.steps)).orElse(0);
    }

    public void setTweakStep(ItemStack itemStack, String tweakKey, int step) {
        itemStack.func_196082_o().func_74768_a(this.slotTagKey + ":" + tweakKey, step);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.getAttributeModifiers(this.getTweakStep(itemStack, (TweakData)tweak))).filter(Objects::nonNull).reduce(this.getVariantData((ItemStack)itemStack).attributes, AttributeHelper::merge);
    }

    public double getDamageModifier(ItemStack itemStack) {
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> modifiers.get((Object)Attributes.field_233823_f_)).map(AttributeHelper::getAdditionAmount).orElse(0.0);
    }

    public double getDamageMultiplierModifier(ItemStack itemStack) {
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> modifiers.get((Object)Attributes.field_233823_f_)).map(AttributeHelper::getMultiplyAmount).orElse(1.0);
    }

    public double getSpeedModifier(ItemStack itemStack) {
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> modifiers.get((Object)Attributes.field_233825_h_)).map(AttributeHelper::getAdditionAmount).orElse(0.0);
    }

    public double getSpeedMultiplierModifier(ItemStack itemStack) {
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> modifiers.get((Object)Attributes.field_233825_h_)).map(AttributeHelper::getMultiplyAmount).orElse(1.0);
    }

    public double getRangeModifier(ItemStack itemStack) {
        return Optional.ofNullable(this.getAttributeModifiers(itemStack)).map(modifiers -> modifiers.get((Object)ForgeMod.REACH_DISTANCE.get())).map(AttributeHelper::getAdditionAmount).orElse(0.0);
    }

    public ModuleModel[] getModels(ItemStack itemStack) {
        return this.getVariantData((ItemStack)itemStack).models;
    }

    public Priority getRenderLayer() {
        return this.renderLayer;
    }

    public int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        return Optional.ofNullable(this.getEffectData(itemStack)).map(data -> data.getLevel(effect)).orElse(0);
    }

    public float getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        return Optional.ofNullable(this.getEffectData(itemStack)).map(data -> Float.valueOf(data.getEfficiency(effect))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Collection<ItemEffect> getEffects(ItemStack itemStack) {
        return Optional.ofNullable(this.getEffectData(itemStack)).map(TierData::getValues).orElseGet(Collections::emptySet);
    }

    public EffectData getEffectData(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.getEffectData(this.getTweakStep(itemStack, (TweakData)tweak))).filter(Objects::nonNull).reduce(this.getVariantData((ItemStack)itemStack).effects, EffectData::merge);
    }

    @Override
    public boolean canProvideTools(ItemStack itemStack) {
        return true;
    }

    @Override
    public int getToolLevel(ItemStack itemStack, ToolType tool) {
        return Optional.ofNullable(this.getToolData(itemStack)).map(data -> data.getLevel(tool)).orElse(0);
    }

    @Override
    public float getToolEfficiency(ItemStack itemStack, ToolType tool) {
        return Optional.ofNullable(this.getToolData(itemStack)).map(data -> Float.valueOf(data.getEfficiency(tool))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Set<ToolType> getTools(ItemStack itemStack) {
        return Optional.ofNullable(this.getToolData(itemStack)).map(TierData::getValues).orElseGet(Collections::emptySet);
    }

    @Override
    public Map<ToolType, Integer> getToolLevels(ItemStack itemStack) {
        return Optional.ofNullable(this.getToolData(itemStack)).map(TierData::getLevelMap).orElseGet(Collections::emptyMap);
    }

    @Override
    public ToolData getToolData(ItemStack itemStack) {
        return Arrays.stream(this.getTweaks(itemStack)).map(tweak -> tweak.getToolData(this.getTweakStep(itemStack, (TweakData)tweak))).filter(Objects::nonNull).reduce(this.getVariantData((ItemStack)itemStack).tools, ToolData::merge);
    }
}

