/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.properties.IToolProvider;

public class FortuneBonusCondition
implements ILootCondition {
    public static final ResourceLocation identifier = new ResourceLocation("tetra", "random_chance_with_fortune");
    public static final LootConditionType type = new LootConditionType((ILootSerializer)new Serializer());
    private float chance;
    private float fortuneMultiplier;
    private ToolType requiredTool;
    private int requiredToolLevel = -1;

    public boolean test(LootContext context) {
        int fortuneLevel = 0;
        if (this.requiredTool != null) {
            ItemStack toolStack = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (toolStack != null && toolStack.func_77973_b() instanceof IToolProvider && ((IToolProvider)toolStack.func_77973_b()).getToolLevel(toolStack, this.requiredTool) > this.requiredToolLevel) {
                fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)toolStack);
            }
        } else {
            ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (tool != null) {
                fortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)((ItemStack)context.func_216031_c(LootParameters.field_216289_i)));
            }
        }
        return context.func_216032_b().nextFloat() < this.chance + (float)fortuneLevel * this.fortuneMultiplier;
    }

    public LootConditionType func_230419_b_() {
        return type;
    }

    public static class Serializer
    implements ILootSerializer<FortuneBonusCondition> {
        public void serialize(JsonObject json, FortuneBonusCondition value, JsonSerializationContext context) {
            DataManager.gson.toJsonTree((Object)value).getAsJsonObject().entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        }

        public FortuneBonusCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return (FortuneBonusCondition)DataManager.gson.fromJson((JsonElement)json, FortuneBonusCondition.class);
        }
    }
}

