/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiItem;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringOutline;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.OverlayGuiQuickslotSide;

public class OverlayGuiQuickslot
extends GuiElement {
    public static final int height = 20;
    private ItemStack itemStack;
    private int slot;
    private KeyframeAnimation showAnimation;
    private KeyframeAnimation showLabel;
    private KeyframeAnimation hideLabel;
    private GuiItem guiItem;
    private GuiString label;
    private OverlayGuiQuickslotSide hitLeft;
    private OverlayGuiQuickslotSide hitRight;

    public OverlayGuiQuickslot(int x, int y, ItemStack itemStack, int slot) {
        super(x, y, 200, 20);
        this.itemStack = itemStack;
        this.slot = slot;
        this.guiItem = new GuiItem(38, 1);
        this.guiItem.setOpacity(0.0f);
        this.guiItem.setOpacityThreshold(0.2f);
        this.guiItem.setItem(itemStack);
        this.addChild((GuiElement)this.guiItem);
        this.label = new GuiStringOutline(61, 6, itemStack.func_200301_q().getString());
        this.label.setColor(0xFFFFCC);
        this.label.setOpacity(0.0f);
        this.addChild((GuiElement)this.label);
        this.hitLeft = new OverlayGuiQuickslotSide(0, 0, 46, 20, false);
        this.addChild(this.hitLeft);
        this.hitRight = new OverlayGuiQuickslotSide(46, 0, 151, 20, true);
        this.addChild(this.hitRight);
        this.isVisible = false;
        this.showAnimation = new KeyframeAnimation(80, (GuiElement)this.guiItem).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateY(0.0f, 1.0f)}).withDelay(slot * 80);
        this.showLabel = new KeyframeAnimation(100, (GuiElement)this.label).applyTo(new Applier[]{new Applier.TranslateX((float)(this.label.getX() + 1)), new Applier.Opacity(1.0f)});
        this.hideLabel = new KeyframeAnimation(200, (GuiElement)this.label).applyTo(new Applier[]{new Applier.TranslateX((float)this.label.getX()), new Applier.Opacity(0.0f)});
    }

    protected void onShow() {
        this.showAnimation.start();
    }

    protected boolean onHide() {
        if (this.showAnimation.isActive()) {
            this.showAnimation.stop();
        }
        this.opacity = 0.0f;
        return true;
    }

    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
    }

    protected void onFocus() {
        super.onFocus();
        this.hideLabel.stop();
        this.showLabel.start();
        this.hitLeft.animateIn();
        this.hitRight.animateIn();
    }

    protected void onBlur() {
        super.onBlur();
        this.showLabel.stop();
        this.hideLabel.start();
        this.hitLeft.animateOut();
        this.hitRight.animateOut();
    }

    public int getSlot() {
        return this.slot;
    }

    public Hand getHand() {
        return Minecraft.func_71410_x().field_71439_g.func_184591_cq() == HandSide.RIGHT == this.hitRight.hasFocus() ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }
}

