/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.sorting;

import java.util.Comparator;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.StatFormat;
import se.mickelus.tetra.gui.stats.sorting.IStatSorter;

public class BasicStatSorter
implements IStatSorter {
    private IStatGetter getter;
    private String name;
    private String suffix;
    private StatFormat statFormat;
    private boolean inverted;

    public BasicStatSorter(IStatGetter getter, String name, StatFormat statFormat) {
        this.getter = getter;
        this.name = name;
        this.statFormat = statFormat;
    }

    public BasicStatSorter setInverted() {
        this.inverted = true;
        return this;
    }

    public BasicStatSorter setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    @Override
    public String getName() {
        if (this.suffix != null) {
            return I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + " " + I18n.func_135052_a((String)this.suffix, (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    @Override
    public <T> Comparator<T> compare(PlayerEntity player, Function<? super T, ItemStack> keyExtractor) {
        if (this.inverted) {
            return Comparator.comparing(a -> this.getter.getValue(player, (ItemStack)keyExtractor.apply(a)));
        }
        return Comparator.comparing(a -> -this.getter.getValue(player, (ItemStack)keyExtractor.apply(a)));
    }

    @Override
    @Nullable
    public String getValue(PlayerEntity player, ItemStack itemStack) {
        return this.statFormat.get(this.getter.getValue(player, itemStack));
    }

    @Override
    public int getWeight(PlayerEntity player, ItemStack itemStack) {
        return this.getter.shouldShow(player, itemStack, itemStack) ? 1 : 0;
    }
}

