/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.getter;

import java.util.Optional;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.util.CastOptional;

public class StatGetterAttribute
implements IStatGetter {
    private final Attribute attribute;
    private boolean ignoreBase = false;
    private boolean ignoreBonuses = false;
    private double offset = 0.0;

    public StatGetterAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public StatGetterAttribute(Attribute attribute, boolean ignoreBase) {
        this(attribute);
        this.ignoreBase = ignoreBase;
    }

    public StatGetterAttribute withOffset(double offset) {
        this.offset = offset;
        return this;
    }

    public StatGetterAttribute(Attribute attribute, boolean ignoreBase, boolean ignoreBonuses) {
        this(attribute);
        this.ignoreBase = ignoreBase;
        this.ignoreBonuses = ignoreBonuses;
    }

    @Override
    public boolean shouldShow(PlayerEntity player, ItemStack currentStack, ItemStack previewStack) {
        double baseValue = this.ignoreBase ? 0.0 : Optional.ofNullable(player.func_110148_a(this.attribute)).map(ModifiableAttributeInstance::func_111125_b).orElse(0.0) + this.offset;
        return this.getValue(player, currentStack) != baseValue || this.getValue(player, previewStack) != baseValue;
    }

    @Override
    public double getValue(PlayerEntity player, ItemStack itemStack) {
        double baseValue = this.ignoreBase ? 0.0 : Optional.ofNullable(player.func_110148_a(this.attribute)).map(ModifiableAttributeInstance::func_111125_b).orElse(0.0);
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> this.ignoreBonuses ? item.getModuleAttributes(itemStack) : item.getAttributeModifiers(itemStack)).map(map -> map.get((Object)this.attribute)).map(modifiers -> (AttributeHelper.getAdditionAmount(modifiers) + baseValue) * AttributeHelper.getMultiplyAmount(modifiers)).orElse(baseValue) + this.offset;
    }

    @Override
    public double getValue(PlayerEntity player, ItemStack itemStack, String slot) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, slot)).map(module -> module.getAttributeModifiers(itemStack)).map(map -> map.get((Object)this.attribute)).map(modifiers -> AttributeHelper.getAdditionAmount(modifiers) + (AttributeHelper.getMultiplyAmount(modifiers) - 1.0) * this.getValue(player, itemStack)).orElse(0.0);
    }

    @Override
    public double getValue(PlayerEntity player, ItemStack itemStack, String slot, String improvement) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).flatMap(item -> CastOptional.cast(item.getModuleFromSlot(itemStack, slot), ItemModuleMajor.class)).map(module -> module.getImprovement(itemStack, improvement)).map(improvementData -> improvementData.attributes).map(map -> map.get((Object)this.attribute)).map(modifiers -> AttributeHelper.getAdditionAmount(modifiers) + (AttributeHelper.getMultiplyAmount(modifiers) - 1.0) * this.getValue(player, itemStack)).orElse(0.0);
    }
}

