/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.bar;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.mgui.gui.GuiAlignment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiString;
import se.mickelus.mgui.gui.GuiStringSmall;
import se.mickelus.mgui.gui.impl.GuiHorizontalLayoutGroup;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.gui.stats.bar.GuiBar;
import se.mickelus.tetra.gui.stats.bar.GuiBarSegmented;
import se.mickelus.tetra.gui.stats.bar.GuiBarSplit;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.bar.GuiStatIndicator;
import se.mickelus.tetra.gui.stats.getter.ILabelGetter;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.util.CastOptional;

@OnlyIn(value=Dist.CLIENT)
public class GuiStatBar
extends GuiStatBase {
    protected double min;
    protected double max;
    protected String labelKey;
    protected GuiString labelString;
    protected GuiString valueString;
    protected GuiBar bar;
    protected GuiHorizontalLayoutGroup indicatorGroup;
    protected GuiStatIndicator[] indicators = new GuiStatIndicator[0];
    protected List<String> tooltip;
    protected List<String> extendedTooltip;
    protected GuiAlignment alignment = GuiAlignment.left;
    protected boolean inverted;
    protected IStatGetter statGetter;
    protected ILabelGetter labelGetter;
    protected ITooltipGetter tooltipGetter;

    public GuiStatBar(int x, int y, int barLength, String labelKey, double min, double max, boolean segmented, IStatGetter statGetter, ILabelGetter labelGetter, ITooltipGetter tooltipGetter) {
        this(x, y, barLength, labelKey, min, max, segmented, false, false, statGetter, labelGetter, tooltipGetter);
    }

    public GuiStatBar(int x, int y, int barLength, String labelKey, double min, double max, boolean segmented, boolean split, boolean inverted, IStatGetter statGetter, ILabelGetter labelGetter, ITooltipGetter tooltipGetter) {
        super(x, y, barLength, 12);
        this.min = min;
        this.max = max;
        this.labelKey = labelKey;
        this.labelString = new GuiStringSmall(0, 0, "");
        this.valueString = new GuiStringSmall(0, 0, "");
        this.bar = segmented ? new GuiBarSegmented(0, 0, barLength + 1, min, max, inverted) : (split ? new GuiBarSplit(0, 0, barLength, max, inverted) : new GuiBar(0, 0, barLength, min, max, inverted));
        this.indicatorGroup = new GuiHorizontalLayoutGroup(0, -1, 7, 1);
        this.addChild((GuiElement)this.labelString);
        this.addChild((GuiElement)this.valueString);
        this.addChild(this.bar);
        this.addChild((GuiElement)this.indicatorGroup);
        this.statGetter = statGetter;
        this.labelGetter = labelGetter;
        this.tooltipGetter = tooltipGetter;
        this.inverted = inverted;
    }

    public GuiStatBar setIndicators(GuiStatIndicator ... indicators) {
        this.indicators = indicators;
        return this;
    }

    @Override
    public void setAlignment(GuiAlignment alignment) {
        this.alignment = alignment;
        this.realign();
    }

    protected void realign() {
        this.bar.setAlignment(this.alignment);
        this.labelString.setAttachment(this.alignment.toAttachment());
        this.valueString.setAttachment(this.alignment.toAttachment().flipHorizontal());
        this.indicatorGroup.setAttachment(this.alignment.toAttachment());
        int offset = this.labelString.getWidth() + 2;
        this.indicatorGroup.setX(GuiAlignment.right.equals((Object)this.alignment) ? -offset : offset);
    }

    @Override
    public void update(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        double diffValue;
        double value;
        if (this.labelKey != null) {
            this.labelString.setString(I18n.func_135052_a((String)this.labelKey, (Object[])new Object[0]));
        }
        this.labelString.setVisible(this.labelKey != null);
        if (!previewStack.func_190926_b()) {
            value = this.statGetter.getValue(player, currentStack);
            diffValue = this.statGetter.getValue(player, previewStack);
            this.tooltip = Collections.singletonList(this.getCombinedTooltip(player, previewStack));
            this.extendedTooltip = Collections.singletonList(this.getCombinedTooltipExtended(player, previewStack));
        } else {
            value = this.statGetter.getValue(player, currentStack);
            if (slot != null) {
                diffValue = value;
                value -= this.getSlotValue(player, currentStack, slot, improvement);
            } else {
                diffValue = value;
            }
            this.tooltip = Collections.singletonList(this.getCombinedTooltip(player, currentStack));
            this.extendedTooltip = Collections.singletonList(this.getCombinedTooltipExtended(player, currentStack));
        }
        this.updateValue(value, diffValue);
        this.updateIndicators(player, currentStack, previewStack, slot, improvement);
    }

    protected void updateIndicators(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        this.indicatorGroup.clearChildren();
        for (int i = 0; i < this.indicators.length; ++i) {
            if (!this.indicators[i].update(player, currentStack, previewStack, slot, improvement)) continue;
            this.indicatorGroup.addChild((GuiElement)this.indicators[i]);
        }
    }

    @Override
    public boolean shouldShow(PlayerEntity player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        return this.statGetter.shouldShow(player, currentStack, previewStack);
    }

    protected double getSlotValue(PlayerEntity player, ItemStack itemStack, String slot, String improvement) {
        return CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> {
            if (improvement != null) {
                return this.statGetter.getValue(player, itemStack, slot, improvement);
            }
            return this.statGetter.getValue(player, itemStack, slot);
        }).orElse(0.0);
    }

    public void updateValue(double value, double diffValue) {
        this.bar.setValue(value, diffValue);
        this.updateValueLabel(value, diffValue);
    }

    private void updateValueLabel(double value, double diffValue) {
        this.valueString.setString(this.labelGetter.getLabel(value, diffValue, this.alignment == GuiAlignment.right));
    }

    public List<String> getTooltipLines() {
        if (this.hasFocus()) {
            if (Screen.func_231173_s_()) {
                return this.extendedTooltip;
            }
            return this.tooltip;
        }
        return super.getTooltipLines();
    }

    protected List<GuiStatIndicator> getActiveIndicators() {
        return this.indicatorGroup.getChildren(GuiStatIndicator.class);
    }

    protected String getCombinedTooltipBase(PlayerEntity player, ItemStack itemStack) {
        String tooltip = this.tooltipGetter.getTooltipBase(player, itemStack);
        tooltip = tooltip + this.getActiveIndicators().stream().filter(indicator -> indicator.isActive(player, itemStack)).map(indicator -> TextFormatting.YELLOW + indicator.getLabel() + "\n" + TextFormatting.GRAY + indicator.getTooltipBase(player, itemStack)).map(string -> "\n \n" + string).collect(Collectors.joining()).replace(TextFormatting.RESET.toString(), TextFormatting.GRAY.toString());
        return tooltip;
    }

    protected String getCombinedTooltip(PlayerEntity player, ItemStack itemStack) {
        String tooltip = this.getCombinedTooltipBase(player, itemStack);
        if (this.tooltipGetter.hasExtendedTooltip(player, itemStack) || this.getActiveIndicators().stream().anyMatch(ind -> ind.hasExtendedTooltip(player, itemStack))) {
            tooltip = tooltip + "\n \n" + Tooltips.expand.getString();
        }
        return tooltip;
    }

    protected String getCombinedTooltipExtended(PlayerEntity player, ItemStack itemStack) {
        String tooltip = this.getCombinedTooltipBase(player, itemStack);
        if (this.tooltipGetter.hasExtendedTooltip(player, itemStack) || this.getActiveIndicators().stream().anyMatch(ind -> ind.hasExtendedTooltip(player, itemStack))) {
            tooltip = tooltip + "\n \n" + Tooltips.expanded.getString() + "\n";
            LinkedList<String> extendedTooltip = new LinkedList<String>();
            if (this.tooltipGetter.hasExtendedTooltip(player, itemStack)) {
                extendedTooltip.add(TextFormatting.GRAY + this.tooltipGetter.getTooltipExtension(player, itemStack).replace(TextFormatting.RESET.toString(), TextFormatting.GRAY.toString()));
            }
            this.getActiveIndicators().stream().filter(indicator -> indicator.hasExtendedTooltip(player, itemStack)).map(indicator -> TextFormatting.GRAY + indicator.getTooltipExtension(player, itemStack)).map(string -> string.replace(TextFormatting.RESET.toString(), TextFormatting.GRAY.toString())).map(string -> "\n" + string).forEach(extendedTooltip::add);
            tooltip = tooltip + String.join((CharSequence)"\n \n", extendedTooltip);
        }
        return tooltip;
    }
}

