/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.generation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.generation.FeatureParameters;
import se.mickelus.tetra.generation.processing.ForgedContainerProcessor;
import se.mickelus.tetra.generation.processing.ForgedCrateProcessor;
import se.mickelus.tetra.generation.processing.ForgedHammerProcessor;
import se.mickelus.tetra.generation.processing.TransferUnitProcessor;
import se.mickelus.tetra.util.ItemHandlerWrapper;
import se.mickelus.tetra.util.RotationHelper;

public class FeatureEntry
extends Feature<NoFeatureConfig> {
    public static final String key = "feature";
    public static FeatureEntry instance = new FeatureEntry();
    public static ConfiguredFeature<?, ?> configuredInstance = instance.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
    private TemplateManager templateManager;
    private Registry<Biome> biomeRegistry;
    private List<FeatureParameters> entryPoints = Collections.emptyList();

    public FeatureEntry() {
        super(NoFeatureConfig.field_236558_a_);
        this.setRegistryName("tetra", key);
        if (((Boolean)ConfigHandler.generateFeatures.get()).booleanValue()) {
            DataManager.featureData.onReload(this::setupEntryPoints);
        }
    }

    private void setupEntryPoints() {
        this.entryPoints = DataManager.featureData.getData().values().stream().filter(params -> params.biomes.length > 0).collect(Collectors.toList());
    }

    public void setup(MinecraftServer server) {
        this.templateManager = server.func_240792_aT_();
        this.biomeRegistry = server.func_244267_aX().func_243612_b(Registry.field_239720_u_);
    }

    public void registerFeatures(BiomeLoadingEvent event) {
        event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, configuredInstance);
    }

    private void addToBiomes() {
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig ref) {
        Biome biome = world.func_226691_t_(pos);
        ResourceLocation dimensionType = world.func_201672_e().func_234923_W_().func_240901_a_();
        for (FeatureParameters params : this.entryPoints) {
            if (!Arrays.asList(params.dimensions).contains(dimensionType) || !Arrays.stream(params.biomes).anyMatch(biomeName -> biomeName.equalsIgnoreCase(biome.func_201856_r().func_222352_a())) || !(rand.nextFloat() < params.probability)) continue;
            this.generateFeatureRoot(params, world, pos.func_177981_b(params.minY + rand.nextInt(params.maxY - params.minY)), rand);
            return true;
        }
        return false;
    }

    public void generateFeatureRoot(FeatureParameters feature, ISeedReader world, BlockPos pos, Random random) {
        Rotation rotation = Rotation.NONE;
        Mirror mirror = Mirror.NONE;
        if (feature.transform) {
            rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        }
        this.generateFeature(feature, world, pos, rotation, mirror, random, 0);
    }

    private void generateFeature(FeatureParameters feature, ISeedReader world, BlockPos pos, Rotation rotation, Mirror mirror, Random random, int depth) {
        Template template = this.templateManager.func_200219_b(feature.location);
        if (template != null) {
            PlacementSettings settings = new PlacementSettings();
            settings.func_186220_a(rotation);
            if (depth == 0) {
                pos = template.func_189961_a(pos, mirror, rotation);
            }
            if (feature.integrityMin < 1.0f) {
                settings.func_215222_a((StructureProcessor)new IntegrityProcessor(random.nextFloat() * (feature.integrityMax - feature.integrityMin) + feature.integrityMin));
            }
            settings.func_215222_a((StructureProcessor)new ForgedContainerProcessor());
            settings.func_215222_a((StructureProcessor)new ForgedCrateProcessor());
            settings.func_215222_a((StructureProcessor)new ForgedHammerProcessor());
            settings.func_215222_a((StructureProcessor)new TransferUnitProcessor());
            boolean blocksAdded = template.func_237146_a_((IServerWorld)world, pos, pos, settings, random, 2);
            if (blocksAdded) {
                this.generateLoot(feature, world, pos, settings, random);
            }
            if (depth < (Integer)ConfigHandler.maxFeatureDepth.get()) {
                this.generateChildren(feature, world, pos, rotation, mirror, random, depth);
            }
        }
    }

    private void generateChildren(FeatureParameters feature, ISeedReader world, BlockPos pos, Rotation rotation, Mirror mirror, Random random, int depth) {
        Arrays.stream(feature.children).filter(child -> child.chance == 1.0f || random.nextFloat() < child.chance).forEach(child -> {
            ResourceLocation selectedLocation = child.features[random.nextInt(child.features.length)];
            FeatureParameters selectedFeature = DataManager.featureData.getData(selectedLocation);
            if (selectedFeature != null) {
                Rotation childRotation = rotation.func_185830_a(RotationHelper.rotationFromFacing(child.facing));
                PlacementSettings offsetPlacement = new PlacementSettings().func_186214_a(mirror).func_186220_a(rotation);
                PlacementSettings originPlacement = new PlacementSettings().func_186214_a(mirror).func_186220_a(childRotation);
                BlockPos childPos = Template.func_186266_a((PlacementSettings)offsetPlacement, (BlockPos)child.offset).func_177973_b((Vector3i)Template.func_186266_a((PlacementSettings)originPlacement, (BlockPos)selectedFeature.origin)).func_177971_a((Vector3i)pos);
                this.generateFeature(selectedFeature, world, childPos, childRotation, mirror, random, depth + 1);
            }
        });
    }

    private BlockPos adjustRootPosition(Template template, BlockPos blockPos, Rotation rotation) {
        BlockPos size = template.func_186259_a();
        size = size.func_190942_a(rotation);
        BlockPos offset = new BlockPos(16 - Math.abs(size.func_177958_n()) / 2, 0, 16 - Math.abs(size.func_177952_p()) / 2);
        return blockPos.func_177971_a((Vector3i)offset);
    }

    private void generateLoot(FeatureParameters feature, ISeedReader world, BlockPos pos, PlacementSettings settings, Random random) {
        Arrays.stream(feature.loot).forEach(loot -> this.addLoot(loot.table, world, Template.func_186266_a((PlacementSettings)settings, (BlockPos)loot.position).func_177971_a((Vector3i)pos), random));
    }

    private void addLoot(ResourceLocation lootLocation, ISeedReader world, BlockPos pos, Random random) {
        ServerWorld serverWorld;
        TileEntity tileEntity = world.func_175625_s(pos);
        ServerWorld serverWorld2 = serverWorld = world instanceof WorldGenRegion ? world.func_201672_e() : (ServerWorld)world;
        if (tileEntity instanceof LockableLootTileEntity) {
            ((LockableLootTileEntity)tileEntity).func_189404_a(lootLocation, random.nextLong());
        } else if (tileEntity instanceof IInventory) {
            LootTable lootTable = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(lootLocation);
            LootContext.Builder builder = new LootContext.Builder(serverWorld);
            lootTable.func_216118_a((IInventory)tileEntity, builder.func_216022_a(LootParameterSets.field_216260_a));
        } else if (tileEntity != null) {
            tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                LootTable lootTable = serverWorld.func_73046_m().func_200249_aQ().func_186521_a(lootLocation);
                LootContext.Builder builder = new LootContext.Builder(serverWorld);
                lootTable.func_216118_a((IInventory)new ItemHandlerWrapper((IItemHandler)handler), builder.func_216022_a(LootParameterSets.field_216260_a));
            });
        }
    }
}

