/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.howling;

import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.gui.GuiTextures;

public class HowlingIndicatorGui
extends GuiTexture {
    private final KeyframeAnimation animation;
    private int originX;
    private int originY;

    public HowlingIndicatorGui(int x, int y, int width, int height, int textureX, int textureY, int transitionOffset, boolean horizontalTransition) {
        super(x, y, width, height, textureX, textureY, GuiTextures.hud);
        this.setOpacity(0.0f);
        if (horizontalTransition) {
            this.animation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.5f), new Applier.TranslateX((float)x)});
            this.originX = x + transitionOffset;
            this.originY = y;
            this.setX(x + transitionOffset);
        } else {
            this.animation = new KeyframeAnimation(60, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.5f), new Applier.TranslateY((float)y)});
            this.originX = x;
            this.originY = y + transitionOffset;
            this.setY(y + transitionOffset);
        }
    }

    public void show() {
        if (!this.animation.isActive() && (double)this.getOpacity() < 0.5) {
            this.animation.start();
        }
    }

    public void reset() {
        this.animation.stop();
        this.setOpacity(0.0f);
        this.setX(this.originX);
        this.setY(this.originY);
    }
}

