/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.howling;

import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.howling.HowlingPacket;
import se.mickelus.tetra.effect.howling.HowlingPotionEffect;
import se.mickelus.tetra.util.CastOptional;

public class HowlingEffect {
    public static void sendPacket() {
        TetraMod.packetHandler.sendToServer(new HowlingPacket());
    }

    public static void trigger(ItemStack itemStack, LivingEntity player, int effectLevel) {
        int duration = (int)Math.round(EffectHelper.getEffectEfficiency(itemStack, ItemEffect.howling) * 20.0);
        int currentAmplifier = Optional.ofNullable(player.func_70660_b((Effect)HowlingPotionEffect.instance)).map(EffectInstance::func_76458_c).orElse(-1);
        player.func_195064_c(new EffectInstance((Effect)HowlingPotionEffect.instance, duration, Math.min(currentAmplifier + effectLevel, 11), false, false));
    }

    public static void deflectProjectile(ProjectileImpactEvent event, ProjectileEntity projectile, RayTraceResult rayTraceResult) {
        Optional.ofNullable(rayTraceResult).filter(result -> result.func_216346_c() == RayTraceResult.Type.ENTITY).map(result -> (EntityRayTraceResult)result).map(EntityRayTraceResult::func_216348_a).flatMap(entity -> CastOptional.cast(entity, LivingEntity.class)).filter(entity -> HowlingEffect.willDeflect(entity.func_70660_b((Effect)HowlingPotionEffect.instance), entity.func_70681_au())).ifPresent(entity -> {
            Vector3d newDir;
            if ((double)entity.func_70660_b((Effect)HowlingPotionEffect.instance).func_76458_c() * 0.02 < entity.func_70681_au().nextDouble()) {
                Vector3d normal = entity.func_213303_ch().func_72441_c(0.0, (double)(entity.func_213302_cg() / 2.0f), 0.0).func_178788_d(projectile.func_213303_ch()).func_72432_b();
                newDir = projectile.func_213322_ci().func_178788_d(normal.func_186678_a(2.0 * projectile.func_213322_ci().func_72430_b(normal)));
            } else {
                newDir = projectile.func_213322_ci().func_186678_a(-0.8);
                CastOptional.cast(projectile.func_234616_v_(), LivingEntity.class).ifPresent(shooter -> shooter.func_130011_c((Entity)entity));
                projectile.func_212361_a((Entity)entity);
            }
            projectile.func_70186_c(newDir.field_72450_a, newDir.field_72448_b, newDir.field_72449_c, (float)projectile.func_213322_ci().func_72433_c(), 0.1f);
            event.setCanceled(true);
        });
    }

    private static boolean willDeflect(EffectInstance effectInstance, Random random) {
        return effectInstance != null && random.nextDouble() < (double)effectInstance.func_76458_c() * 0.125;
    }
}

