/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.effect.ComboPoints;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.LungeEchoPacket;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.revenge.RevengeTracker;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.CastOptional;

public class LungeEffect
extends ChargedAbilityEffect {
    private static Cache<Integer, LungeData> activeCache = CacheBuilder.newBuilder().maximumSize(20L).expireAfterWrite(30L, TimeUnit.SECONDS).build();
    public static final LungeEffect instance = new LungeEffect();

    LungeEffect() {
        super(5, 0.5, 60, 6.5, ItemEffect.lunge, ChargedAbilityEffect.TargetRequirement.none, UseAction.SPEAR, "raised");
    }

    @Override
    public int getChargeTime(PlayerEntity attacker, ItemModularHandheld item, ItemStack itemStack) {
        if (ComboPoints.canSpend(item, itemStack)) {
            return (int)((double)super.getChargeTime(attacker, item, itemStack) * (1.0 - (double)item.getEffectLevel(itemStack, ItemEffect.abilityCombo) / 100.0 * (double)ComboPoints.get((Entity)attacker)));
        }
        return super.getChargeTime(attacker, item, itemStack);
    }

    @Override
    public void perform(PlayerEntity attacker, Hand hand, ItemModularHandheld item, ItemStack itemStack, @Nullable LivingEntity target, @Nullable BlockPos targetPos, @Nullable Vector3d hitVec, int chargedTicks) {
        if (attacker.func_233570_aj_()) {
            int echoLevel;
            int exhilarateLevel;
            int overextendLevel;
            int momentumLevel;
            double comboEfficiency;
            float damageMultiplierOffset = 0.0f;
            float strength = 1.0f + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)itemStack) * 0.5f;
            Vector3d lookVector = attacker.func_70040_Z();
            double verticalVelocityFactor = 0.8;
            float hitCooldown = 0.7f;
            float exhaustDuration = 0.0f;
            double echoStrength = 0.0;
            if (this.canOvercharge(item, itemStack)) {
                int overcharge = this.getOverchargeBonus(item, itemStack, chargedTicks);
                strength += (float)(overcharge * item.getEffectLevel(itemStack, ItemEffect.abilityOvercharge)) / 100.0f;
                damageMultiplierOffset = (float)((double)damageMultiplierOffset + item.getEffectEfficiency(itemStack, ItemEffect.abilityOvercharge) / 100.0);
            }
            if ((comboEfficiency = item.getEffectEfficiency(itemStack, ItemEffect.abilityCombo)) > 0.0) {
                hitCooldown = (float)((double)hitCooldown - comboEfficiency * (double)ComboPoints.get((Entity)attacker) / 100.0);
            }
            if ((momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum)) > 0) {
                verticalVelocityFactor = 1.2;
            }
            if ((overextendLevel = item.getEffectLevel(itemStack, ItemEffect.abilityOverextend)) > 0 && !attacker.func_71024_bL().func_75121_c()) {
                damageMultiplierOffset = (float)((double)damageMultiplierOffset + (double)overextendLevel / 100.0);
                strength = (float)((double)strength + item.getEffectEfficiency(itemStack, ItemEffect.abilityOverextend));
                verticalVelocityFactor += 0.1;
            }
            if ((exhilarateLevel = item.getEffectLevel(itemStack, ItemEffect.abilityExhilaration)) > 0) {
                damageMultiplierOffset += (float)exhilarateLevel / 100.0f;
                strength = (float)((double)strength + item.getEffectEfficiency(itemStack, ItemEffect.abilityExhilaration));
                exhaustDuration += 15.0f;
            }
            if ((echoLevel = item.getEffectLevel(itemStack, ItemEffect.abilityEcho)) > 0) {
                echoStrength = item.getEffectEfficiency(itemStack, ItemEffect.abilityEcho);
            }
            if (this.isDefensive(item, itemStack, hand)) {
                lookVector = lookVector.func_216372_d(-1.2, 0.0, -1.2).func_72441_c(0.0, 0.4, 0.0);
            } else {
                activeCache.put((Object)LungeEffect.getIdentifier(attacker), (Object)new LungeData(itemStack, damageMultiplierOffset, hitCooldown, exhaustDuration, echoLevel, echoStrength));
            }
            attacker.func_213317_d(lookVector.func_186678_a(attacker.func_213322_ci().func_72430_b(lookVector) / lookVector.func_72430_b(lookVector)));
            attacker.func_70024_g(lookVector.field_72450_a * (double)strength, MathHelper.func_151237_a((double)(lookVector.field_72448_b * (double)strength * verticalVelocityFactor + 0.3), (double)0.3, (double)verticalVelocityFactor), lookVector.field_72449_c * (double)strength);
            attacker.field_70133_I = true;
            attacker.func_213315_a(MoverType.SELF, new Vector3d(0.0, 0.4, 0.0));
            attacker.func_71020_j(overextendLevel > 0 ? 6.0f : 1.0f);
            attacker.func_184811_cZ().func_185145_a((Item)item, this.getCooldown(item, itemStack));
            attacker.func_130014_f_().func_184133_a(attacker, new BlockPos(attacker.func_213303_ch().func_178787_e(attacker.func_213322_ci())), SoundEvents.field_194226_id, SoundCategory.PLAYERS, 1.0f, 1.3f);
        }
        if (ComboPoints.canSpend(item, itemStack)) {
            ComboPoints.reset((Entity)attacker);
        }
    }

    public static void onPlayerTick(PlayerEntity player) {
        LungeData data = (LungeData)activeCache.getIfPresent((Object)LungeEffect.getIdentifier(player));
        if (data != null && !player.func_184218_aH()) {
            if (!player.func_233570_aj_()) {
                AxisAlignedBB axisalignedbb = player.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2).func_191194_a(player.func_213322_ci());
                player.field_70170_p.func_217357_a(LivingEntity.class, axisalignedbb).stream().filter(Entity::func_70089_S).filter(Entity::func_70067_L).filter(Entity::func_70075_an).filter(entity -> !player.equals(entity)).findAny().ifPresent(entity -> LungeEffect.onEntityImpact(player, entity, data));
            } else {
                activeCache.invalidate((Object)LungeEffect.getIdentifier(player));
                if (data.exhaustDuration > 0.0f) {
                    player.func_195064_c(new EffectInstance((Effect)ExhaustedPotionEffect.instance, (int)(data.exhaustDuration * 20.0f), 4, false, true));
                }
            }
        }
    }

    private static void onEntityImpact(PlayerEntity player, LivingEntity target, LungeData data) {
        ItemStack itemStack = data.itemStack;
        ItemModularHandheld item = CastOptional.cast(itemStack.func_77973_b(), ItemModularHandheld.class).orElse(null);
        Vector3d bounceVector = player.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_186678_a((double)0.1f);
        player.func_213317_d(bounceVector);
        player.field_70133_I = true;
        float cooldownMultiplier = data.hitCooldown;
        int momentumLevel = item.getEffectLevel(itemStack, ItemEffect.abilityMomentum);
        if (RevengeTracker.canRevenge((LivingEntity)player) && RevengeTracker.canRevenge((Entity)player, (Entity)target)) {
            cooldownMultiplier = 0.0f;
            RevengeTracker.removeEnemy((Entity)player, (Entity)target);
        }
        if (!player.field_70170_p.field_72995_K) {
            int lungeLevel;
            AbilityUseResult result;
            double bonusDamage = 0.0;
            if (momentumLevel > 0) {
                bonusDamage = Math.min((float)momentumLevel, player.field_70143_R);
            }
            if ((result = item.hitEntity(itemStack, player, target, data.damageMultiplierOffset + (float)(lungeLevel = item.getEffectLevel(itemStack, ItemEffect.lunge)) / 100.0f, bonusDamage, 0.5f, 0.5f)) != AbilityUseResult.fail && momentumLevel > 0) {
                int duration = 10 + (int)((double)Math.min((float)momentumLevel, player.field_70143_R) * item.getEffectEfficiency(itemStack, ItemEffect.abilityMomentum) * 20.0);
                target.func_195064_c(new EffectInstance((Effect)StunPotionEffect.instance, duration, 0, false, false));
                LungeEffect.spawnMomentumParticles(target, bonusDamage);
            }
            target.func_130014_f_().func_184133_a(null, target.func_233580_cy_(), SoundEvents.field_187721_dT, SoundCategory.PLAYERS, 1.0f, 0.8f);
            player.func_226292_a_(Hand.MAIN_HAND, true);
        }
        if (momentumLevel > 0) {
            player.field_70143_R = Math.max(0.0f, player.field_70143_R - (float)momentumLevel);
        }
        item.tickProgression((LivingEntity)player, itemStack, 2);
        item.applyDamage(2, itemStack, (LivingEntity)player);
        player.func_184811_cZ().func_185145_a((Item)item, (int)((float)instance.getCooldown(item, itemStack) * cooldownMultiplier));
        activeCache.invalidate((Object)LungeEffect.getIdentifier(player));
    }

    private static void spawnMomentumParticles(LivingEntity target, double bonus) {
        BlockPos pos = new BlockPos(target.func_226277_ct_(), target.func_226278_cu_() - 0.2, target.func_226281_cx_());
        BlockState blockState = target.field_70170_p.func_180495_p(pos);
        if (!blockState.isAir((IBlockReader)target.field_70170_p, pos)) {
            ((ServerWorld)target.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockState), target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (int)(bonus * 8.0) + 20, 0.0, 0.0, 0.0, 0.15);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRightClick(ClientPlayerEntity player) {
        LungeData data = (LungeData)activeCache.getIfPresent((Object)LungeEffect.getIdentifier((PlayerEntity)player));
        if (data != null && data.echoCount > 0) {
            TetraMod.packetHandler.sendToServer(new LungeEchoPacket());
            LungeEffect.echo((PlayerEntity)player, data, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onJump(ClientPlayerEntity player) {
        LungeData data = (LungeData)activeCache.getIfPresent((Object)LungeEffect.getIdentifier((PlayerEntity)player));
        if (data != null && data.echoCount > 0) {
            TetraMod.packetHandler.sendToServer(new LungeEchoPacket(true));
            LungeEffect.echo((PlayerEntity)player, data, true);
        }
    }

    public static void receiveEchoPacket(PlayerEntity player, boolean isVertical) {
        LungeData data = (LungeData)activeCache.getIfPresent((Object)LungeEffect.getIdentifier(player));
        if (data != null && data.echoCount > 0) {
            LungeEffect.echo(player, data, isVertical);
        }
    }

    public static void echo(PlayerEntity entity, LungeData data, boolean isVertical) {
        Vector3d lookVector = entity.func_70040_Z();
        entity.func_213317_d(lookVector.func_186678_a(entity.func_213322_ci().func_72430_b(lookVector) / lookVector.func_72430_b(lookVector)));
        double strength = data.echoStrength;
        if (isVertical) {
            strength *= 0.3;
        }
        entity.func_70024_g(lookVector.field_72450_a * strength, lookVector.field_72448_b * strength, lookVector.field_72449_c * strength);
        if (entity.func_213453_ef()) {
            entity.func_213317_d(entity.func_213322_ci().func_186678_a(-0.8));
        }
        if (isVertical) {
            Vector3d motion = entity.func_213322_ci();
            double vertical = motion.field_72448_b > 0.0 ? motion.field_72448_b + strength * 0.5 : strength * 0.5;
            entity.func_213293_j(motion.field_72450_a, vertical, motion.field_72449_c);
        }
        if (entity.func_213322_ci().field_72448_b > 0.0) {
            entity.field_70143_R = 0.0f;
        }
        entity.field_70133_I = true;
        entity.func_130014_f_().func_184133_a(entity, new BlockPos(entity.func_213303_ch().func_178787_e(entity.func_213322_ci())), SoundEvents.field_194226_id, SoundCategory.PLAYERS, 1.0f, 1.3f);
        if (!entity.field_70170_p.field_72995_K) {
            Random rand = entity.func_70681_au();
            ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197607_R, entity.func_226277_ct_() + (rand.nextGaussian() - 0.5) * 0.5, entity.func_226278_cu_(), entity.func_226281_cx_() + (rand.nextGaussian() - 0.5) * 0.5, 5, (double)rand.nextFloat() * 0.2, -0.2 + (double)rand.nextFloat() * -0.6, (double)rand.nextFloat() * 0.2, 0.0);
        }
        --data.echoCount;
    }

    private static int getIdentifier(PlayerEntity entity) {
        return entity.field_70170_p.field_72995_K ? -entity.func_145782_y() : entity.func_145782_y();
    }

    static class LungeData {
        ItemStack itemStack;
        float damageMultiplierOffset;
        float hitCooldown;
        float exhaustDuration;
        int echoCount;
        double echoStrength;

        public LungeData(ItemStack itemStack, float damageMultiplierOffset, float hitCooldown, float exhaustDuration, int echoCount, double echoStrength) {
            this.itemStack = itemStack;
            this.damageMultiplierOffset = damageMultiplierOffset;
            this.hitCooldown = hitCooldown;
            this.exhaustDuration = exhaustDuration;
            this.echoCount = echoCount;
            this.echoStrength = echoStrength;
        }
    }
}

