/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.tetra.module.data.EnchantmentMapping;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;

public class EnchantmentBuilder {
    private Enchantment enchantment;
    private float destabilizationProbability = 0.04f;
    private int destabilizationInstabilityLimit = 1;
    private boolean apply = true;
    private boolean createImprovements = true;
    private boolean isCurse = false;
    private int bonusLevels = 0;
    private float capacityMultiplier = 1.0f;

    public EnchantmentBuilder(Enchantment enchantment) {
        this.enchantment = enchantment;
        this.isCurse = enchantment.func_190936_d();
        if (this.isCurse) {
            this.destabilizationInstabilityLimit = 20;
        }
        if (enchantment.func_77325_b() == 5) {
            this.bonusLevels = 10;
        } else if (enchantment.func_77325_b() > 1) {
            this.bonusLevels = 5;
        }
    }

    public EnchantmentBuilder setDestabilizationProbability(float probability) {
        this.destabilizationProbability = probability;
        return this;
    }

    public EnchantmentBuilder setDestabilizationInstabilityLimit(int limit) {
        this.destabilizationInstabilityLimit = limit;
        return this;
    }

    public EnchantmentBuilder setApply(boolean apply) {
        this.apply = apply;
        return this;
    }

    public EnchantmentBuilder setCurse(boolean isCurse) {
        this.isCurse = isCurse;
        return this;
    }

    public EnchantmentBuilder setCreateImprovements(boolean createImprovements) {
        this.createImprovements = createImprovements;
        return this;
    }

    public EnchantmentBuilder setBonusLevels(int bonusLevels) {
        this.bonusLevels = bonusLevels;
        return this;
    }

    public EnchantmentBuilder setCapacityMultiplier(float capacityMultiplier) {
        this.capacityMultiplier = capacityMultiplier;
        return this;
    }

    public String getModId() {
        try {
            return this.enchantment.delegate.name().func_110624_b();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getKey() {
        return this.getImprovementKey();
    }

    public EnchantmentType getEnchantmentType() {
        return this.enchantment.field_77351_y;
    }

    public boolean shouldApply() {
        return this.apply;
    }

    public boolean canDestabilize() {
        return this.destabilizationProbability > 0.0f && this.enchantment.func_77325_b() > 1 && !this.isCurse;
    }

    public boolean isDestabilizingCurse() {
        return this.destabilizationProbability > 0.0f && this.isCurse;
    }

    public boolean shouldCreateImprovements() {
        return this.createImprovements;
    }

    private String getImprovementKey() {
        ResourceLocation location = this.enchantment.delegate.name();
        if (location.func_110624_b().equals("minecraft")) {
            return "enchantment/" + location.func_110623_a();
        }
        return "enchantment/" + location.func_110624_b() + "_" + location.func_110623_a();
    }

    private String getDestabilizationKey() {
        ResourceLocation location = this.enchantment.delegate.name();
        if (location.func_110624_b().equals("minecraft")) {
            return "destabilized/" + location.func_110623_a();
        }
        return "destabilized/" + location.func_110624_b() + "_" + location.func_110623_a();
    }

    private EnchantmentMapping getEnchantmentMapping(boolean destabilization) {
        EnchantmentMapping result = new EnchantmentMapping();
        result.enchantment = this.enchantment;
        result.apply = this.apply;
        if (destabilization) {
            result.improvement = this.getDestabilizationKey();
            result.extract = false;
            result.multiplier = -1.0f;
        } else {
            result.improvement = this.getImprovementKey();
        }
        return result;
    }

    private DestabilizationEffect getDestabilizationEffect() {
        if (this.isCurse) {
            DestabilizationEffect result = new DestabilizationEffect();
            result.minLevel = this.enchantment.func_77319_d();
            result.maxLevel = this.enchantment.func_77325_b();
            result.probability = this.destabilizationProbability;
            result.instabilityLimit = this.destabilizationInstabilityLimit;
            result.destabilizationKey = this.getImprovementKey();
            ResourceLocation location = this.enchantment.delegate.name();
            if (!location.func_110624_b().equals("minecraft")) {
                result.requiredMod = location.func_110624_b();
            }
            return result;
        }
        if (this.canDestabilize()) {
            DestabilizationEffect result = new DestabilizationEffect();
            result.minLevel = this.enchantment.func_77319_d();
            result.maxLevel = this.enchantment.func_77325_b() - 1;
            result.probability = this.destabilizationProbability;
            result.instabilityLimit = this.destabilizationInstabilityLimit;
            result.improvementKey = this.getImprovementKey();
            result.destabilizationKey = this.getDestabilizationKey();
            ResourceLocation location = this.enchantment.delegate.name();
            if (!location.func_110624_b().equals("minecraft")) {
                result.requiredMod = location.func_110624_b();
            }
            return result;
        }
        return null;
    }

    public JsonArray getImprovementsJson() {
        JsonObject glyph;
        JsonObject data;
        int i;
        JsonArray result = new JsonArray();
        for (i = this.enchantment.func_77319_d(); i < this.enchantment.func_77325_b() + 1 + this.bonusLevels; ++i) {
            data = new JsonObject();
            data.addProperty("key", this.getImprovementKey());
            data.addProperty("level", (Number)i);
            data.addProperty("enchantment", Boolean.valueOf(true));
            if (this.isCurse) {
                glyph = new JsonObject();
                glyph.addProperty("tint", "ee5599");
                data.add("glyph", (JsonElement)glyph);
            } else {
                data.addProperty("magicCapacity", (Number)Float.valueOf((float)(-(this.enchantment.func_223551_b(i) + this.enchantment.func_77321_a(i)) / 2) * this.capacityMultiplier));
            }
            result.add((JsonElement)data);
        }
        if (this.canDestabilize()) {
            for (i = this.enchantment.func_77319_d(); i < this.enchantment.func_77325_b(); ++i) {
                data = new JsonObject();
                data.addProperty("key", this.getDestabilizationKey());
                data.addProperty("level", (Number)i);
                data.addProperty("enchantment", Boolean.valueOf(true));
                glyph = new JsonObject();
                glyph.addProperty("tint", "ee5599");
                data.add("glyph", (JsonElement)glyph);
                result.add((JsonElement)data);
            }
        }
        return result;
    }

    public Map<String, String> getLocalizationEntries(JsonObject existingLocalizations) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String key = this.enchantment.func_77320_a();
        String name = null;
        if (existingLocalizations.has(key)) {
            name = existingLocalizations.get(key).getAsString();
            if (this.isCurse) {
                result.put("tetra.improvement." + this.getImprovementKey() + ".name", TextFormatting.DARK_PURPLE + name);
            } else {
                result.put("tetra.improvement." + this.getImprovementKey() + ".name", name);
            }
        }
        if (existingLocalizations.has(key + ".desc")) {
            result.put("tetra.improvement." + this.getImprovementKey() + ".description", existingLocalizations.get(key + ".desc").getAsString());
        } else if (existingLocalizations.has(key + ".description")) {
            result.put("tetra.improvement." + this.getImprovementKey() + ".description", existingLocalizations.get(key + ".description").getAsString());
        } else {
            result.put("tetra.improvement." + this.getImprovementKey() + ".description", "");
        }
        if (this.canDestabilize()) {
            if (name != null) {
                result.put("tetra.improvement." + this.getDestabilizationKey() + ".name", TextFormatting.DARK_PURPLE + "Destabilized: " + name);
                result.put("tetra.improvement." + this.getDestabilizationKey() + ".description", "Reduces the effect of the " + name + " enchantment");
            } else {
                result.put("tetra.improvement." + this.getDestabilizationKey() + ".name", "");
                result.put("tetra.improvement." + this.getDestabilizationKey() + ".description", "");
            }
        }
        return result;
    }

    public Collection<String> getLocalizationKeys() {
        LinkedList<String> result = new LinkedList<String>();
        String key = this.enchantment.func_77320_a();
        Object name = null;
        if (this.isCurse) {
            result.add("tetra.improvement." + this.getImprovementKey() + ".name");
        } else {
            result.add("tetra.improvement." + this.getImprovementKey() + ".name");
        }
        result.add("tetra.improvement." + this.getImprovementKey() + ".description");
        if (this.canDestabilize()) {
            result.add("tetra.improvement." + this.getDestabilizationKey() + ".name");
            result.add("tetra.improvement." + this.getDestabilizationKey() + ".description");
        }
        return result;
    }

    public JsonObject getEnchantmentJson() {
        return this.getEnchantmentMapping(false).toJson();
    }

    public JsonObject getEnchantmentDestabilizationJson() {
        return Optional.ofNullable(this.getEnchantmentMapping(true)).map(EnchantmentMapping::toJson).orElse(null);
    }

    public JsonObject getDestabilizationJson() {
        return Optional.ofNullable(this.getDestabilizationEffect()).map(DestabilizationEffect::toJson).orElse(null);
    }
}

