/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.DataStore;

public abstract class MergingDataStore<V, U>
extends DataStore<V> {
    private static final Logger logger = LogManager.getLogger();
    protected Class<U> arrayClass;

    public MergingDataStore(Gson gson, String directory, Class<V> entryClass, Class<U> arrayClass) {
        super(gson, directory, entryClass);
        this.arrayClass = arrayClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<ResourceLocation, JsonElement> prepare(IResourceManager resourceManager, IProfiler profiler) {
        logger.debug("Reading data for {} data store...", (Object)this.directory);
        HashMap map = Maps.newHashMap();
        int i = this.directory.length() + 1;
        for (ResourceLocation fullLocation : resourceManager.func_199003_a(this.directory, rl -> rl.endsWith(".json"))) {
            if (!"tetra".equals(fullLocation.func_110624_b())) continue;
            String path = fullLocation.func_110623_a();
            ResourceLocation location = new ResourceLocation(fullLocation.func_110624_b(), path.substring(i, path.length() - jsonExtLength));
            JsonArray allResources = new JsonArray();
            try {
                for (IResource resource : resourceManager.func_199004_b(fullLocation)) {
                    try {
                        InputStream inputstream = resource.func_199027_b();
                        Throwable throwable = null;
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                            Throwable throwable2 = null;
                            try {
                                JsonObject json = (JsonObject)JSONUtils.func_193839_a((Gson)this.gson, (Reader)reader, JsonObject.class);
                                if (json != null) {
                                    if (this.shouldLoad((JsonElement)json)) {
                                        allResources.add((JsonElement)json);
                                        continue;
                                    }
                                    logger.debug("Skipping data '{}' from '{}' due to condition", (Object)fullLocation, (Object)resource.func_199026_d());
                                    continue;
                                }
                                logger.error("Couldn't load data from '{}' in data pack '{}' as it's empty or null", (Object)fullLocation, (Object)resource.func_199026_d());
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                ((Reader)reader).close();
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (inputstream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputstream.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                continue;
                            }
                            inputstream.close();
                        }
                    }
                    catch (IOException | RuntimeException e) {
                        logger.error("Couldn't load data from '{}' in data pack '{}'", (Object)fullLocation, (Object)resource.func_199026_d(), (Object)e);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException e) {
                logger.error("Couldn't load data from '{}'", (Object)fullLocation, (Object)e);
            }
            if (allResources.size() <= 0) continue;
            map.put(location, allResources);
        }
        return map;
    }

    @Override
    public void loadFromPacket(Map<ResourceLocation, String> data) {
        Map<ResourceLocation, JsonElement> splashList = data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (JsonArray)JSONUtils.func_188178_a((Gson)this.gson, (String)((String)entry.getValue()), JsonArray.class)));
        this.parseData(splashList);
    }

    @Override
    public void parseData(Map<ResourceLocation, JsonElement> splashList) {
        logger.info("Loaded {} {}", (Object)String.format("%3d", splashList.values().size()), (Object)this.directory);
        this.dataMap = splashList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.mergeData(this.gson.fromJson((JsonElement)entry.getValue(), this.arrayClass))));
        this.processData();
        this.listeners.forEach(Runnable::run);
    }

    protected abstract V mergeData(U var1);
}

