/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.data;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.data.DataStore;
import se.mickelus.tetra.module.data.ImprovementData;
import se.mickelus.tetra.module.data.MaterialImprovementData;

public class ImprovementStore
extends DataStore<ImprovementData[]> {
    public ImprovementStore(Gson gson, String directory) {
        super(gson, directory, ImprovementData[].class);
    }

    @Override
    protected void processData() {
        this.dataMap = this.dataMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.processData((ImprovementData[])entry.getValue())));
    }

    private ImprovementData[] processData(ImprovementData[] data) {
        return (ImprovementData[])Arrays.stream(data).flatMap(improvement -> improvement instanceof MaterialImprovementData ? this.expandMaterialImprovement((MaterialImprovementData)improvement) : Stream.of(improvement)).toArray(ImprovementData[]::new);
    }

    private Stream<ImprovementData> expandMaterialImprovement(MaterialImprovementData data) {
        return Arrays.stream(data.materials).map(rl -> rl.func_110623_a().endsWith("/") ? DataManager.materialData.getDataIn((ResourceLocation)rl) : (Collection)Optional.ofNullable(DataManager.materialData.getData((ResourceLocation)rl)).map(Collections::singletonList).orElseGet(Collections::emptyList)).flatMap(Collection::stream).map(data::combine);
    }
}

