/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import se.mickelus.tetra.blocks.scroll.ScrollData;
import se.mickelus.tetra.blocks.scroll.ScrollItem;

public class ScrollIngredient
extends Ingredient {
    private final ItemStack itemStack;
    private final ScrollData data;

    protected ScrollIngredient(ItemStack itemStack, ScrollData data) {
        super(Stream.of(new Ingredient.SingleItemList(itemStack)));
        this.itemStack = itemStack;
        this.data = data;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null || input.func_77973_b() != ScrollItem.instance) {
            return false;
        }
        ScrollData inputData = ScrollData.read(input);
        return this.data.key.equals(inputData.key);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        this.data.write(json);
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<ScrollIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public ScrollIngredient parse(JsonObject json) {
            ScrollData data = ScrollData.read(json);
            ItemStack itemStack = new ItemStack((IItemProvider)ScrollItem.instance);
            data.write(itemStack);
            return new ScrollIngredient(itemStack, data);
        }

        public ScrollIngredient parse(PacketBuffer buffer) {
            ItemStack itemStack = buffer.func_150791_c();
            return new ScrollIngredient(itemStack, ScrollData.read(itemStack));
        }

        public void write(PacketBuffer buffer, ScrollIngredient ingredient) {
            buffer.func_150788_a(ingredient.itemStack);
        }
    }
}

