/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.model;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.resources.IResourceManager;
import net.minecraftforge.client.model.IModelLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.client.model.ModularItemModel;
import se.mickelus.tetra.data.DataManager;

public class ModularModelLoader
implements IModelLoader<ModularItemModel> {
    private static final Logger logger = LogManager.getLogger();
    private static List<ModularItemModel> newModels = new LinkedList<ModularItemModel>();
    private static List<ModularItemModel> models = new LinkedList<ModularItemModel>();

    public ModularModelLoader() {
        DataManager.moduleData.onReload(ModularModelLoader::clearCaches);
    }

    private static void shuffle() {
        if (!newModels.isEmpty()) {
            models = newModels;
            newModels = new LinkedList<ModularItemModel>();
        }
    }

    public static void clearCaches() {
        ModularModelLoader.shuffle();
        logger.info("Clearing model cache for {} items, let's get bakin'", (Object)models.size());
        models.forEach(ModularItemModel::clearCache);
    }

    public void func_195410_a(IResourceManager resourceManager) {
        logger.info("Reloading item models, old: {}, new: {}", (Object)models.size(), (Object)newModels.size());
        ModularModelLoader.shuffle();
    }

    public ModularItemModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        ItemCameraTransforms cameraTransforms = (ItemCameraTransforms)deserializationContext.deserialize(modelContents.get("display"), ItemCameraTransforms.class);
        if (modelContents.has("variants")) {
            Map transformVariants = (Map)deserializationContext.deserialize(modelContents.get("variants"), new TypeToken<Map<String, ItemCameraTransforms>>(){}.getType());
            ModularItemModel model = new ModularItemModel(cameraTransforms, transformVariants);
            newModels.add(model);
            return model;
        }
        ModularItemModel model = new ModularItemModel(cameraTransforms);
        newModels.add(model);
        return model;
    }
}

