/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiButton;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.AnimationChain;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.blocks.workbench.gui.GuiModuleDetails;
import se.mickelus.tetra.blocks.workbench.gui.GuiSchematicDetail;
import se.mickelus.tetra.blocks.workbench.gui.GuiSchematicList;
import se.mickelus.tetra.blocks.workbench.gui.GuiTweakControls;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.VerticalTabGroupGui;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;
import se.mickelus.tetra.properties.PropertyHelper;
import se.mickelus.tetra.util.CastOptional;

public class GuiSlotDetail
extends GuiElement {
    private static final char[] keybindings = new char[]{'a', 's', 'd'};
    private static final String[] labels = new String[]{"tetra.workbench.slot_detail.details_tab", "tetra.workbench.slot_detail.craft_tab", "tetra.workbench.slot_detail.tweak_tab"};
    private int tab = 1;
    private VerticalTabGroupGui tabGroup;
    private GuiModuleDetails moduleDetails;
    private GuiElement schematicGroup;
    private GuiSchematicList schematicList;
    private GuiSchematicDetail schematicDetail;
    private GuiTweakControls tweakControls;
    private Consumer<UpgradeSchematic> selectSchematicHandler;
    private final AnimationChain slotTransition;

    public GuiSlotDetail(int x, int y, Consumer<UpgradeSchematic> selectSchematicHandler, Runnable closeHandler, Runnable craftHandler, Consumer<Map<String, Integer>> previewTweak, Consumer<Map<String, Integer>> applyTweak) {
        super(x, y, 224, 67);
        this.selectSchematicHandler = selectSchematicHandler;
        this.addChild((GuiElement)new GuiTexture(0, 0, this.width, this.height, 0, 68, GuiTextures.workbench));
        this.addChild((GuiElement)new GuiRect(1, 6, 2, 49, 0));
        this.tabGroup = new VerticalTabGroupGui(1, 6, this::changeTab, GuiTextures.workbench, 128, 32, (String[])IntStream.range(0, 3).mapToObj(i -> I18n.func_135052_a((String)labels[i], (Object[])new Object[0])).toArray(String[]::new));
        this.tabGroup.setHasContent(1, true);
        this.addChild(this.tabGroup);
        this.moduleDetails = new GuiModuleDetails(0, 0);
        this.addChild(this.moduleDetails);
        this.schematicGroup = new GuiElement(0, 0, this.width, this.height);
        this.addChild(this.schematicGroup);
        this.schematicList = new GuiSchematicList(0, 0, selectSchematicHandler);
        this.schematicList.setVisible(false);
        this.schematicGroup.addChild((GuiElement)this.schematicList);
        this.schematicDetail = new GuiSchematicDetail(0, 0, () -> selectSchematicHandler.accept(null), craftHandler);
        this.schematicDetail.setVisible(false);
        this.schematicGroup.addChild((GuiElement)this.schematicDetail);
        this.tweakControls = new GuiTweakControls(0, 0, previewTweak, applyTweak);
        this.addChild(this.tweakControls);
        GuiRect slotTransitionElement = new GuiRect(3, 3, 218, 56, 0);
        slotTransitionElement.setOpacity(0.0f);
        this.addChild((GuiElement)slotTransitionElement);
        this.slotTransition = new AnimationChain(new KeyframeAnimation[]{new KeyframeAnimation(60, (GuiElement)slotTransitionElement).applyTo(new Applier[]{new Applier.Opacity(0.3f)}), new KeyframeAnimation(100, (GuiElement)slotTransitionElement).applyTo(new Applier[]{new Applier.Opacity(0.0f)})});
        GuiButton buttonClose = new GuiButton(215, -4, "x", closeHandler);
        this.addChild((GuiElement)buttonClose);
        this.setVisible(false);
    }

    private void changeTab(int index) {
        this.selectSchematicHandler.accept(null);
        this.tab = index;
        this.updateTabVisibility();
        this.slotTransition.stop();
        this.slotTransition.start();
    }

    private void updateTabVisibility() {
        this.moduleDetails.setVisible(this.tab == 0);
        this.schematicGroup.setVisible(this.tab == 1);
        this.tweakControls.setVisible(this.tab == 2);
    }

    public void onTileEntityChange(PlayerEntity player, WorkbenchTile tileEntity, ItemStack itemStack, String selectedSlot, UpgradeSchematic currentSchematic) {
        ItemModule module = CastOptional.cast(itemStack.func_77973_b(), IModularItem.class).map(item -> item.getModuleFromSlot(itemStack, selectedSlot)).orElse(null);
        if (currentSchematic == null) {
            this.updateSchematicList(player, tileEntity, selectedSlot);
        } else {
            World world = tileEntity.func_145831_w();
            BlockPos pos = tileEntity.func_174877_v();
            Map<ToolType, Integer> availableTools = PropertyHelper.getCombinedToolLevels(player, world, pos, world.func_180495_p(pos));
            ItemStack[] materials = tileEntity.getMaterials();
            ItemStack previewStack = currentSchematic.applyUpgrade(itemStack.func_77946_l(), materials, false, selectedSlot, player);
            this.schematicDetail.update(currentSchematic, itemStack, selectedSlot, materials, availableTools, player);
            this.schematicDetail.updateMagicCapacity(currentSchematic, selectedSlot, itemStack, previewStack);
            this.schematicDetail.updateButton(currentSchematic, player, itemStack, previewStack, materials, selectedSlot, availableTools);
            this.tab = 1;
        }
        this.moduleDetails.update(module, itemStack);
        this.tabGroup.setHasContent(0, module != null);
        this.tweakControls.update(module, itemStack);
        this.tabGroup.setHasContent(2, module != null && module.isTweakable(itemStack));
        this.schematicDetail.setVisible(currentSchematic != null);
        this.schematicList.setVisible(currentSchematic == null);
        this.updateTabVisibility();
        this.tabGroup.setActive(this.tab);
    }

    public void update(PlayerEntity player, WorkbenchTile tileEntity, Map<ToolType, Integer> availableTools) {
        this.schematicDetail.updateAvailableTools(availableTools);
        ItemStack currentStack = tileEntity.getTargetItemStack().func_77946_l();
        UpgradeSchematic currentSchematic = tileEntity.getCurrentSchematic();
        ItemStack previewStack = currentSchematic.applyUpgrade(currentStack, tileEntity.getMaterials(), false, tileEntity.getCurrentSlot(), player);
        this.schematicDetail.updateButton(tileEntity.getCurrentSchematic(), player, currentStack, previewStack, tileEntity.getMaterials(), tileEntity.getCurrentSlot(), availableTools);
    }

    public void updatePreview(UpgradeSchematic schematic, String slot, ItemStack itemStack, ItemStack previewStack) {
        this.schematicDetail.updateMagicCapacity(schematic, slot, itemStack, previewStack);
    }

    private void updateSchematicList(PlayerEntity player, WorkbenchTile tileEntity, String selectedSlot) {
        ItemStack targetStack = tileEntity.getTargetItemStack();
        UpgradeSchematic[] schematics = SchematicRegistry.getAvailableSchematics(player, tileEntity, targetStack);
        schematics = (UpgradeSchematic[])Arrays.stream(schematics).filter(upgradeSchematic -> upgradeSchematic.isApplicableForSlot(selectedSlot, targetStack)).sorted(Comparator.comparing(UpgradeSchematic::getRarity).thenComparing(UpgradeSchematic::getType).thenComparing(UpgradeSchematic::getKey)).toArray(UpgradeSchematic[]::new);
        this.schematicList.setSchematics(schematics);
    }

    public void keyTyped(char typedChar) {
        this.tabGroup.keyTyped(typedChar);
    }
}

