/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench.gui;

import java.util.function.Consumer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import se.mickelus.mgui.gui.GuiButton;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiText;
import se.mickelus.tetra.blocks.workbench.gui.GuiSchematicListItem;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class GuiSchematicList
extends GuiElement {
    private static int pageLength = 8;
    private int page = 0;
    private UpgradeSchematic[] schematics;
    private Consumer<UpgradeSchematic> schematicSelectionConsumer;
    private GuiElement listGroup = new GuiElement(3, 3, this.width - 6, this.height - 6);
    private GuiButton buttonBack;
    private GuiButton buttonForward;
    private GuiText emptyStateText;

    public GuiSchematicList(int x, int y, Consumer<UpgradeSchematic> schematicSelectionConsumer) {
        super(x, y, 224, 67);
        this.addChild(this.listGroup);
        this.buttonBack = new GuiButton(-25, this.height + 4, 45, 12, "< Previous", () -> this.setPage(this.getPage() - 1));
        this.addChild((GuiElement)this.buttonBack);
        this.buttonForward = new GuiButton(this.width - 20, this.height + 4, 30, 12, "Next >", () -> this.setPage(this.getPage() + 1));
        this.addChild((GuiElement)this.buttonForward);
        this.emptyStateText = new GuiText(10, 23, 204, TextFormatting.GRAY + I18n.func_135052_a((String)"tetra.workbench.schematic_list.empty", (Object[])new Object[0]));
        this.addChild((GuiElement)this.emptyStateText);
        this.schematicSelectionConsumer = schematicSelectionConsumer;
    }

    public void setSchematics(UpgradeSchematic[] schematics) {
        this.schematics = schematics;
        this.emptyStateText.setVisible(schematics.length == 0);
        this.setPage(0);
    }

    private void updateSchematics() {
        int count = pageLength;
        int offset = this.page * pageLength;
        if (count + offset > this.schematics.length) {
            count = this.schematics.length - offset;
        }
        this.listGroup.clearChildren();
        for (int i = 0; i < count; ++i) {
            UpgradeSchematic schematic = this.schematics[i + offset];
            this.listGroup.addChild((GuiElement)new GuiSchematicListItem(i / (pageLength / 2) * 109, i % (pageLength / 2) * 14, schematic, () -> this.schematicSelectionConsumer.accept(schematic)));
        }
    }

    private int getPage() {
        return this.page;
    }

    private void setPage(int page) {
        this.page = page;
        this.buttonBack.setVisible(page > 0);
        this.buttonForward.setVisible(page < this.getNumPages() - 1);
        this.updateSchematics();
    }

    private int getNumPages() {
        return (int)Math.ceil(1.0f * (float)this.schematics.length / (float)pageLength);
    }
}

