/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import se.mickelus.mgui.gui.ToggleableSlot;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

public class WorkbenchContainer
extends Container {
    private WorkbenchTile workbench;
    private ToggleableSlot[] materialSlots = new ToggleableSlot[0];

    public WorkbenchContainer(int windowId, WorkbenchTile workbench, IInventory playerInventory, PlayerEntity player) {
        super(WorkbenchTile.containerType, windowId);
        this.workbench = workbench;
        workbench.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            this.func_75146_a((Slot)new SlotItemHandler(handler, 0, 152, 58));
            this.materialSlots = new ToggleableSlot[3];
            for (int i = 0; i < this.materialSlots.length; ++i) {
                this.materialSlots[i] = new ToggleableSlot(handler, i + 1, 167, 107 + 18 * i);
                this.func_75146_a((Slot)this.materialSlots[i]);
            }
        });
        InvWrapper playerInventoryHandler = new InvWrapper(playerInventory);
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)playerInventoryHandler, y * 9 + x + 9, x * 17 + 84, y * 17 + 166));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)playerInventoryHandler, i, i * 17 + 84, 221));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static WorkbenchContainer create(int windowId, BlockPos pos, PlayerInventory inv) {
        WorkbenchTile te = (WorkbenchTile)Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
        return new WorkbenchContainer(windowId, te, (IInventory)inv, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    private int getSlots() {
        return this.workbench.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(IItemHandler::getSlots).orElse(0);
    }

    public boolean func_75145_c(PlayerEntity player) {
        BlockPos pos = this.workbench.func_174877_v();
        if (this.workbench.func_145831_w().func_180495_p(this.workbench.func_174877_v()).func_177230_c() instanceof AbstractWorkbenchBlock) {
            return player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
        }
        return false;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack resultStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            resultStack = slotStack.func_77946_l();
            if (index < this.getSlots() ? !this.func_75135_a(slotStack, this.getSlots(), this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, this.getSlots(), false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        this.workbench.func_70296_d();
        return resultStack;
    }

    public void updateSlots() {
        UpgradeSchematic currentSchematic = this.workbench.getCurrentSchematic();
        int numMaterialSlots = 0;
        if (currentSchematic != null) {
            numMaterialSlots = currentSchematic.getNumMaterialSlots();
        }
        for (int i = 0; i < this.materialSlots.length; ++i) {
            this.materialSlots[i].toggle(i < numMaterialSlots);
        }
    }

    public WorkbenchTile getTileEntity() {
        return this.workbench;
    }
}

