/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.workbench;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import se.mickelus.tetra.blocks.ITetraBlock;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.util.TileEntityOptional;

public abstract class AbstractWorkbenchBlock
extends TetraBlock
implements IInteractiveBlock {
    public AbstractWorkbenchBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ActionResultType interactionResult = BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
        if (interactionResult != ActionResultType.PASS || hand == Hand.OFF_HAND) {
            return interactionResult;
        }
        if (!world.field_72995_K) {
            TileEntityOptional.from((IBlockReader)world, pos, WorkbenchTile.class).ifPresent(te -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)te, (BlockPos)pos));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!this.equals(newState.func_177230_c())) {
            TileEntityOptional.from((IBlockReader)world, pos, WorkbenchTile.class).map(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).orElse(LazyOptional.empty()).ifPresent(cap -> {
                for (int i = 0; i < cap.getSlots(); ++i) {
                    ItemStack itemStack = cap.getStackInSlot(i);
                    if (itemStack.func_190926_b()) continue;
                    InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack.func_77946_l());
                }
            });
            TileEntityOptional.from((IBlockReader)world, pos, WorkbenchTile.class).ifPresent(TileEntity::func_145843_s);
        }
    }

    @Override
    public Collection<ToolType> getTools(World world, BlockPos pos, BlockState blockState) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-2, 0, -2), (BlockPos)pos.func_177982_a(2, 4, 2)).map(offsetPos -> new Pair(offsetPos, (Object)world.func_180495_p(offsetPos))).filter(pair -> ((BlockState)pair.getSecond()).func_177230_c() instanceof ITetraBlock).filter(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).canProvideTools(world, (BlockPos)pair.getFirst(), pos)).map(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).getTools(world, (BlockPos)pair.getFirst(), (BlockState)pair.getSecond())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public int getToolLevel(World world, BlockPos pos, BlockState blockState, ToolType toolType) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-2, 0, -2), (BlockPos)pos.func_177982_a(2, 4, 2)).map(offsetPos -> new Pair(offsetPos, (Object)world.func_180495_p(offsetPos))).filter(pair -> ((BlockState)pair.getSecond()).func_177230_c() instanceof ITetraBlock).filter(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).canProvideTools(world, (BlockPos)pair.getFirst(), pos)).map(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).getToolLevel(world, (BlockPos)pair.getFirst(), (BlockState)pair.getSecond(), toolType)).max(Integer::compare).orElse(-1);
    }

    private Pair<BlockPos, BlockState> getProvidingBlockstate(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, ToolType toolType, int level) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-2, 0, -2), (BlockPos)pos.func_177982_a(2, 4, 2)).map(offsetPos -> new Pair(offsetPos, (Object)world.func_180495_p(offsetPos))).filter(pair -> ((BlockState)pair.getSecond()).func_177230_c() instanceof ITetraBlock).filter(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).canProvideTools(world, (BlockPos)pair.getFirst(), pos)).filter(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).getToolLevel(world, (BlockPos)pair.getFirst(), (BlockState)pair.getSecond(), toolType) >= level).findFirst().orElse(null);
    }

    @Override
    public ItemStack onCraftConsumeTool(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, String slot, boolean isReplacing, PlayerEntity player, ToolType requiredTool, int requiredLevel, boolean consumeResources) {
        Pair<BlockPos, BlockState> provider = this.getProvidingBlockstate(world, pos, blockState, targetStack, requiredTool, requiredLevel);
        if (provider != null) {
            ITetraBlock block = (ITetraBlock)((BlockState)provider.getSecond()).func_177230_c();
            return block.onCraftConsumeTool(world, (BlockPos)provider.getFirst(), (BlockState)provider.getSecond(), targetStack, slot, isReplacing, player, requiredTool, requiredLevel, consumeResources);
        }
        return null;
    }

    @Override
    public ItemStack onActionConsumeTool(World world, BlockPos pos, BlockState blockState, ItemStack targetStack, PlayerEntity player, ToolType requiredTool, int requiredLevel, boolean consumeResources) {
        Pair<BlockPos, BlockState> provider = this.getProvidingBlockstate(world, pos, blockState, targetStack, requiredTool, requiredLevel);
        if (provider != null) {
            ITetraBlock block = (ITetraBlock)((BlockState)provider.getSecond()).func_177230_c();
            return block.onActionConsumeTool(world, (BlockPos)provider.getFirst(), (BlockState)provider.getSecond(), targetStack, player, requiredTool, requiredLevel, consumeResources);
        }
        return null;
    }

    @Override
    public ResourceLocation[] getSchematics(World world, BlockPos pos, BlockState blockState) {
        return (ResourceLocation[])BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-2, 0, -2), (BlockPos)pos.func_177982_a(2, 4, 2)).map(offsetPos -> new Pair(offsetPos, (Object)world.func_180495_p(offsetPos))).filter(pair -> ((BlockState)pair.getSecond()).func_177230_c() instanceof ITetraBlock).filter(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).canUnlockSchematics(world, (BlockPos)pair.getFirst(), pos)).map(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).getSchematics(world, (BlockPos)pair.getFirst(), blockState)).flatMap(Stream::of).toArray(ResourceLocation[]::new);
    }

    @Override
    public ResourceLocation[] getCraftingEffects(World world, BlockPos pos, BlockState blockState) {
        return (ResourceLocation[])BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-2, 0, -2), (BlockPos)pos.func_177982_a(2, 4, 2)).map(offsetPos -> new Pair(offsetPos, (Object)world.func_180495_p(offsetPos))).filter(pair -> ((BlockState)pair.getSecond()).func_177230_c() instanceof ITetraBlock).filter(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).canUnlockCraftingEffects(world, (BlockPos)pair.getFirst(), pos)).map(pair -> ((ITetraBlock)((BlockState)pair.getSecond()).func_177230_c()).getCraftingEffects(world, (BlockPos)pair.getFirst(), blockState)).flatMap(Stream::of).toArray(ResourceLocation[]::new);
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(World world, BlockPos pos, BlockState blockState, Direction face, Collection<ToolType> tools) {
        if (face == Direction.UP) {
            return TileEntityOptional.from((IBlockReader)world, pos, WorkbenchTile.class).map(WorkbenchTile::getInteractions).orElse(new BlockInteraction[0]);
        }
        return new BlockInteraction[0];
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WorkbenchTile();
    }
}

