/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import se.mickelus.mgui.gui.GuiAttachment;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiText;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.blocks.scroll.gui.ScrollPageButtonGui;

@OnlyIn(value=Dist.CLIENT)
public class ScrollScreen
extends Screen {
    private static int currentPage;
    private String[] pages;
    private GuiElement gui;
    private GuiText text;

    public ScrollScreen(String key) {
        super((ITextComponent)new StringTextComponent("tetra:scroll"));
        this.pages = I18n.func_135052_a((String)("item.tetra.scroll." + key + ".details"), (Object[])new Object[0]).split("\r");
        this.field_230708_k_ = 320;
        this.field_230709_l_ = 240;
        this.gui = new GuiElement(0, 0, this.field_230708_k_, this.field_230709_l_);
        this.gui.addChild(new GuiTexture(0, 0, 160, 186, new ResourceLocation("tetra", "textures/gui/pamphlet.png")).setAttachment(GuiAttachment.middleCenter));
        this.text = new GuiText(2, -75, 124, "");
        this.text.setAttachmentAnchor(GuiAttachment.middleCenter);
        this.text.setAttachmentPoint(GuiAttachment.topCenter);
        this.text.setColor(16766776);
        this.gui.addChild((GuiElement)this.text);
        this.gui.addChild(new ScrollPageButtonGui(70, -10, true, () -> this.changePage(currentPage - 1)).setAttachment(GuiAttachment.bottomLeft));
        this.gui.addChild(new ScrollPageButtonGui(-70, -10, false, () -> this.changePage(currentPage + 1)).setAttachment(GuiAttachment.bottomRight));
        this.changePage(currentPage);
    }

    private void changePage(int index) {
        currentPage = MathHelper.func_76125_a((int)index, (int)0, (int)(this.pages.length - 1));
        this.text.setString(this.pages[currentPage]);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_238651_a_(matrixStack, 0);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.gui.draw(matrixStack, (this.field_230708_k_ - this.gui.getWidth()) / 2, (this.field_230709_l_ - this.gui.getHeight()) / 2, this.field_230708_k_, this.field_230709_l_, mouseX, mouseY, 1.0f);
        this.renderHoveredToolTip(matrixStack, mouseX, mouseY);
    }

    protected void renderHoveredToolTip(MatrixStack matrixStack, int mouseX, int mouseY) {
        List tooltipLines = this.gui.getTooltipLines();
        if (tooltipLines != null) {
            List textComponents = tooltipLines.stream().map(line -> line.replace("\\n", "\n")).flatMap(line -> Arrays.stream(line.split("\n"))).map(StringTextComponent::new).collect(Collectors.toList());
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, textComponents, (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)280, (FontRenderer)this.field_230712_o_);
        }
    }

    public boolean func_231044_a_(double x, double y, int button) {
        this.gui.onMouseClick((int)x, (int)y, button);
        return super.func_231044_a_(x, y, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double distance) {
        return this.gui.onMouseScroll(mouseX, mouseY, distance);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (((Boolean)ConfigHandler.development.get()).booleanValue()) {
            switch (typedChar) {
                case 'a': {
                    this.changePage(currentPage - 1);
                    break;
                }
                case 'd': {
                    this.changePage(currentPage + 1);
                }
            }
        }
        return false;
    }
}

