/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.blocks.scroll.OpenScrollBlock;
import se.mickelus.tetra.blocks.scroll.RolledScrollBlock;
import se.mickelus.tetra.blocks.scroll.ScrollData;
import se.mickelus.tetra.blocks.scroll.ScrollDrops;
import se.mickelus.tetra.blocks.scroll.ScrollItemColor;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.blocks.scroll.WallScrollBlock;
import se.mickelus.tetra.blocks.scroll.gui.ScrollScreen;
import se.mickelus.tetra.blocks.workbench.AbstractWorkbenchBlock;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.util.TileEntityOptional;

public class ScrollItem
extends BlockItem {
    static final String identifier = "scroll_rolled";
    @ObjectHolder(value="tetra:scroll_rolled")
    public static ScrollItem instance;
    public static ItemStack gemExpertise;
    public static ItemStack metalExpertise;
    public static ItemStack woodExpertise;
    public static ItemStack stoneExpertise;
    public static ItemStack fibreExpertise;
    public static ItemStack skinExpertise;
    public static ItemStack boneExpertise;
    public static ItemStack fabricExpertise;
    public static ItemStack scaleExpertise;
    public static ItemStack hammerEfficiency;
    public static ItemStack axeEfficiency;
    public static ItemStack cutEfficiency;
    public static ItemStack sturdyGuard;
    public static ItemStack throwingKnife;
    public static ItemStack howlingBlade;

    public ScrollItem(Block block) {
        super(block, new Item.Properties().func_200916_a((ItemGroup)TetraItemGroup.instance).func_200917_a(1));
        this.setRegistryName("tetra", identifier);
        MinecraftForge.EVENT_BUS.register((Object)new ScrollDrops());
        gemExpertise = this.setupTreatise("gem_expertise", false, 0, 2883566, 14, 13, 14, 15);
        metalExpertise = this.setupTreatise("metal_expertise", false, 0, 0xFFFFFF, 4, 6, 6, 5);
        woodExpertise = this.setupTreatise("wood_expertise", false, 0, 12555083, 2, 1, 2, 1);
        stoneExpertise = this.setupTreatise("stone_expertise", false, 0, 0x9A9A9A, 2);
        fibreExpertise = this.setupTreatise("fibre_expertise", false, 0, 11042900, 5, 10, 11, 4);
        skinExpertise = this.setupTreatise("skin_expertise", false, 0, 12544304, 0, 1, 1, 1);
        boneExpertise = this.setupTreatise("bone_expertise", false, 0, 16773523, 12, 14, 12, 14);
        fabricExpertise = this.setupTreatise("fabric_expertise", false, 0, 0xFF3333, 5, 3, 6, 4);
        scaleExpertise = this.setupTreatise("scale_expertise", false, 0, 7708734, 6, 7, 6, 8);
        hammerEfficiency = this.setupTreatise("hammer_efficiency", false, 0, 0xFF6666, 6, 7, 6, 11);
        axeEfficiency = this.setupTreatise("axe_efficiency", false, 0, 0x66FF66, 0, 1, 3, 3);
        cutEfficiency = this.setupTreatise("cut_efficiency", false, 0, 0x6666FF, 4, 0, 3, 5);
        sturdyGuard = this.setupSchematic("sword/sturdy_guard", null, false, 1, 12368053, 3, 2, 2, 1);
        throwingKnife = this.setupSchematic("sword/throwing_knife", null, false, 1, 12111577, 4, 1, 0, 5);
        howlingBlade = this.setupSchematic("sword/howling", null, false, 1, 16446358, 8, 9, 10, 5);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientPostInit() {
        Minecraft.func_71410_x().getItemColors().func_199877_a((IItemColor)new ScrollItemColor(), new IItemProvider[]{instance});
        ItemModelsProperties.func_239418_a_((Item)instance, (ResourceLocation)new ResourceLocation("tetra", "scroll_mat"), (itemStack, world, livingEntity) -> ScrollData.readMaterialFast(itemStack));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)gemExpertise);
            items.add((Object)metalExpertise);
            items.add((Object)woodExpertise);
            items.add((Object)stoneExpertise);
            items.add((Object)fibreExpertise);
            items.add((Object)skinExpertise);
            items.add((Object)boneExpertise);
            items.add((Object)fabricExpertise);
            items.add((Object)scaleExpertise);
            items.add((Object)hammerEfficiency);
            items.add((Object)axeEfficiency);
            items.add((Object)cutEfficiency);
            items.add((Object)sturdyGuard);
            items.add((Object)throwingKnife);
            items.add((Object)howlingBlade);
            items.add((Object)this.setupSchematic("double/adze/warforge", "warforge", false, 2, 8739251, 6, 7, 11, 7));
            items.add((Object)this.setupSchematic("double/basic_axe/warforge", "warforge", false, 2, 11753843, 5, 10, 8, 9));
            items.add((Object)this.setupSchematic("double/basic_hammer/warforge", "warforge", false, 2, 4014745, 9, 8, 11, 10));
            items.add((Object)this.setupSchematic("double/basic_pickaxe/warforge", "warforge", false, 2, 5278899, 6, 11, 8, 7));
            items.add((Object)this.setupSchematic("double/claw/warforge", "warforge", false, 2, 1910319, 8, 10, 5, 11));
            items.add((Object)this.setupSchematic("double/hoe/warforge", "warforge", false, 2, 9679696, 10, 7, 9, 5));
            items.add((Object)this.setupSchematic("double/sickle/warforge", "warforge", false, 2, 14261836, 5, 9, 6, 10));
            items.add((Object)this.setupSchematic("double/butt/warforge", "warforge", new String[]{"double/butt_shared/warforge/"}, false, 2, 0xB33636, 11, 5, 8, 9));
            items.add((Object)this.setupSchematic("hone_gild_1", null, new String[]{"shared/hone_gild_1"}, true, 2, 13217385, 15, 14, 15, 15));
            items.add((Object)this.setupSchematic("hone_gild_5", null, new String[]{"shared/hone_gild_"}, true, 2, 15905555, 12, 12, 12, 12));
        }
    }

    private ItemStack setupSchematic(String key, String details, boolean isIntricate, int material, int tint, Integer ... glyphs) {
        return this.setupSchematic(key, details, new String[]{key}, isIntricate, material, tint, glyphs);
    }

    private ItemStack setupSchematic(String key, String details, String[] schematics, boolean isIntricate, int material, int tint, Integer ... glyphs) {
        ScrollData data = new ScrollData(key, Optional.ofNullable(details), isIntricate, material, tint, Arrays.asList(glyphs), Arrays.stream(schematics).map(s -> new ResourceLocation("tetra", s)).collect(Collectors.toList()), Collections.emptyList());
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        data.write(itemStack);
        return itemStack;
    }

    private ItemStack setupTreatise(String key, boolean isIntricate, int material, int tint, Integer ... glyphs) {
        ScrollData data = new ScrollData(key, Optional.empty(), isIntricate, material, tint, Arrays.asList(glyphs), Collections.emptyList(), (List<ResourceLocation>)ImmutableList.of((Object)new ResourceLocation("tetra", key)));
        ItemStack itemStack = new ItemStack((IItemProvider)this);
        data.write(itemStack);
        return itemStack;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        String prefixKey;
        String key = ScrollData.read((ItemStack)stack).key;
        if (!Environment.get().getDist().isDedicatedServer() && I18n.func_188566_a((String)(prefixKey = "item.tetra.scroll." + key + ".prefix"))) {
            return new TranslationTextComponent("item.tetra.scroll." + key + ".prefix").func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new TranslationTextComponent("item.tetra.scroll." + key + ".name"));
        }
        return new TranslationTextComponent("item.tetra.scroll." + key + ".name");
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ScrollData data = ScrollData.read(itemStack);
        StringJoiner attributes = new StringJoiner(" ");
        if (!ScrollData.read((ItemStack)itemStack).schematics.isEmpty()) {
            attributes.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"item.tetra.scroll.schematics", (Object[])new Object[0]));
        }
        if (!ScrollData.read((ItemStack)itemStack).craftingEffects.isEmpty()) {
            attributes.add(TextFormatting.DARK_AQUA + I18n.func_135052_a((String)"item.tetra.scroll.effects", (Object[])new Object[0]));
        }
        if (data.isIntricate) {
            attributes.add(TextFormatting.GOLD + I18n.func_135052_a((String)"item.tetra.scroll.intricate", (Object[])new Object[0]));
        }
        tooltip.add((ITextComponent)new StringTextComponent(attributes.toString()));
        tooltip.add((ITextComponent)new StringTextComponent(" "));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.scroll." + data.key + ".description").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new StringTextComponent(" "));
        if (Screen.func_231173_s_()) {
            tooltip.add(Tooltips.expanded);
            if (!ScrollData.read((ItemStack)itemStack).schematics.isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent(" "));
                tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.scroll.schematics").func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.DARK_PURPLE}));
                tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.scroll.schematics.description").func_240699_a_(TextFormatting.GRAY));
            }
            if (!ScrollData.read((ItemStack)itemStack).craftingEffects.isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent(" "));
                tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.scroll.effects").func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.DARK_AQUA}));
                tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.scroll.effects.description").func_240699_a_(TextFormatting.GRAY));
            }
            if (data.isIntricate) {
                tooltip.add((ITextComponent)new StringTextComponent(" "));
                tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.scroll.intricate").func_240701_a_(new TextFormatting[]{TextFormatting.UNDERLINE, TextFormatting.GOLD}));
                tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.scroll.intricate.description").func_240699_a_(TextFormatting.GRAY));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(" "));
                tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.scroll.range.description").func_240699_a_(TextFormatting.GRAY));
            }
            if (I18n.func_188566_a((String)("item.tetra.scroll." + data.key + ".description_extended"))) {
                tooltip.add((ITextComponent)new StringTextComponent(" "));
                tooltip.add((ITextComponent)new TranslationTextComponent("item.tetra.scroll." + data.key + ".description_extended").func_240699_a_(TextFormatting.GRAY));
            }
        } else {
            tooltip.add(Tooltips.expand);
        }
        if (flagIn.func_194127_a()) {
            tooltip.add((ITextComponent)new StringTextComponent("s: " + data.schematics + ",e: " + data.craftingEffects));
        }
    }

    private boolean openScroll(ItemStack itemStack, boolean isRemote) {
        ScrollData data = ScrollData.read(itemStack);
        if (data.details != null) {
            if (isRemote) {
                this.showDetailsScreen(data.details);
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void showDetailsScreen(String detailsKey) {
        ScrollScreen screen = new ScrollScreen(detailsKey);
        Minecraft.func_71410_x().func_147108_a((Screen)screen);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.openScroll(player.func_184586_b(hand), world.field_72995_K)) {
            return ActionResult.func_233538_a_((Object)itemstack, (boolean)world.func_201670_d());
        }
        return ActionResult.func_226250_c_((Object)itemstack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        boolean success;
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        ItemStack itemStack = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        Block block = context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c();
        if (!(block instanceof AbstractWorkbenchBlock) && player != null && player.func_213453_ef() && this.openScroll(itemStack, world.field_72995_K)) {
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        if (RolledScrollBlock.instance.equals(block) && (success = TileEntityOptional.from((IBlockReader)world, pos, ScrollTile.class).map(tile -> tile.addScroll(itemStack)).orElse(false).booleanValue())) {
            if (player == null || !player.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return this.func_195942_a(new BlockItemUseContext(context));
    }

    @Nullable
    protected BlockState func_195945_b(BlockItemUseContext context) {
        BlockState state = this.func_179223_d().func_176223_P();
        if (context.func_196000_l().func_176740_k().func_176716_d() == Direction.Plane.HORIZONTAL) {
            state = (BlockState)WallScrollBlock.instance.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_196000_l());
        } else {
            if (context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d())).func_177230_c() instanceof AbstractWorkbenchBlock) {
                state = OpenScrollBlock.instance.func_176223_P();
            }
            state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f());
        }
        return this.func_195944_a(context, state) ? state : null;
    }
}

