/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.scroll;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.ResourceLocation;
import se.mickelus.tetra.util.HexCodec;

public class ScrollData {
    public String key;
    public String details;
    public boolean isIntricate;
    public int material = 0;
    public int ribbon = 0xFFFFFF;
    public List<Integer> glyphs = Collections.emptyList();
    public List<ResourceLocation> schematics = Collections.emptyList();
    public List<ResourceLocation> craftingEffects = Collections.emptyList();
    private static final Codec<ScrollData> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(i -> i.key), (App)Codec.STRING.optionalFieldOf("details").forGetter(i -> Optional.ofNullable(i.details)), (App)Codec.BOOL.fieldOf("intricate").forGetter(i -> i.isIntricate), (App)Codec.INT.fieldOf("material").forGetter(i -> i.material), (App)HexCodec.instance.fieldOf("ribbon").forGetter(i -> i.ribbon), (App)Codec.INT.listOf().optionalFieldOf("glyphs", Collections.emptyList()).forGetter(i -> i.glyphs), (App)ResourceLocation.field_240908_a_.listOf().optionalFieldOf("schematics", Collections.emptyList()).forGetter(i -> i.schematics), (App)ResourceLocation.field_240908_a_.listOf().optionalFieldOf("effects", Collections.emptyList()).forGetter(i -> i.craftingEffects)).apply((Applicative)instance, ScrollData::new));

    public ScrollData() {
        this.key = "unknown";
    }

    public ScrollData(String name, Optional<String> details, boolean isIntricate, int material, int ribbon, List<Integer> glyphs, List<ResourceLocation> schematics, List<ResourceLocation> craftingEffects) {
        this.key = name;
        this.details = details.orElse(null);
        this.isIntricate = isIntricate;
        this.material = material;
        this.ribbon = ribbon;
        this.glyphs = glyphs;
        if (!schematics.isEmpty()) {
            this.schematics = schematics;
        }
        if (!craftingEffects.isEmpty()) {
            this.craftingEffects = craftingEffects;
        }
    }

    public static int readMaterialFast(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.func_179543_a("BlockEntityTag")).map(tag -> tag.func_150295_c("data", 10)).filter(list -> list.size() > 0).map(list -> list.func_150305_b(0)).map(tag -> tag.func_74762_e("material")).orElse(0);
    }

    public static int readRibbonFast(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.func_179543_a("BlockEntityTag")).map(tag -> tag.func_150295_c("data", 10)).filter(list -> list.size() > 0).map(list -> list.func_150305_b(0)).map(tag -> tag.func_74779_i("ribbon")).map(hex -> (int)Long.parseLong(hex, 16)).orElse(0);
    }

    public static ScrollData read(ItemStack itemStack) {
        return Optional.ofNullable(itemStack.func_179543_a("BlockEntityTag")).map(ScrollData::read).filter(data -> ((ScrollData[])data).length > 0).map(data -> data[0]).orElseGet(ScrollData::new);
    }

    public void write(ItemStack itemStack) {
        itemStack.func_77983_a("BlockEntityTag", (INBT)ScrollData.write(new ScrollData[]{this}, new CompoundNBT()));
    }

    public static ScrollData[] read(CompoundNBT tag) {
        return (ScrollData[])tag.func_150295_c("data", 10).stream().map(nbt -> codec.decode((DynamicOps)NBTDynamicOps.field_210820_a, nbt)).map(DataResult::result).filter(Optional::isPresent).map(Optional::get).map(Pair::getFirst).toArray(ScrollData[]::new);
    }

    public static CompoundNBT write(ScrollData[] data, CompoundNBT tag) {
        ListNBT list = Arrays.stream(data).map(scroll -> codec.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, scroll)).map(DataResult::result).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(ListNBT::new));
        tag.func_218657_a("data", (INBT)list);
        return tag;
    }

    public static ScrollData read(JsonObject json) {
        return Optional.of(codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json)).flatMap(DataResult::result).map(Pair::getFirst).orElse(null);
    }

    public JsonElement write(JsonObject json) {
        return Optional.of(codec.encode((Object)this, (DynamicOps)JsonOps.INSTANCE, (Object)json)).flatMap(DataResult::result).orElse(null);
    }
}

