/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.ToolType;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.blocks.workbench.gui.GuiTool;
import se.mickelus.tetra.properties.PropertyHelper;

public class InteractiveToolGui
extends GuiElement {
    private GuiTool toolIcon;
    private KeyframeAnimation show;
    private KeyframeAnimation hide;
    private ToolType toolType;
    private int toolLevel;
    private PlayerEntity player;
    private int currentSlot;

    public InteractiveToolGui(int x, int y, ToolType toolType, int toolLevel, PlayerEntity player) {
        super(x, y, 16, 16);
        this.opacity = 0.0f;
        this.toolType = toolType;
        this.toolLevel = toolLevel;
        this.player = player;
        this.toolIcon = new GuiTool(-1, 0, toolType);
        this.addChild(this.toolIcon);
        this.show = new KeyframeAnimation(100, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(0.0f, 1.0f)}).withDelay(650);
        this.hide = new KeyframeAnimation(100, (GuiElement)this).applyTo(new Applier[]{new Applier.Opacity(1.0f, 0.0f)});
        this.updateTint();
        this.currentSlot = player.field_71071_by.field_70461_c;
    }

    public void updateFadeTime() {
        this.show = this.show.withDelay(0);
    }

    private void updateTint() {
        int mainHandLevel = PropertyHelper.getItemToolLevel(this.player.func_184614_ca(), this.toolType);
        int offHandLevel = PropertyHelper.getItemToolLevel(this.player.func_184592_cb(), this.toolType);
        if (mainHandLevel >= this.toolLevel || offHandLevel >= this.toolLevel) {
            this.toolIcon.update(this.toolLevel, 0xFFFFFF);
        } else if (PropertyHelper.getPlayerToolLevel(this.player, this.toolType) >= this.toolLevel) {
            this.toolIcon.update(this.toolLevel, 0xFFFF00);
        } else {
            this.toolIcon.update(this.toolLevel, 0xFF5555);
        }
    }

    public void show() {
        this.updateTint();
        this.hide.stop();
        this.show.start();
    }

    public void hide() {
        this.show.stop();
        this.hide.start();
    }

    public void draw(MatrixStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        if (this.player.field_71071_by.field_70461_c != this.currentSlot) {
            this.updateTint();
            this.currentSlot = this.player.field_71071_by.field_70461_c;
        }
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
    }
}

