/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.advancements;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.advancements.GenericTrigger;
import se.mickelus.tetra.blocks.PropertyMatcher;

public class BlockLookTrigger
extends GenericTrigger<Instance> {
    private Cache<UUID, BlockState> stateCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static final BlockLookTrigger instance = new BlockLookTrigger();

    public BlockLookTrigger() {
        super("tetra:block_look", BlockLookTrigger::deserialize);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (TickEvent.Phase.START == event.phase && event.player.field_70173_aa % 20 == 0 && !event.player.field_70170_p.field_72995_K) {
            event.player.field_70170_p.func_217381_Z().func_76320_a("lookTrigger");
            Vector3d playerPosition = event.player.func_174824_e(0.0f);
            float lookDistance = 5.0f;
            Vector3d lookingPosition = event.player.func_70040_Z().func_186678_a((double)lookDistance).func_178787_e(playerPosition);
            BlockRayTraceResult result = event.player.field_70170_p.func_217299_a(new RayTraceContext(playerPosition, lookingPosition, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)event.player));
            if (!RayTraceResult.Type.MISS.equals((Object)result.func_216346_c())) {
                BlockState currentState = event.player.field_70170_p.func_180495_p(new BlockPos((Vector3i)result.func_216350_a()));
                if (!currentState.equals(this.stateCache.getIfPresent((Object)event.player.func_110124_au()))) {
                    this.trigger((ServerPlayerEntity)event.player, currentState);
                    this.stateCache.put((Object)event.player.func_110124_au(), (Object)currentState);
                }
            } else {
                this.stateCache.invalidate((Object)event.player.func_110124_au());
            }
            event.player.field_70170_p.func_217381_Z().func_76319_b();
        }
    }

    public static Instance deserialize(JsonObject json, EntityPredicate.AndPredicate entityPredicate, ConditionArrayParser conditionsParser) {
        PropertyMatcher propertyMatcher = null;
        if (json.has("block")) {
            propertyMatcher = PropertyMatcher.deserialize(json.get("block"));
        }
        return new Instance(entityPredicate, propertyMatcher);
    }

    public void trigger(ServerPlayerEntity player, BlockState state) {
        this.fulfillCriterion(player, instance -> instance.test(state));
    }

    public static class Instance
    extends CriterionInstance {
        private PropertyMatcher block = null;

        public Instance(EntityPredicate.AndPredicate playerCondition, PropertyMatcher propertyMatcher) {
            super(instance.func_192163_a(), playerCondition);
            this.block = propertyMatcher;
        }

        public boolean test(BlockState state) {
            return this.block != null && this.block.test(state);
        }
    }
}

