/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.packets;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2540;

public class PacketRemoveTesseractReferences
implements BasePacket {
    private Collection<Pair<String, class_2338>> references;

    public PacketRemoveTesseractReferences(Collection<TesseractReference> references) {
        this.references = references.stream().map(reference -> Pair.of((Object)reference.getDimension(), (Object)reference.getPos())).collect(Collectors.toSet());
    }

    public PacketRemoveTesseractReferences() {
    }

    public void write(class_2540 buffer) {
        buffer.writeInt(this.references.size());
        for (Pair<String, class_2338> reference : this.references) {
            buffer.method_10814((String)reference.left());
            buffer.method_10807((class_2338)reference.right());
        }
    }

    public void read(class_2540 buffer) {
        int size = buffer.readInt();
        this.references = new ArrayList<Pair<String, class_2338>>(size);
        for (int i = 0; i < size; ++i) {
            this.references.add((Pair<String, class_2338>)Pair.of((Object)buffer.method_19772(), (Object)buffer.method_10811()));
        }
    }

    public void handle(PacketContext context) {
        if (context.getHandlingSide().isServer()) {
            return;
        }
        for (Pair<String, class_2338> reference : this.references) {
            TesseractTracker.CLIENT.remove((String)reference.left(), (class_2338)reference.right());
        }
    }
}

