/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.packets.PacketAddTesseractReferences;
import com.supermartijn642.tesseract.packets.PacketRemoveTesseractReferences;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.server.MinecraftServer;

public class TesseractTracker {
    public static final TesseractTracker SERVER = new TesseractTracker();
    public static final TesseractTracker CLIENT = new TesseractTracker();
    private static long referenceIndexCounter = 0L;
    private final HashMap<String, HashMap<class_2338, TesseractReference>> tesseracts = new HashMap();
    private final Set<TesseractReference> dirtyReferences = new HashSet<TesseractReference>();
    private final Set<TesseractReference> referencesToBeRemoved = new HashSet<TesseractReference>();
    private final Set<TesseractReference> referencesToBeSaved = new HashSet<TesseractReference>();
    private final Set<Long> referencesToBeUnsaved = new HashSet<Long>();

    public static TesseractTracker getInstance(class_1937 level) {
        return level.field_9236 ? CLIENT : SERVER;
    }

    public static void registerListeners() {
        ServerTickEvents.END_SERVER_TICK.register(TesseractTracker::onTick);
    }

    public TesseractReference add(TesseractBlockEntity self) {
        class_2338 pos;
        String dimension = self.method_10997().method_27983().method_29177().toString();
        TesseractReference reference = this.getReference(dimension, pos = self.method_11016());
        if (reference != null) {
            return reference;
        }
        reference = new TesseractReference(referenceIndexCounter++, self);
        if (this == SERVER) {
            this.markDirty(reference);
        }
        this.tesseracts.computeIfAbsent(dimension, o -> new HashMap()).put(pos, reference);
        return reference;
    }

    public void add(TesseractReference reference) {
        if (this == CLIENT) {
            String dimension = reference.getDimension();
            class_2338 pos = reference.getPos();
            TesseractReference oldReference = this.tesseracts.computeIfAbsent(dimension, o -> new HashMap()).put(pos, reference);
            if (oldReference != null && oldReference != reference && oldReference.canBeAccessed()) {
                oldReference.getTesseract().invalidateReference();
            }
        }
    }

    public TesseractReference getReference(String dimension, class_2338 pos) {
        return this.tesseracts.containsKey(dimension) ? this.tesseracts.get(dimension).get(pos) : null;
    }

    public void remove(class_1937 level, class_2338 pos) {
        String dimension = level.method_27983().method_29177().toString();
        this.remove(dimension, pos);
    }

    public void remove(String dimension, class_2338 pos) {
        if (this == SERVER) {
            TesseractReference reference = this.getReference(dimension, pos);
            if (reference != null) {
                this.referencesToBeRemoved.add(reference);
            }
        } else if (this.tesseracts.containsKey(dimension)) {
            this.tesseracts.get(dimension).remove(pos);
        }
    }

    void markDirty(TesseractReference reference) {
        this.dirtyReferences.add(reference);
        this.referencesToBeSaved.add(reference);
    }

    public static void onTick(MinecraftServer server) {
        if (!TesseractTracker.SERVER.referencesToBeRemoved.isEmpty()) {
            for (TesseractReference reference : TesseractTracker.SERVER.referencesToBeRemoved) {
                reference.delete();
                TesseractTracker.SERVER.tesseracts.get(reference.getDimension()).remove(reference.getPos());
                TesseractTracker.SERVER.dirtyReferences.remove(reference);
                TesseractTracker.SERVER.referencesToBeUnsaved.add(reference.getSaveIndex());
                TesseractTracker.SERVER.referencesToBeSaved.remove(reference);
            }
            Tesseract.CHANNEL.sendToAllPlayers((BasePacket)new PacketRemoveTesseractReferences(TesseractTracker.SERVER.referencesToBeRemoved));
            TesseractTracker.SERVER.referencesToBeRemoved.clear();
        }
        if (!TesseractTracker.SERVER.dirtyReferences.isEmpty()) {
            Tesseract.CHANNEL.sendToAllPlayers((BasePacket)new PacketAddTesseractReferences(TesseractTracker.SERVER.dirtyReferences));
            TesseractTracker.SERVER.dirtyReferences.clear();
        }
    }

    public class_2487 writeKey(TesseractReference reference) {
        class_2487 tag = new class_2487();
        tag.method_10582("dimension", reference.getDimension());
        tag.method_10569("posx", reference.getPos().method_10263());
        tag.method_10569("posy", reference.getPos().method_10264());
        tag.method_10569("posz", reference.getPos().method_10260());
        return tag;
    }

    public TesseractReference fromKey(class_2487 key) {
        String dimension = key.method_10558("dimension");
        class_2338 pos = new class_2338(key.method_10550("posx"), key.method_10550("posy"), key.method_10550("posz"));
        return this.getReference(dimension, pos);
    }

    public static void saveReferences(Path saveDirectory) {
        Path file;
        Path directory = saveDirectory.resolve("tesseract/tracking");
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            Tesseract.LOGGER.error("Failed to create tesseract reference save directory!", (Throwable)e);
            return;
        }
        for (TesseractReference reference : TesseractTracker.SERVER.referencesToBeSaved) {
            file = directory.resolve("tesseract" + reference.getSaveIndex() + ".nbt");
            try (DataOutputStream output = new DataOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
                class_2507.method_10628((class_2487)reference.write(), (DataOutput)output);
            }
            catch (IOException e) {
                Tesseract.LOGGER.error("Failed to save tesseract reference file '" + file + "'!", (Throwable)e);
            }
        }
        for (Long index : TesseractTracker.SERVER.referencesToBeUnsaved) {
            file = directory.resolve("tesseract" + index + ".nbt");
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                Tesseract.LOGGER.error("Failed to remove tesseract reference file '" + file + "'!", (Throwable)e);
            }
        }
        TesseractTracker.SERVER.referencesToBeSaved.clear();
        TesseractTracker.SERVER.referencesToBeUnsaved.clear();
    }

    public static void loadReferences(Path saveDirectory) {
        TesseractTracker.SERVER.tesseracts.clear();
        TesseractTracker.SERVER.dirtyReferences.clear();
        TesseractTracker.SERVER.referencesToBeRemoved.clear();
        TesseractTracker.SERVER.referencesToBeSaved.clear();
        TesseractTracker.SERVER.referencesToBeUnsaved.clear();
        referenceIndexCounter = 0L;
        Path directory = saveDirectory.resolve("tesseract/tracking");
        if (Files.exists(directory, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(directory);){
                files.forEach(file -> {
                    String fileName;
                    if (Files.isRegularFile(file, new LinkOption[0]) && (fileName = file.getFileName().toString()).startsWith("tesseract") && fileName.endsWith(".nbt")) {
                        try {
                            class_2487 tag;
                            long index = Long.parseLong(file.getFileName().toString().substring("tesseract".length(), file.getFileName().toString().length() - ".nbt".length()));
                            if (index > referenceIndexCounter) {
                                referenceIndexCounter = index + 1L;
                            }
                            try (DataInputStream input = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));){
                                tag = class_2507.method_10627((DataInput)input);
                            }
                            TesseractReference reference = new TesseractReference(index, tag, false);
                            TesseractTracker.SERVER.tesseracts.putIfAbsent(reference.getDimension(), new HashMap());
                            TesseractTracker.SERVER.tesseracts.get(reference.getDimension()).put(reference.getPos(), reference);
                        }
                        catch (IOException exception) {
                            Tesseract.LOGGER.error("Failed to read tesseract data from file '~/tesseract/tracking/" + file.getFileName() + "':", (Throwable)exception);
                        }
                    }
                });
            }
            catch (IOException e) {
                Tesseract.LOGGER.error("Failed to load tesseract references!", (Throwable)e);
            }
        }
        System.out.println("Loaded " + TesseractTracker.SERVER.tesseracts.values().stream().map(Map::values).mapToLong(Collection::size).sum() + " tesseract references!");
    }

    public static void sendReferences(class_1657 player) {
        Collection references = TesseractTracker.SERVER.tesseracts.values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
        Tesseract.CHANNEL.sendToPlayer(player, (BasePacket)new PacketAddTesseractReferences(references));
    }
}

