/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class TesseractReference {
    private final long index;
    private final String dimension;
    private final class_2338 pos;
    private final boolean isClientSide;
    private final EnumMap<EnumChannelType, Integer> channels = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canSend = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canReceive = new EnumMap(EnumChannelType.class);
    private WeakReference<TesseractBlockEntity> entity;

    TesseractReference(long index, TesseractBlockEntity entity) {
        this.index = index;
        this.dimension = entity.method_10997().method_27983().method_29177().toString();
        this.pos = entity.method_11016();
        this.isClientSide = entity.method_10997().field_9236;
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, -1);
            this.canSend.put(type, entity.canSend(type));
            this.canReceive.put(type, entity.canReceive(type));
        }
    }

    public TesseractReference(long index, class_2487 tag, boolean isClientSide) {
        this.index = index;
        this.dimension = tag.method_10558("dim");
        this.pos = new class_2338(tag.method_10550("posx"), tag.method_10550("posy"), tag.method_10550("posz"));
        this.isClientSide = isClientSide;
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, tag.method_10550(type + "_channel"));
            this.canSend.put(type, tag.method_10577(type + "_canSend"));
            this.canReceive.put(type, tag.method_10577(type + "_canReceive"));
        }
    }

    public long getSaveIndex() {
        return this.index;
    }

    public String getDimension() {
        return this.dimension;
    }

    public class_1937 getLevel() {
        if (this.isClientSide) {
            return ClientUtils.getWorld().method_27983().method_29177().toString().equals(this.dimension) ? ClientUtils.getWorld() : null;
        }
        class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(this.dimension));
        return CommonUtils.getLevel((class_5321)key);
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public boolean isValid() {
        boolean isValid;
        class_1937 level = this.getLevel();
        boolean bl = isValid = level != null && level.method_8320(this.pos).method_26204() == Tesseract.tesseract && level.method_8321(this.pos) instanceof TesseractBlockEntity;
        if (!isValid && !this.isClientSide) {
            TesseractTracker.SERVER.remove(this.dimension, this.pos);
        }
        return isValid;
    }

    public boolean canBeAccessed() {
        class_1937 level = this.getLevel();
        return level != null && this.getLevel().method_8477(this.pos) && this.isValid();
    }

    public TesseractBlockEntity getTesseract() {
        if (this.entity == null || this.entity.get() == null || ((TesseractBlockEntity)((Object)this.entity.get())).method_11015() || !((TesseractBlockEntity)((Object)this.entity.get())).method_11016().equals((Object)this.pos)) {
            this.entity = new WeakReference<TesseractBlockEntity>((TesseractBlockEntity)this.getLevel().method_8321(this.pos));
        }
        return this.entity == null ? null : (TesseractBlockEntity)((Object)this.entity.get());
    }

    public class_2487 write() {
        class_2487 compound = new class_2487();
        compound.method_10582("dim", this.dimension);
        compound.method_10569("posx", this.pos.method_10263());
        compound.method_10569("posy", this.pos.method_10264());
        compound.method_10569("posz", this.pos.method_10260());
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.method_10569(type + "_channel", this.channels.get((Object)type).intValue());
            compound.method_10556(type + "_canSend", this.canSend.get((Object)type).booleanValue());
            compound.method_10556(type + "_canReceive", this.canReceive(type));
        }
        return compound;
    }

    public boolean canSend(EnumChannelType type) {
        return this.canSend.get((Object)type);
    }

    public boolean canReceive(EnumChannelType type) {
        return this.canReceive.get((Object)type);
    }

    public int getChannelId(EnumChannelType type) {
        return this.channels.get((Object)type);
    }

    public Channel getChannel(EnumChannelType type) {
        if (this.channels.get((Object)type) < 0) {
            return null;
        }
        Channel channel = TesseractChannelManager.getInstance(this.isClientSide).getChannelById(type, this.channels.get((Object)type));
        if (channel == null && !this.isClientSide) {
            this.channels.put(type, -1);
            this.markDirty();
            if (this.canBeAccessed()) {
                this.getTesseract().channelChanged(type);
            }
        }
        return channel;
    }

    public void setChannel(EnumChannelType type, int channel) {
        Channel newChannel;
        if (channel == this.channels.get((Object)type)) {
            return;
        }
        Channel oldChannel = this.getChannel(type);
        this.channels.put(type, channel);
        if (oldChannel != null) {
            oldChannel.removeTesseract(this);
        }
        if ((newChannel = this.getChannel(type)) != null) {
            newChannel.addTesseract(this);
        }
        this.markDirty();
        if (this.canBeAccessed()) {
            this.getTesseract().channelChanged(type);
        }
    }

    public void update(TesseractBlockEntity entity) {
        for (EnumChannelType type : EnumChannelType.values()) {
            boolean canReceive;
            boolean changed = false;
            boolean canSend = entity.canSend(type);
            if (canSend != this.canSend.put(type, canSend)) {
                changed = true;
            }
            if ((canReceive = entity.canReceive(type)) != this.canReceive.put(type, canReceive)) {
                changed = true;
            }
            if (!changed) continue;
            Channel channel = this.getChannel(type);
            if (channel != null) {
                channel.updateTesseract(this);
            }
            this.markDirty();
        }
    }

    private void markDirty() {
        if (!this.isClientSide) {
            TesseractTracker.SERVER.markDirty(this);
        }
    }

    void delete() {
        for (EnumChannelType type : EnumChannelType.values()) {
            Channel channel = this.getChannel(type);
            if (channel == null) continue;
            channel.removeTesseract(this);
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
        return result;
    }
}

