/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.ChannelList;
import com.supermartijn642.tesseract.packets.PacketAddChannel;
import com.supermartijn642.tesseract.packets.PacketCompleteChannelsUpdate;
import com.supermartijn642.tesseract.packets.PacketRemoveChannel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;

public class TesseractChannelManager {
    public static final TesseractChannelManager SERVER = new TesseractChannelManager();
    public static final TesseractChannelManager CLIENT = new TesseractChannelManager();
    private final HashMap<EnumChannelType, ChannelList> types = new HashMap();

    public static TesseractChannelManager getInstance(boolean isClientSide) {
        return isClientSide ? CLIENT : SERVER;
    }

    public static TesseractChannelManager getInstance(class_1937 level) {
        return TesseractChannelManager.getInstance(level.field_9236);
    }

    public Channel addChannel(EnumChannelType type, UUID creator, boolean isPrivate, String name) {
        this.types.putIfAbsent(type, new ChannelList(type));
        Channel channel = this.types.get((Object)type).add(creator, isPrivate, name);
        this.sendAddChannelPacket(channel);
        return channel;
    }

    public Channel addChannel(Channel channel) {
        this.types.putIfAbsent(channel.type, new ChannelList(channel.type));
        this.types.get((Object)channel.type).add(channel);
        this.sendAddChannelPacket(channel);
        return channel;
    }

    public void removeChannel(EnumChannelType type, int id, class_1657 remover) {
        Channel channel = this.getChannelById(type, id);
        if (channel != null && (this == CLIENT || channel.creator.equals(remover.method_5667()) || remover.method_5687(2))) {
            this.types.putIfAbsent(type, new ChannelList(type));
            this.types.get((Object)type).remove(id);
            this.sendRemoveChannelPacket(type, id);
        }
    }

    public void sortChannels(class_1657 player, EnumChannelType type) {
        if (player == null || player.method_37908() == null || !player.method_37908().field_9236) {
            return;
        }
        this.types.putIfAbsent(type, new ChannelList(type));
        this.types.get((Object)type).sortForPlayer(player);
    }

    public List<Channel> getChannels(EnumChannelType type) {
        this.types.putIfAbsent(type, new ChannelList(type));
        return this.types.get((Object)type).getChannels();
    }

    public List<Channel> getChannelsCreatedBy(EnumChannelType type, UUID creator) {
        this.types.putIfAbsent(type, new ChannelList(type));
        return this.types.get((Object)type).getChannelsCreatedBy(creator);
    }

    public Channel getChannelById(EnumChannelType type, int id) {
        this.types.putIfAbsent(type, new ChannelList(type));
        return this.types.get((Object)type).getById(id);
    }

    public void clear() {
        for (EnumChannelType type : EnumChannelType.values()) {
            this.types.putIfAbsent(type, new ChannelList(type));
            this.types.get((Object)type).clear();
        }
    }

    public void sendCompleteUpdatePacket(class_1657 player) {
        if (this == SERVER) {
            Tesseract.CHANNEL.sendToPlayer(player, (BasePacket)new PacketCompleteChannelsUpdate(true));
        }
    }

    public void sendAddChannelPacket(Channel channel) {
        if (this == SERVER) {
            Tesseract.CHANNEL.sendToAllPlayers((BasePacket)new PacketAddChannel(channel));
        }
    }

    public void sendRemoveChannelPacket(EnumChannelType type, int id) {
        if (this == SERVER) {
            Tesseract.CHANNEL.sendToAllPlayers((BasePacket)new PacketRemoveChannel(type, id));
        }
    }

    public static void saveChannels(Path saveDirectory) {
        for (ChannelList list : TesseractChannelManager.SERVER.types.values()) {
            Path folder = saveDirectory.resolve("tesseract").resolve(list.type.name().toLowerCase(Locale.ENGLISH));
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                Tesseract.LOGGER.error("Failed to create channel save directory for '" + folder + "'!", (Throwable)e);
                continue;
            }
            list.write(folder);
        }
    }

    public static void loadChannels(Path saveDirectory) {
        for (EnumChannelType type : EnumChannelType.values()) {
            ChannelList list = new ChannelList(type);
            TesseractChannelManager.SERVER.types.put(type, list);
            Path folder = saveDirectory.resolve("tesseract").resolve(type.name().toLowerCase(Locale.ENGLISH));
            list.read(folder);
        }
    }

    public static void sendChannels(class_1657 player) {
        SERVER.sendCompleteUpdatePacket(player);
    }
}

