/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util.quadsearch;

import com.terraforged.engine.concurrent.cache.SafeCloseable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntBinaryOperator;

public class SearchContext
implements SafeCloseable {
    IntBinaryOperator STATUS_OPERATOR = Math::min;
    private final long timeoutNS;
    private final AtomicInteger tasks = new AtomicInteger(0);
    private final AtomicInteger status = new AtomicInteger(Integer.MAX_VALUE);

    public SearchContext() {
        this(Long.MAX_VALUE);
    }

    private SearchContext(long timeoutNS) {
        this.timeoutNS = timeoutNS;
    }

    public SearchContext(long timeout, TimeUnit unit) {
        long nanos = System.nanoTime() + unit.toNanos(timeout);
        this.timeoutNS = nanos < 0L ? Long.MAX_VALUE : nanos;
    }

    public SearchContext newWithTimeout() {
        return new SearchContext(this.timeoutNS);
    }

    public boolean hasTimedOut() {
        return System.nanoTime() > this.timeoutNS;
    }

    public boolean hasTasks() {
        return this.tasks.get() > 0;
    }

    public boolean isComplete(int status) {
        return status > this.status.get() || this.hasTimedOut();
    }

    public void submit(int status) {
        this.status.accumulateAndGet(status, this.STATUS_OPERATOR);
    }

    public SearchContext startTask() {
        this.tasks.incrementAndGet();
        return this;
    }

    public void endTask() {
        this.tasks.decrementAndGet();
    }

    @Override
    public void close() {
        this.endTask();
    }
}

